/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.StringUtils;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellPayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellPayTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellRefundStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.order.OrderPayTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.order.OrderPreSellOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderPresellExpandPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.OrderPresellExpandPO;
import com.wmeimob.fastboot.bizvane.po.OrderPresellExpandPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import com.wmeimob.fastboot.bizvane.vo.ReturnOfflineOrderRequestVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class OrderPresellExpandServiceImpl
implements OrderPresellExpandService {
    private static final Logger log = LoggerFactory.getLogger(OrderPresellExpandServiceImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private OrderPresellExpandPOMapper orderPresellExpandPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Value(value="${spring.application.name}")
    private String appName;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private WechatService wechatService;
    @Autowired
    private XxlJobUtil xxlJobUtil;

    @Override
    public List<OrderPresellExpandPO> queryByOrderNo(String orderNo) {
        OrderPresellExpandPOExample orderPresellExpandPOExample = new OrderPresellExpandPOExample();
        orderPresellExpandPOExample.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(Boolean.TRUE);
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandPOMapper.selectByExample(orderPresellExpandPOExample);
        return orderPresellExpandPOS;
    }

    @Override
    public List<OrderPresellExpandPO> queryByOrderId(Integer orderId) {
        OrderPresellExpandPOExample orderPresellExpandPOExample = new OrderPresellExpandPOExample();
        orderPresellExpandPOExample.createCriteria().andOrderIdEqualTo(orderId).andValidEqualTo(Boolean.TRUE);
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandPOMapper.selectByExample(orderPresellExpandPOExample);
        return orderPresellExpandPOS;
    }

    @Override
    public String paySuccess(String orderPresellNo, String transaction_id, Integer orderPreSellStatus) {
        OrderPresellExpandPOExample orderPresellExpandPOExample = new OrderPresellExpandPOExample();
        orderPresellExpandPOExample.createCriteria().andOrderPresellNoEqualTo(orderPresellNo).andValidEqualTo(Boolean.TRUE);
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandPOMapper.selectByExample(orderPresellExpandPOExample);
        OrderPresellExpandPO orderPresellExpandPO = orderPresellExpandPOS.get(0);
        OrderPresellExpandPO orderPresellExpandPOParam = new OrderPresellExpandPO();
        orderPresellExpandPOParam.setId(orderPresellExpandPO.getId());
        orderPresellExpandPOParam.setPayStatus(OrderPreSellPayStatusEnum.SUCCESS.getCode());
        orderPresellExpandPOParam.setTransactionId(transaction_id);
        orderPresellExpandPOParam.setGmtModified(new Date());
        this.orderPresellExpandPOMapper.updateByPrimaryKeySelective(orderPresellExpandPOParam);
        OrdersPO ordersPO = new OrdersPO();
        ordersPO.setPresellStatus(orderPreSellStatus);
        ordersPO.setGmtModified(new Date());
        OrdersPOExample ordersPOExample = new OrdersPOExample();
        ordersPOExample.createCriteria().andOrderNoEqualTo(orderPresellExpandPO.getOrderNo());
        int i = this.ordersPOMapper.updateByExampleSelective(ordersPO, ordersPOExample);
        log.info("\u66f4\u65b0\u8ba2\u5355presellStatus\u503c\u4e3a:{},count:{}", (Object)orderPreSellStatus, (Object)i);
        String orderNo = orderPresellExpandPO.getOrderNo();
        return orderNo;
    }

    @Override
    public void refundModify(String orderNo, String refundNo) {
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.queryByOrderNo(orderNo);
        for (OrderPresellExpandPO orderPresellExpandPO : orderPresellExpandPOS) {
            OrderPresellExpandPO orderPresellExpandPOParam;
            String refundPreSellNo;
            String orderPresellNo = orderPresellExpandPO.getOrderPresellNo();
            Integer id = orderPresellExpandPO.getId();
            if (orderPresellNo.contains("FIRST")) {
                refundPreSellNo = refundNo + "FIRST";
                orderPresellExpandPOParam = new OrderPresellExpandPO();
                orderPresellExpandPOParam.setId(id);
                orderPresellExpandPOParam.setGmtModified(new Date());
                orderPresellExpandPOParam.setRefundNo(refundNo);
                orderPresellExpandPOParam.setRefundPresellNo(refundNo + "FIRST");
                this.orderPresellExpandPOMapper.updateByPrimaryKeySelective(orderPresellExpandPOParam);
                log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355:{}\u65b0\u589e\u9000\u5355\u66f4\u65b0\u9000\u5355\u5355\u53f7\u4fe1\u606f:{}", (Object)orderNo, (Object)refundPreSellNo);
            }
            if (!orderPresellNo.contains("LAST")) continue;
            refundPreSellNo = refundNo + "LAST";
            orderPresellExpandPOParam = new OrderPresellExpandPO();
            orderPresellExpandPOParam.setId(id);
            orderPresellExpandPOParam.setGmtModified(new Date());
            orderPresellExpandPOParam.setRefundNo(refundNo);
            orderPresellExpandPOParam.setRefundPresellNo(refundNo + "LAST");
            this.orderPresellExpandPOMapper.updateByPrimaryKeySelective(orderPresellExpandPOParam);
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355:{}\u65b0\u589e\u9000\u5355\u66f4\u65b0\u9000\u5355\u5355\u53f7\u4fe1\u606f:{}", (Object)orderNo, (Object)refundPreSellNo);
        }
    }

    @Override
    public OrderPresellExpandPO queryByOrderNoWithType(String orderNo, Integer payType) {
        OrderPresellExpandPOExample orderPresellExpandPOExample = new OrderPresellExpandPOExample();
        orderPresellExpandPOExample.createCriteria().andOrderNoEqualTo(orderNo).andPayTypeEqualTo(payType).andValidEqualTo(Boolean.TRUE);
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandPOMapper.selectByExample(orderPresellExpandPOExample);
        if (CollectionUtils.isEmpty(orderPresellExpandPOS)) {
            return null;
        }
        return orderPresellExpandPOS.get(0);
    }

    @Override
    public OrderPresellExpandPO refundSuccess(String refundPreSellNo) {
        OrderPresellExpandPOExample orderPresellExpandPOExample = new OrderPresellExpandPOExample();
        orderPresellExpandPOExample.createCriteria().andRefundPresellNoEqualTo(refundPreSellNo).andValidEqualTo(Boolean.TRUE);
        List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandPOMapper.selectByExample(orderPresellExpandPOExample);
        OrderPresellExpandPO orderPresellExpandPO = orderPresellExpandPOS.get(0);
        Integer id = orderPresellExpandPO.getId();
        OrderPresellExpandPO orderPresellExpandPOParam = new OrderPresellExpandPO();
        orderPresellExpandPOParam.setId(id);
        orderPresellExpandPOParam.setRefundAt(new Date());
        orderPresellExpandPOParam.setRefundStatus(OrderPreSellRefundStatusEnum.SUCCESS.getCode());
        orderPresellExpandPOParam.setGmtModified(new Date());
        this.orderPresellExpandPOMapper.updateByPrimaryKeySelective(orderPresellExpandPOParam);
        return orderPresellExpandPO;
    }

    @Override
    public void closeOrder(Integer orderId) {
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        Integer presellStatus = ordersPO.getPresellStatus();
        String orderNo = ordersPO.getOrderNo();
        if (OrderPreSellStatusEnum.PART_DEFAULT.getCode().equals(presellStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u672a\u652f\u4ed8,return");
            return;
        }
        Integer merchantId = ordersPO.getMerchantId();
        if (OrderPayTypeEnum.OFF_LINE.getCode().equals(ordersPO.getPayType())) {
            log.info("\u7ebf\u4e0b\u652f\u4ed8\u5feb\u901f\u9000\u6b3e");
            if (OrderPreSellStatusEnum.PART_PAY_PORTION.getCode().equals(presellStatus)) {
                log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u9000\u8fd8\u5b9a\u91d1");
                this.refund_part(ordersPO, null);
            }
            if (OrderPreSellStatusEnum.PART_PAY_ALL.getCode().equals(presellStatus)) {
                log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u9000\u8fd8\u5b9a\u91d1+\u5c3e\u6b3e");
                this.refund_part(ordersPO, null);
                this.refund_balance(ordersPO, null);
            }
        }
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample(example);
        if (mchNew == null) {
            throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
        }
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(mchNew.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(mchNew.getMchKey());
        wechatMch.setMchNo(mchNew.getMchNo());
        wechatMch.setP12(mchNew.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        log.info("RefundOrderServiceImpl#updateRefundStatus wepay:{}", (Object)JSON.toJSONString((Object)wepay));
        if (OrderPreSellStatusEnum.PART_PAY_PORTION.getCode().equals(presellStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u9000\u8fd8\u5b9a\u91d1");
            this.refund_part(ordersPO, wepay);
        }
        if (OrderPreSellStatusEnum.PART_PAY_ALL.getCode().equals(presellStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u9000\u8fd8\u5b9a\u91d1+\u5c3e\u6b3e");
            this.refund_part(ordersPO, wepay);
            this.refund_balance(ordersPO, wepay);
        }
    }

    private void refund_balance(OrdersPO ordersPO, Wepay wepay) {
        OrderPresellExpandPO orderPresellExpandPO = this.queryByOrderNoWithType(ordersPO.getOrderNo(), OrderPreSellPayTypeEnum.PART_PAY_ALL.getCode());
        String refundPresellNo = orderPresellExpandPO.getRefundPresellNo();
        if (StringUtils.isEmpty((String)refundPresellNo)) {
            refundPresellNo = ordersPO.getOrderNo() + "REBALANCE";
        }
        log.info("wechat\u8ba2\u5355\u53f7:{}\u9000\u5c3e\u6b3e\u9000\u5355\u53f7:{}", (Object)ordersPO.getOrderNo(), (Object)refundPresellNo);
        RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
        refundApplyRequest.setOutTradeNo(orderPresellExpandPO.getOrderPresellNo());
        refundApplyRequest.setOutRefundNo(refundPresellNo);
        refundApplyRequest.setRefundFee(Integer.valueOf(orderPresellExpandPO.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        refundApplyRequest.setOpUserId("system");
        refundApplyRequest.setRefundDesc("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u5173\u95ed\u81ea\u52a8\u9000\u6b3e");
        refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
        refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
        refundApplyRequest.setTotalFee(Integer.valueOf(orderPresellExpandPO.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        if (OrderPayTypeEnum.OFF_LINE.getCode().equals(ordersPO.getPayType())) {
            log.info("\u7ebf\u4e0b\u76f4\u63a5\u9000\u6b3e");
            ReturnOfflineOrderRequestVO requestVO = new ReturnOfflineOrderRequestVO();
            requestVO.setMerchantId(ordersPO.getMerchantId());
            requestVO.setRefundOrderNo(orderPresellExpandPO.getRefundPresellNo());
            this.bizvaneInterface.refundOffLineOrder(requestVO);
            return;
        }
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u5c3e\u6b3e \u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
        try {
            RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
            log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
        }
        catch (WepayException e) {
            throw new CustomException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CustomException(e.getMessage());
        }
    }

    private void refund_part(OrdersPO ordersPO, Wepay wepay) {
        OrderPresellExpandPO orderPresellExpandPO = this.queryByOrderNoWithType(ordersPO.getOrderNo(), OrderPreSellPayTypeEnum.PART_PAY_PORTION.getCode());
        String refundPresellNo = orderPresellExpandPO.getRefundPresellNo();
        if (StringUtils.isEmpty((String)refundPresellNo)) {
            refundPresellNo = ordersPO.getOrderNo() + "REPART";
        }
        log.info("wechat\u8ba2\u5355\u53f7:{}\u9000\u5b9a\u91d1\u9000\u5355\u53f7:{}", (Object)ordersPO.getOrderNo(), (Object)refundPresellNo);
        RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
        refundApplyRequest.setOutTradeNo(orderPresellExpandPO.getOrderPresellNo());
        refundApplyRequest.setOutRefundNo(refundPresellNo);
        refundApplyRequest.setRefundFee(Integer.valueOf(orderPresellExpandPO.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        refundApplyRequest.setOpUserId("system");
        refundApplyRequest.setRefundDesc("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u5173\u95ed\u81ea\u52a8\u9000\u6b3e");
        refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
        refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
        refundApplyRequest.setTotalFee(Integer.valueOf(orderPresellExpandPO.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        if (OrderPayTypeEnum.OFF_LINE.getCode().equals(ordersPO.getPayType())) {
            log.info("\u7ebf\u4e0b\u76f4\u63a5\u9000\u6b3e");
            ReturnOfflineOrderRequestVO requestVO = new ReturnOfflineOrderRequestVO();
            requestVO.setMerchantId(ordersPO.getMerchantId());
            requestVO.setRefundOrderNo(orderPresellExpandPO.getRefundPresellNo());
            this.bizvaneInterface.refundOffLineOrder(requestVO);
            return;
        }
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u5b9a\u91d1 \u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
        try {
            RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
            log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
        }
        catch (WepayException e) {
            throw new CustomException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CustomException(e.getMessage());
        }
    }

    @Override
    public void addClosePartOrderJob(Integer orderId, OrderPresellExpandPO orderPresellExpandPO) {
        log.info("\u65b0\u589e\u5b9a\u91d1\u9884\u552e\u672a\u652f\u4ed8\u5b9a\u91d1\u81ea\u52a8\u5173\u95ed\u4efb\u52a1:{},orderPresellExpandPO:{}", (Object)orderId, (Object)JSON.toJSONString((Object)orderPresellExpandPO));
        Date jobTime = orderPresellExpandPO.getPayUtilAt();
        String jobDesc = "Order_cancel";
        String param = String.valueOf(orderId);
        String author = "mall_wechat";
        String jobHandler = "preSellOrderCancel";
        int businessType = 10002;
        String bizCode = param + "_orderCancel_part";
        String appName = this.appName;
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    @Override
    public void cancelClosePartOrderJob(Integer orderId) {
        log.info("\u5220\u9664\u5b9a\u91d1\u9884\u552e\u672a\u652f\u4ed8\u5b9a\u91d1\u81ea\u52a8\u5173\u95ed\u4efb\u52a1:{}", (Object)orderId);
        String param = String.valueOf(orderId);
        int businessType = 10002;
        String bizCode = param + "_orderCancel_part";
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
    }

    @Override
    public void addCloseBalanceOrderJob(Integer orderId, OrderPresellExpandPO orderPresellExpandPO) {
        log.info("\u65b0\u589e\u5b9a\u91d1\u9884\u552e\u672a\u652f\u4ed8\u5c3e\u6b3e\u81ea\u52a8\u5173\u95ed\u4efb\u52a1:{},orderPresellExpandPO:{}", (Object)orderId, (Object)JSON.toJSONString((Object)orderPresellExpandPO));
        Date jobTime = orderPresellExpandPO.getPayUtilAt();
        String jobDesc = "Order_cancel";
        String param = String.valueOf(orderId);
        String author = "mall_wechat";
        String jobHandler = "preSellOrderCancel";
        int businessType = 10002;
        String bizCode = param + "_orderCancel_balance";
        String appName = this.appName;
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    @Override
    public void cancelCloseBalanceOrderJob(Integer orderId) {
        log.info("\u5220\u9664\u5b9a\u91d1\u9884\u552e\u672a\u652f\u4ed8\u5c3e\u6b3e\u81ea\u52a8\u5173\u95ed\u4efb\u52a1:{}", (Object)orderId);
        String param = String.valueOf(orderId);
        int businessType = 10002;
        String bizCode = param + "_orderCancel_balance";
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
    }

    @Override
    public void createGoodsUnShelfJob(Integer goodsId, Date jobDate) {
        log.info("\u65b0\u589e\u5b9a\u91d1\u9884\u552e\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6job:{}", (Object)goodsId);
        Date jobTime = jobDate;
        String jobDesc = "_goodsUnShelf";
        String param = String.valueOf(goodsId);
        String author = "mall_admin";
        String jobHandler = "goodsUnShelf";
        int businessType = 10001;
        String bizCode = param + "_goodsUnShelf";
        String appName = this.appName;
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    @Override
    public void cancelGoodsUnShelfJob(Integer goodsId) {
        log.info("\u5220\u9664\u5b9a\u91d1\u9884\u552e\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6job:{}", (Object)goodsId);
        String param = String.valueOf(goodsId);
        int businessType = 10001;
        String bizCode = param + "_goodsUnShelf";
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
    }

    @Override
    public int cancelPreSellOrderPreprocessing(Integer orderId) {
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        Integer presellStatus = ordersPO.getPresellStatus();
        if (OrdersStatusEnum.FAIL.equals(ordersPO.getOrderStatus())) {
            log.info("\u5df2\u4e3b\u52a8\u53d6\u6d88\u7684\u8ba2\u5355\u4e0d\u7528\u518d\u64cd\u4f5c");
            return 0;
        }
        if (OrderPreSellStatusEnum.NONE.getCode().equals(presellStatus)) {
            log.info("\u975e\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u76f4\u63a5\u653e\u8fc7");
            return 0;
        }
        if (OrderPreSellStatusEnum.PART_DEFAULT.getCode().equals(presellStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u672a\u652f\u4ed8,return");
            return 0;
        }
        Integer presellOrderStatus = ordersPO.getPresellOrderStatus();
        if (OrderPreSellOrderStatusEnum.APPROVED.getCode().equals(presellOrderStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u5b9a\u91d1\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838,\u76f4\u63a5\u8fd4\u56de");
            return 0;
        }
        if (OrderPreSellOrderStatusEnum.TO_AUDIT.getCode().equals(presellOrderStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u5b9a\u91d1\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838,\u76f4\u63a5\u8fd4\u56de");
            return 1;
        }
        if (OrderPreSellStatusEnum.PART_PAY_PORTION.getCode().equals(presellStatus) && (OrderPreSellOrderStatusEnum.DEFAULT.getCode().equals(presellOrderStatus) || OrderPreSellOrderStatusEnum.REVIEW_THE_REJECTED.getCode().equals(presellOrderStatus))) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u652f\u4ed8\u8ba2\u5355,\u9000\u8fd8\u5b9a\u91d1\u65b0\u589e\u5ba1\u6838");
            OrdersPO ordersPOParam = new OrdersPO();
            ordersPOParam.setId(orderId);
            ordersPOParam.setPresellOrderStatus(OrderPreSellOrderStatusEnum.TO_AUDIT.getCode());
            ordersPOParam.setGmtModified(new Date());
            this.ordersPOMapper.updateByPrimaryKeySelective(ordersPOParam);
            return 1;
        }
        return 0;
    }
}

