/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.aftermarket.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.OrderAftermarketAppointment;
import com.wmeimob.fastboot.bizvane.newmapper.OrderAftermarketAppointmentMapper;
import com.wmeimob.fastboot.bizvane.service.aftermarket.AfterMarketAppointmentService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AfterMarketAppointmentServiceImpl
implements AfterMarketAppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AfterMarketAppointmentServiceImpl.class);
    @Autowired
    private OrderAftermarketAppointmentMapper orderAftermarketAppointmentMapper;

    @Override
    public ResponseData insertAppointment(OrderAftermarketAppointment appointment) {
        ResponseData responseData = new ResponseData();
        int insert = this.orderAftermarketAppointmentMapper.insert(appointment);
        if (insert == 1) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    @Override
    public PageInfo<OrderAftermarketAppointment> queryAppointmentListByMemberCode(Integer merchantId, String userNo, Integer sysBrandId, String queryInfo, Integer appointmentStatus, Date startDate, Date endDate, String pageNum, String pageSize) {
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        List<OrderAftermarketAppointment> appointmentList = this.orderAftermarketAppointmentMapper.queryAppointmentListByMemberCode(merchantId, sysBrandId, userNo, queryInfo, appointmentStatus, startDate, endDate);
        log.info("appointmentList:{}", appointmentList);
        if (CollectionUtils.isEmpty(appointmentList)) {
            return new PageInfo(new ArrayList());
        }
        return new PageInfo(appointmentList);
    }

    @Override
    public ResponseData updateCancelAppointment(Integer sysBrandId, Integer merchantId, String userNo, Integer orderAftermarketAppointmentId, String cancelReason) {
        ResponseData responseData = new ResponseData();
        int result = this.orderAftermarketAppointmentMapper.updateCancelAppointment(sysBrandId, merchantId, userNo, orderAftermarketAppointmentId, cancelReason);
        if (result == 1) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        return responseData;
    }

    @Override
    public ResponseData updateFinishAfterMarketAppointment(Integer merchantId, Integer orderAftermarketAppointmentId, String finishDescription) {
        ResponseData responseData = new ResponseData();
        int result = this.orderAftermarketAppointmentMapper.updateFinishAfterMarketAppointment(merchantId, orderAftermarketAppointmentId, finishDescription);
        if (result == 1) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        return responseData;
    }

    @Override
    public List<OrderAftermarketAppointment> queryAppointmentList(Integer merchantId, String userNo, String queryInfo, Integer appointmentStatus, Date startDate, Date endDate) {
        List<OrderAftermarketAppointment> appointmentList = this.orderAftermarketAppointmentMapper.queryAppointmentListByMemberCode(merchantId, null, userNo, queryInfo, appointmentStatus, startDate, endDate);
        return appointmentList;
    }
}

