/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.PayStatus;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.PushToWhereEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class AddOrderToEnterpriseListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(AddOrderToEnterpriseListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;

    public void onApplicationEvent(OrderEvent orderEvent) {
        if (Boolean.TRUE.booleanValue()) {
            log.info("\u5f03\u7528\u539f\u6709\u4f01\u5fae\u8ba2\u5355\u76d1\u542c");
            return;
        }
        log.info("AddOrderToEnterpriseListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)orderEvent)));
        Orders orders = orderEvent.getOrders();
        Orders newOrders = new Orders();
        BeanUtils.copyProperties((Object)orders, (Object)newOrders);
        Integer pushToWhere = orderEvent.getPushToWhere();
        Integer pushFlag = orderEvent.getPushFlag();
        CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
        companyBrandRelation.setMerchantId(orders.getMerchantId());
        companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
        newOrders.setSysCompanyId(companyBrandRelation.getCompanyId());
        newOrders = this.getGoodsImg(newOrders);
        log.info("orders:{}", (Object)JSON.toJSONString((Object)orders));
        Orders finalOrders = newOrders;
        this.scheduledThreadPoolExecutor.execute(() -> {
            Boolean push = Boolean.TRUE;
            if (pushFlag.equals(PushFlagEnum.ADD_PAID_ORDERS.getPushFlag()) || pushFlag.equals(PushFlagEnum.Add_ORDER.getPushFlag())) {
                if (pushToWhere.equals(PushToWhereEnum.TO_QIWEI_FIRST_ORDER.getPushToWhere()) || pushToWhere.equals(PushToWhereEnum.TO_CONNECTOR_AND_FIRST_ORDER_QW.getPushToWhere())) {
                    log.info("\u521b\u5efa\u8ba2\u5355\u63a8\u9001\u4f01\u5fae\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb-\u9996\u5355");
                    try {
                        log.info("\u4e13\u5c5e\u7684\u5546\u54c1\u88ab\u4e0b\u5355\u63a8\u9001\u4f01\u5fae");
                        this.bizvaneInterface.notifyNewOrderInfoToQW(finalOrders);
                    }
                    catch (Exception e) {
                        log.error("\u521b\u5efa\u4e13\u5c5e\u8ba2\u5355\u63a8\u9001\u4f01\u5fae\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                    }
                    finally {
                        push = Boolean.FALSE;
                    }
                }
                try {
                    log.info("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae");
                    this.bizvaneInterface.notifyOrderInfoToQWFirst(finalOrders);
                }
                catch (Exception e) {
                    log.error("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae\u5931\u8d25:{}_{}", (Object)e.getMessage(), (Object)e);
                }
                try {
                    this.sendMsgToQWService.sendOrdersGoodssMsg(finalOrders, 4);
                }
                catch (Exception e) {
                    log.error("\u4e0b\u5355\u901a\u77e5\u4f01\u5fae\u901a\u77e5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                }
            }
            Integer payStatus = orderEvent.getPayStatus();
            if (PayStatus.PAY_SUCCESS.getPayStatus().equals(payStatus)) {
                log.info("\u8ba2\u5355\u4ed8\u6b3e\u63a8\u9001\u4f01\u5fae\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb");
                try {
                    this.bizvaneInterface.notifyPaidOrderInfoToQW(finalOrders);
                }
                catch (Exception e) {
                    log.error("\u8ba2\u5355\u4ed8\u6b3e\u63a8\u9001\u4f01\u5fae\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (PayStatus.PAY_SUCCESS.getPayStatus().equals(payStatus)) {
                log.info("\u4ed8\u6b3e\u540e\u4e0d\u63a8\u9001\u4f01\u5fae!");
                return;
            }
            if (push.booleanValue() && (pushFlag.equals(PushFlagEnum.ADD_PAID_ORDERS.getPushFlag()) || pushFlag.equals(PushFlagEnum.Add_ORDER.getPushFlag()))) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    try {
                        log.info("\u521b\u5efa\u8ba2\u5355\u63a8\u9001\u4f01\u5fae\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb-\u975e\u9996\u5355");
                        this.bizvaneInterface.notifyNewOrderInfoToQW(finalOrders);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
        });
    }

    private Orders getGoodsImg(Orders newOrders) {
        newOrders.getItems().forEach(e -> {
            GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
            goodsSkuDetail.setGoodsId(e.getGoodsId());
            goodsSkuDetail.setSkuNo(e.getGoodsSkuNo());
            goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne(goodsSkuDetail);
            if (goodsSkuDetail != null) {
                e.setGoodsImg(goodsSkuDetail.getSkuImg());
            }
        });
        return newOrders;
    }
}

