/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static char char2Int(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (char)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (char)(ch - 97 + 10);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (char)(ch - 65 + 10);
        }
        return ' ';
    }

    private static byte str2Bin(char[] str) {
        char[] tempWord = new char[]{MD5Util.char2Int(str[0]), MD5Util.char2Int(str[1])};
        byte chn = (byte)(tempWord[0] << 4 | tempWord[1]);
        return chn;
    }

    public static byte[] compress(char[] md5chs32len) {
        char[] tem = new char[2];
        byte[] sDst = new byte[md5chs32len.length / 2];
        int j = 0;
        int i = 0;
        while (i + 1 < md5chs32len.length) {
            tem[0] = md5chs32len[i];
            tem[1] = md5chs32len[i + 1];
            sDst[j++] = MD5Util.str2Bin(tem);
            i += 2;
        }
        return sDst;
    }

    public static String unCompress(byte[] md5b16) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < md5b16.length; ++i) {
            byte b = md5b16[i];
            sb.append(Integer.toHexString(b >> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] getMD5Byte16(String text) {
        String md5 = MD5Util.getMD5Str32(text);
        if (md5 != null) {
            return MD5Util.compress(md5.toCharArray());
        }
        return null;
    }

    public static String getMD5Str32(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return MD5Util.byteToHexString(messageDigest.digest());
    }

    private static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        String s = new String(str);
        return s;
    }
}

