/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.open.loader;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.wechat.open.loader.WechatAuthorizerAccessTokenLoader;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import java.util.concurrent.TimeUnit;
import me.hao0.wechat.model.base.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DefaultWechatAuthorizerAccessTokenLoader
implements WechatAuthorizerAccessTokenLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultWechatAuthorizerAccessTokenLoader.class);
    private StringRedisTemplate stringRedisTemplate;

    public DefaultWechatAuthorizerAccessTokenLoader(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    private DefaultWechatAuthorizerAccessTokenLoader() {
    }

    public AccessToken get(String appid) {
        AccessToken accessToken = (AccessToken)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)("opens:authorizer_appids:" + appid + ":access_token"))), AccessToken.class);
        log.info("appid {} access_token info =>{}", (Object)appid, (Object)JSONObject.toJSONString((Object)accessToken));
        return accessToken;
    }

    public void set(AuthorizationInfo authorizationInfo) {
        Long validTime = (long)authorizationInfo.getExpiresIn().intValue() - 600L;
        authorizationInfo.setExpiredAt(Long.valueOf(System.currentTimeMillis() + validTime * 1000L));
        AccessToken accessToken = new AccessToken();
        accessToken.setAccessToken(authorizationInfo.getAuthorizerAccessToken());
        accessToken.setExpiredAt(authorizationInfo.getExpiredAt());
        accessToken.setExpire(authorizationInfo.getExpiresIn());
        this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + authorizationInfo.getAuthorizerAppid() + ":access_token"), (Object)JSONObject.toJSONString((Object)accessToken), validTime.longValue(), TimeUnit.SECONDS);
    }
}

