/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.addorder.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.event.addorder.OrderAddEvent;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OrderAddEnterpriseListener
implements ApplicationListener<OrderAddEvent> {
    private static final Logger log = LoggerFactory.getLogger(OrderAddEnterpriseListener.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;

    public void onApplicationEvent(OrderAddEvent orderAddEvent) {
        log.info("OrderAddEnterpriseListener#OrderAddEvent:{}", (Object)JSON.toJSONString((Object)((Object)orderAddEvent)));
        Orders orders = orderAddEvent.getOrders();
        String orderNo = orders.getOrderNo();
        String ordersActivityType = orders.getOrdersActivityType();
        ArrayList<String> pushTypeList = new ArrayList<String>();
        pushTypeList.add(OrderActivityTypeEnum.PT.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.ZB.getCode().toString());
        HashMap<String, OrderActivityTypeEnum> orderActivityTypeEnumHashMap = new HashMap<String, OrderActivityTypeEnum>();
        OrderActivityTypeEnum[] values = OrderActivityTypeEnum.values();
        for (int i = 0; i < values.length; ++i) {
            OrderActivityTypeEnum value = values[i];
            String key = value.getCode().toString();
            orderActivityTypeEnumHashMap.put(key, value);
        }
        if (!pushTypeList.contains(ordersActivityType)) {
            OrderActivityTypeEnum orderActivityTypeEnum = (OrderActivityTypeEnum)((Object)orderActivityTypeEnumHashMap.get(ordersActivityType));
            log.info("\u8ba2\u5355:{}\u7684\u7c7b\u578b\u4e3a:{},\u6682\u65f6\u4e0d\u63a8\u9001\u4f01\u5fae", (Object)orderNo, (Object)orderActivityTypeEnum.getDesc());
            return;
        }
        try {
            this.bizvaneInterface.notifyNewOrderInfoToQW(orders);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u6210\u529f\u8ba2\u5355\u63a8\u9001\u4f01\u5faeerror:{}", (Throwable)e);
        }
        try {
            log.info("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae");
            this.bizvaneInterface.notifyOrderInfoToQWFirst(orders);
        }
        catch (Exception e) {
            log.error("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae\u5931\u8d25:{}_{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.sendMsgToQWService.sendOrdersGoodssMsg(orders, 4);
        }
        catch (Exception e) {
            log.error("\u4e0b\u5355\u901a\u77e5\u4f01\u5fae\u901a\u77e5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
    }
}

