/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.activity;

import com.wmeimob.fastboot.bizvane.activity.PostActivityDataContainer;
import com.wmeimob.fastboot.bizvane.activity.PostActivityProcessor;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityCombinationGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPO;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityVO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CombinationActivityProcessor
implements PostActivityProcessor {
    @Autowired
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private ActivityCombinationGoodsPOMapper activityCombinationGoodsPOMapper;

    @Override
    public ActivitySanEnum processFor() {
        return ActivitySanEnum.COMBINATION;
    }

    @Override
    public void beforeAddActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        CombinationActivityVO combinationActivityVO = dataContainer.get(CombinationActivityVO.class);
        ActivityPO activityPO = combinationActivityVO.getActivityPO();
        List<CombinationActivityGoodsVO> goodsList = combinationActivityVO.getGoodsList();
        this.validGoods(goodsList);
    }

    private void validGoods(List<CombinationActivityGoodsVO> goodsList) throws MallCommonException {
        if (goodsList.size() > 5) {
            throw new MallCommonException("\u7ec4\u5408\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e4\uff01");
        }
        goodsList.stream().forEach(good -> {
            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(good.getGoodsId());
            if (goodsPO.getLimitation() > 0) {
                throw new MallCommonException("\u8be5\u5546\u54c1\u4e3a\u9650\u8d2d\u5546\u54c1\uff0c\u6682\u4e0d\u652f\u6301\u9009\u62e9\uff01");
            }
            if (goodsPO.getIsPreSale() != null && goodsPO.getIsPreSale().booleanValue()) {
                throw new MallCommonException("\u8be5\u5546\u54c1\u4e3a\u9884\u552e\u5546\u54c1\uff0c\u6682\u4e0d\u652f\u6301\u9009\u62e9\uff01");
            }
        });
    }

    private void validActivityTime(ActivityPO activityPO) {
        Date now = new Date();
        if (now.after(activityPO.getBeginDate())) {
            throw new MallCommonException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (activityPO.getBeginDate().after(activityPO.getEndDate())) {
            throw new MallCommonException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
    }

    @Override
    public void afterAddActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        CombinationActivityVO combinationActivityVO = dataContainer.get(CombinationActivityVO.class);
        ActivityPO activityPO = combinationActivityVO.getActivityPO();
        List<CombinationActivityGoodsVO> goodsList = combinationActivityVO.getGoodsList();
        this.insertCombonationActivityGoods(activityPO, goodsList);
    }

    private void insertCombonationActivityGoods(ActivityPO activityPO, List<CombinationActivityGoodsVO> goodsList) {
        Integer activityId = activityPO.getId();
        Date date = new Date();
        Integer mainGoodsId = (Integer)goodsList.stream().filter(CombinationActivityGoodsVO::getIsMainGoods).map(CombinationActivityGoodsVO::getGoodsId).collect(Collectors.toList()).get(0);
        goodsList.stream().forEach(e -> {
            ActivityCombinationGoodsPO activityCombinationGoodsPO = new ActivityCombinationGoodsPO();
            activityCombinationGoodsPO.setActivityId(activityId);
            activityCombinationGoodsPO.setGmtCreate(date);
            activityCombinationGoodsPO.setGoodsId(e.getGoodsId());
            activityCombinationGoodsPO.setMerchantId(activityPO.getMerchantId());
            activityCombinationGoodsPO.setSalePrice(e.getCombinationPrice());
            activityCombinationGoodsPO.setIsDel(Boolean.FALSE);
            activityCombinationGoodsPO.setValid(Boolean.TRUE);
            activityCombinationGoodsPO.setActivityType(ActivitySanEnum.COMBINATION.getCode());
            activityCombinationGoodsPO.setIsMustBuy(e.getIsMustSale());
            activityCombinationGoodsPO.setPid(mainGoodsId);
            activityCombinationGoodsPO.setIsMainGoods(Boolean.FALSE);
            if (e.getIsMainGoods().booleanValue()) {
                activityCombinationGoodsPO.setIsMustBuy(Boolean.TRUE);
                activityCombinationGoodsPO.setIsMainGoods(Boolean.TRUE);
                activityCombinationGoodsPO.setPid(0);
            }
            this.activityCombinationGoodsPOMapper.insert(activityCombinationGoodsPO);
        });
    }

    @Override
    public void beforeUpdateActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        CombinationActivityVO combinationActivityVO = dataContainer.get(CombinationActivityVO.class);
        ActivityPO activityPO = combinationActivityVO.getActivityPO();
        List<CombinationActivityGoodsVO> goodsList = combinationActivityVO.getGoodsList();
        this.validGoods(goodsList);
    }

    @Override
    public void afterUpdateActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        CombinationActivityVO combinationActivityVO = dataContainer.get(CombinationActivityVO.class);
        ActivityPO activityPO = combinationActivityVO.getActivityPO();
        Date date = new Date();
        List<CombinationActivityGoodsVO> goodsList = combinationActivityVO.getGoodsList();
        ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
        activityCombinationGoodsPOExample.createCriteria().andMerchantIdEqualTo(activityPO.getMerchantId()).andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityPO.getId());
        ActivityCombinationGoodsPO activityCombinationGoodsPO = new ActivityCombinationGoodsPO();
        activityCombinationGoodsPO.setValid(Boolean.FALSE);
        activityCombinationGoodsPO.setGmtModified(date);
        this.activityCombinationGoodsPOMapper.updateByExampleSelective(activityCombinationGoodsPO, activityCombinationGoodsPOExample);
        this.insertCombonationActivityGoods(activityPO, goodsList);
    }
}

