/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.baison.config.BaisonConfig;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaisonUtil2 {
    private static final Logger log = LoggerFactory.getLogger(BaisonUtil2.class);
    @Resource
    private BaisonConfig baisonConfig;
    private static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    private static String FORMAT = "json";

    public BaisonResponseDTO getBaiSonE3Response(String methodName, String data) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        String datetime = BaisonUtil2.getRequestTime();
        paramMap.put("key", this.baisonConfig.getKey());
        paramMap.put("requestTime", datetime);
        paramMap.put("secret", this.baisonConfig.getSecret());
        paramMap.put("version", this.baisonConfig.getVersion());
        paramMap.put("serviceType", methodName);
        paramMap.put("sign", this.getSign(paramMap, data));
        paramMap.put("data", data);
        paramMap.remove("secret");
        paramMap.put("format", FORMAT);
        String url = this.getReqStr(paramMap);
        BaisonResponseDTO result = null;
        try {
            result = this.Okhttp(url);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        log.info("E3\u8bf7\u6c42\uff1amethod\uff1a{}--param:{}", (Object)methodName, (Object)JSON.toJSONString((Object)data));
        return result;
    }

    private String getReqStr(Map<String, Object> param) {
        StringBuilder reqParamStr = new StringBuilder();
        if (param != null) {
            reqParamStr.append(this.baisonConfig.getAccessToken).append("&");
            param.forEach((k, v) -> reqParamStr.append((String)k).append("=").append(v).append("&"));
        }
        return reqParamStr.deleteCharAt(reqParamStr.length() - 1).toString();
    }

    private BaisonResponseDTO Okhttp(String url) throws Exception {
        Response response = null;
        Request request = new Request.Builder().get().tag((Object)this).url(url).build();
        log.info("\u8bf7\u6c42\u5b8c\u6574\u8def\u5f84\uff1a{}", (Object)request);
        try {
            OkHttpClient client = new OkHttpClient();
            response = client.newCall(request).execute();
        }
        catch (SocketTimeoutException client) {
            // empty catch block
        }
        String responseText = response.body().string();
        BaisonResponseDTO baisonResponseDTO = (BaisonResponseDTO)JSONObject.parseObject((String)responseText, BaisonResponseDTO.class);
        return baisonResponseDTO;
    }

    private String getSign(Map<String, Object> authMap, String data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> m : authMap.entrySet()) {
            sb.append(m.getKey()).append("=").append(m.getValue()).append("&");
        }
        sb.append("data=").append(data);
        log.info("\u52a0\u5bc6\u53c2\u6570\uff1a{}", (Object)sb.toString());
        return this.getMD5(sb.toString());
    }

    private String getMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRequestTime() {
        LocalDateTime time = LocalDateTime.now(ZoneId.systemDefault());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        return dateTimeFormatter.format(time);
    }
}

