/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.response;

import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import io.swagger.annotations.ApiModel;

@ApiModel(value="\u8f93\u51fa\u7ed3\u679c\u96c6")
public class Result<T>
extends ResponseData<T> {
    private static final long serialVersionUID = 8379936992006841441L;
    private Long total;
    private boolean success;

    public static <T> Result<T> newResult() {
        return new Result<T>();
    }

    public static <T> Result<T> success(T data, Integer code, String message) {
        Result<T> result = Result.newResult();
        result.setData(data);
        result.setCode(code);
        result.setMessage(message);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success(T data, Long total) {
        Result<T> result = Result.newResult();
        result.setData(data);
        result.setTotal(total);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = Result.newResult();
        result.setData(data);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success() {
        Result<T> result = Result.newResult();
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> failure(String message) {
        Result<T> result = Result.newResult();
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(Integer errorCode, String message) {
        Result<T> result = Result.newResult();
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(T t, Integer errorCode, String message) {
        Result<T> result = Result.newResult();
        result.setData(t);
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Long getTotal() {
        return this.total;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String toString() {
        return "Result(total=" + this.getTotal() + ", success=" + this.isSuccess() + ")";
    }
}

