/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils;

import com.wmeimob.fastboot.bizvane.enums.PeriodRuleEnum;
import com.wmeimob.fastboot.bizvane.enums.SaleFlagEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;

public class SaleUtil {
    public static Integer getCurrentSaleFlag(Integer type, String rule, Long saleBeginTime, Long saleEndTime) {
        if (type == null || saleBeginTime == null || saleEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        PeriodRuleEnum currentType = PeriodRuleEnum.getByCode(type);
        if (currentType == null) {
            throw new MallCommonException("\u672a\u627e\u5230\u5bf9\u5e94\u5468\u671f\u89c4\u5219\u7c7b\u578b");
        }
        DateTime dateTime = new DateTime();
        long timeOffset = dateTime.getSecondOfDay();
        boolean inCurrentTime = timeOffset >= saleBeginTime && timeOffset <= saleEndTime;
        Integer currentSaleFlag = 0;
        switch (currentType) {
            case DAY: {
                currentSaleFlag = inCurrentTime ? SaleFlagEnum.FOR_SALE.getCode() : SaleFlagEnum.NOT_FOR_SALE.getCode();
                break;
            }
            case WEEK: {
                String[] week = rule.split(",");
                String dayOfWeek = dateTime.getDayOfWeek() + "";
                List<String> weekList = Arrays.asList(week);
                currentSaleFlag = weekList.contains(dayOfWeek) && inCurrentTime ? SaleFlagEnum.FOR_SALE.getCode() : SaleFlagEnum.NOT_FOR_SALE.getCode();
                break;
            }
            case MONTH: {
                String[] month = rule.split(",");
                String dayOfMonth = dateTime.getDayOfMonth() + "";
                List<String> monthList = Arrays.asList(month);
                currentSaleFlag = monthList.contains(dayOfMonth) && inCurrentTime ? SaleFlagEnum.FOR_SALE.getCode() : SaleFlagEnum.NOT_FOR_SALE.getCode();
                break;
            }
            case CUSTOMIZE: {
                String[] date = rule.split(",");
                Date begin = DateUtil.parse(date[0], DateUtil.ymd);
                Date end = DateUtil.parse(date[1] + " " + DateUtil.parseTime(saleEndTime), DateUtil.ymdhms);
                Date currentTime = dateTime.toDate();
                if (currentTime.compareTo(end) > 0) {
                    currentSaleFlag = SaleFlagEnum.NOT_FOR_SALE.getCode();
                    break;
                }
                if (currentTime.compareTo(begin) >= 0 && inCurrentTime) {
                    currentSaleFlag = SaleFlagEnum.FOR_SALE.getCode();
                    break;
                }
                currentSaleFlag = SaleFlagEnum.NOT_FOR_SALE.getCode();
                break;
            }
        }
        return currentSaleFlag;
    }
}

