/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class GeoHash {
    public static final double MINLAT = -90.0;
    public static final double MAXLAT = 90.0;
    public static final double MINLNG = -180.0;
    public static final double MAXLNG = 180.0;
    private static int numbits = 15;
    private static double minLat;
    private static double minLng;
    private static final char[] digits;
    static final HashMap<Character, Integer> lookup;

    public GeoHash() {
        this.setMinLatLng();
    }

    public static String encode(double lat, double lon) {
        BitSet latbits = GeoHash.getBits(lat, -90.0, 90.0);
        BitSet lonbits = GeoHash.getBits(lon, -180.0, 180.0);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numbits; ++i) {
            buffer.append(lonbits.get(i) ? (char)'1' : '0');
            buffer.append(latbits.get(i) ? (char)'1' : '0');
        }
        String code = GeoHash.base32(Long.parseLong(buffer.toString(), 2));
        return code;
    }

    public ArrayList<String> getArroundGeoHash(double lat, double lon) {
        ArrayList<String> list = new ArrayList<String>();
        double uplat = lat + minLat;
        double downLat = lat - minLat;
        double leftlng = lon - minLng;
        double rightLng = lon + minLng;
        String leftUp = GeoHash.encode(uplat, leftlng);
        list.add(leftUp);
        String leftMid = GeoHash.encode(lat, leftlng);
        list.add(leftMid);
        String leftDown = GeoHash.encode(downLat, leftlng);
        list.add(leftDown);
        String midUp = GeoHash.encode(uplat, lon);
        list.add(midUp);
        String midMid = GeoHash.encode(lat, lon);
        list.add(midMid);
        String midDown = GeoHash.encode(downLat, lon);
        list.add(midDown);
        String rightUp = GeoHash.encode(uplat, rightLng);
        list.add(rightUp);
        String rightMid = GeoHash.encode(lat, rightLng);
        list.add(rightMid);
        String rightDown = GeoHash.encode(downLat, rightLng);
        list.add(rightDown);
        return list;
    }

    private static BitSet getBits(double lat, double floor, double ceiling) {
        BitSet buffer = new BitSet(numbits);
        for (int i = 0; i < numbits; ++i) {
            double mid = (floor + ceiling) / 2.0;
            if (lat >= mid) {
                buffer.set(i);
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return buffer;
    }

    private static String base32(long i) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = digits[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private void setMinLatLng() {
        int i;
        minLat = 180.0;
        for (i = 0; i < numbits; ++i) {
            minLat /= 2.0;
        }
        minLng = 360.0;
        for (i = 0; i < numbits; ++i) {
            minLng /= 2.0;
        }
    }

    private static double decode(BitSet bs, double floor, double ceiling) {
        double mid = 0.0;
        for (int i = 0; i < bs.length(); ++i) {
            mid = (floor + ceiling) / 2.0;
            if (bs.get(i)) {
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return mid;
    }

    public static double[] decode(String geohash) {
        boolean isSet;
        int i;
        StringBuilder buffer = new StringBuilder();
        for (char c : geohash.toCharArray()) {
            int i2 = lookup.get(Character.valueOf(c)) + 32;
            buffer.append(Integer.toString(i2, 2).substring(1));
        }
        BitSet lonset = new BitSet();
        BitSet latset = new BitSet();
        int j = 0;
        for (i = 0; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            lonset.set(j++, isSet);
        }
        j = 0;
        for (i = 1; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            latset.set(j++, isSet);
        }
        double lon = GeoHash.decode(lonset, -180.0, 180.0);
        double lat = GeoHash.decode(latset, -90.0, 90.0);
        return new double[]{lat, lon};
    }

    static {
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        lookup = new HashMap();
        int i = 0;
        for (char c : digits) {
            lookup.put(Character.valueOf(c), i++);
        }
    }
}

