/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.activity;

import com.wmeimob.fastboot.bizvane.activity.PostActivityDataContainer;
import com.wmeimob.fastboot.bizvane.activity.PostActivityProcessor;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PostActivityProcessorRouter
implements InitializingBean {
    @Autowired(required=false)
    private List<PostActivityProcessor> postActivityProcessors = new ArrayList<PostActivityProcessor>(16);
    private Map<ActivitySanEnum, PostActivityProcessor> processorMap;

    public void afterPropertiesSet() throws Exception {
        this.processorMap = this.postActivityProcessors.stream().collect(Collectors.toMap(PostActivityProcessor::processFor, Function.identity()));
    }

    public void beforeAddActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        this.process(dataContainer, processor -> processor.beforeAddActivity(dataContainer));
    }

    public void afterAddActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        this.process(dataContainer, processor -> processor.afterAddActivity(dataContainer));
    }

    public void beforeUpdateActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        this.process(dataContainer, processor -> processor.beforeUpdateActivity(dataContainer));
    }

    public void afterUpdateActivity(PostActivityDataContainer dataContainer) throws MallCommonException {
        this.process(dataContainer, processor -> processor.afterUpdateActivity(dataContainer));
    }

    private void process(PostActivityDataContainer dataContainer, PostActivityProcessorHolder holder) throws MallCommonException {
        PostActivityProcessor processor = this.processorMap.get((Object)ActivitySanEnum.getByType(dataContainer.getActivityPO().getType()));
        if (processor != null) {
            holder.process(processor);
        }
    }

    static interface PostActivityProcessorHolder {
        public void process(PostActivityProcessor var1) throws MallCommonException;
    }
}

