/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.skd361;

import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.constants.Constants361;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBasics {
    private static final Logger log = LoggerFactory.getLogger(ClientBasics.class);

    public static String encodeURL(String url, String charset) {
        try {
            return URLEncoder.encode(url, charset).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("ClientBasics#encodeURL\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String strMd5(String origin) {
        log.info("\u6392\u5e8f\u540e\u52a0\u5bc6\u524d:{}", (Object)origin);
        String result = "";
        try {
            result = ClientBasics.encodeByMD5(origin, "UTF-8");
        }
        catch (Exception e) {
            log.warn("ClientBasics#strMd5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    public static String encodeByMD5(String str, String encode) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes(encode));
            return ClientBasics.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(Constants361.HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(Constants361.HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }

    public static String strAsc(String origin) {
        log.info("\u6392\u5e8f\u524d:{}", (Object)origin);
        StringBuilder result = new StringBuilder();
        char[] originChars = origin.replace(" ", "").toLowerCase().toCharArray();
        Arrays.sort(originChars);
        for (char s : originChars) {
            result.append(s);
        }
        return result.toString();
    }

    public static HashMap<String, String> rest(String serviceUrl, String parameter, String restMethod) {
        log.info("serviceUrl===>" + serviceUrl + "=================>" + parameter + "==============>" + restMethod);
        try {
            String strMessage;
            URL url = new URL(serviceUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(restMethod);
            con.setConnectTimeout(300000);
            con.addRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(parameter.getBytes("UTF-8"));
            os.close();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("code", String.valueOf(con.getResponseCode()));
            result.put("msg", con.getResponseMessage());
            InputStream inputStream = con.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder buffer = new StringBuilder();
            while ((strMessage = reader.readLine()) != null) {
                buffer.append(strMessage);
            }
            result.put("result", buffer.toString());
            return result;
        }
        catch (Exception e) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("code", "100");
            result.put("msg", e.getMessage());
            result.put("result", "Failed,Pls Check your url to verify it right");
            return result;
        }
    }
}

