/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RefundGoodsEventListener
implements ApplicationListener<RefundEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefundGoodsEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;

    public void onApplicationEvent(RefundEvent refundEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                log.info("RefundGoodsEventListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)refundEvent)));
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                Integer pushFlag = refundEvent.getPushFlag();
                if (pushFlag != null && pushFlag.equals(PushFlagEnum.REFUND_GOODS.getPushFlag()) && refundOrder != null && refundOrder.getRefundType().equals(2)) {
                    log.info("\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    refundOrder.getItems().forEach(e -> {
                        String[] split;
                        String specIds = e.getSpecIds();
                        if (!StringUtils.isEmpty((String)specIds) && (split = specIds.split(",")) != null && split.length > 0) {
                            GoodsSpec goodsSpec;
                            if (split.length >= 1) {
                                goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(split[0]);
                                e.setSpecCode(goodsSpec.getSpecCode());
                            }
                            if (split.length >= 2) {
                                goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(split[1]);
                                e.setSpecCode(e.getSpecCode() + "," + goodsSpec.getSpecCode());
                            }
                        }
                    });
                    log.info("\u9000\u8d27\u9000\u6b3e\u5904\u7406\u5b8c\u6210\u6570\u636e:[{}]", JSON.toJSON((Object)refundOrder));
                    this.bizvaneInterface.notifyRefundGoodsInfo(refundOrder);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        });
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                Integer pushFlag = refundEvent.getPushFlag();
                if (pushFlag != null && pushFlag.equals(PushFlagEnum.REFUND_GOODS.getPushFlag()) && refundOrder != null && refundOrder.getRefundType().equals(2)) {
                    log.info("\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    this.bizvaneInterface.notifyRefundQW(refundEvent.getRefundOrder());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

