/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.PostRequest;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.WeixinProperties;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.GoodsBusinessVO;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardRequestVo;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardResponseVo;
import com.wmeimob.fastboot.bizvane.dto.OrdersDTO;
import com.wmeimob.fastboot.bizvane.dto.RefundDTO;
import com.wmeimob.fastboot.bizvane.dto.RefundGoodsReq;
import com.wmeimob.fastboot.bizvane.dto.RefundReq;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.dto.SysParamConfigurationDTO;
import com.wmeimob.fastboot.bizvane.dto.SysStoreVo;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.dto.WxqyLoginResponseVO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.entity.KafkaTrack;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.MallConnectorSendEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MerchantOfflineConfigPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.MerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.po.MerchantOfflineConfigPOExample;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.service.SendOrderMsgRecordService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.BaseResponse;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.GetStockRequestVO;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.GetStockResponseVO;
import com.wmeimob.fastboot.bizvane.utils.RedisClient;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.BrowseVO;
import com.wmeimob.fastboot.bizvane.vo.CreateMiniprgmQRCodeRequestVO;
import com.wmeimob.fastboot.bizvane.vo.DrawOrderGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.OrderGoodsListVO;
import com.wmeimob.fastboot.bizvane.vo.OrderGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.ViewGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.ViewShareGoodsInformRequestVO;
import com.wmeimob.fastboot.bizvane.vo.fegin.IntegralOrderRequestVo;
import com.wmeimob.fastboot.bizvane.vo.fegin.MemberInfoModel;
import com.wmeimob.fastboot.bizvane.vo.fegin.ShareGoodsOperatorRequestVO;
import com.wmeimob.fastboot.bizvane.vo.selfpick.SelfPickNoticeRequestVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.base.JSCode2SessionResponse;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Component
public class BizvaneInterface {
    private static final Logger log = LoggerFactory.getLogger(BizvaneInterface.class);
    @Resource
    private BizvaneProperties bizvaneProperties;
    @Resource
    private QiNiuProperties qiNiuProperties;
    @Resource
    private WeixinProperties weixinProperties;
    @Autowired
    private WechatMchNewMapper wechatMchNewMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private MallLogsService mallLogsService;
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource(name="commonUserCommissionService")
    private UserCommissionService userCommissionService;
    @Autowired
    @Lazy
    private SendOrderMsgRecordService sendOrderMsgRecordService;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Resource
    private MerchantOfflineConfigPOMapper merchantOfflineConfigPOMapper;
    private static final long DAY_MILLISECOND = 86400000L;

    public JSONObject getMiniprogramRedirectConfiguration(final String appid) {
        String url = this.bizvaneProperties.getMiniprogramRedirectConfigUrl();
        HashMap map = new HashMap(){
            {
                this.put("appId", appid);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u914d\u7f6e").getJSONObject("data");
        return data;
    }

    public static CouponDTO getCouponDTOByDetailData(JSONObject data) {
        data.getJSONObject("couponEntityPO").put("validType", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("validType"));
        data.getJSONObject("couponEntityPO").put("validDay", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("validDay"));
        data.getJSONObject("couponEntityPO").put("superpositionMemberCard", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("superpositionMemberCard"));
        data.getJSONObject("couponEntityPO").put("minDiscount", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("minDiscount"));
        data.getJSONObject("couponEntityPO").put("maxCommodityNum", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("maxCommodityNum"));
        data.getJSONObject("couponEntityPO").put("minConsume", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("minConsume"));
        data.getJSONObject("couponEntityPO").put("maxPreferential", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getBigDecimal("maxPreferential"));
        data.getJSONObject("couponEntityPO").put("useChannel", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getInteger("useChannel"));
        data.getJSONObject("couponEntityPO").put("applianceCommodityType", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getByte("applianceCommodityType"));
        data.getJSONObject("couponEntityPO").put("commodityWhitelist", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getString("commodityWhitelist"));
        data.getJSONObject("couponEntityPO").put("commodityBlacklist", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getString("commodityBlacklist"));
        data.getJSONObject("couponEntityPO").put("applianceStoreType", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getByte("applianceStoreType"));
        data.getJSONObject("couponEntityPO").put("storeWhitelist", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getString("storeWhitelist"));
        data.getJSONObject("couponEntityPO").put("storeBlacklist", (Object)data.getJSONObject("couponDefinitionPOWithBLOBs").getString("storeBlacklist"));
        CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(data.getJSONObject("couponEntityPO"));
        return couponDTO;
    }

    public static CouponDTO getCouponByJSON(JSONObject data) {
        CouponDTO couponDTO = new CouponDTO();
        couponDTO.setId(data.getInteger("couponEntityId"));
        couponDTO.setCode(data.getString("couponCode"));
        couponDTO.setCouponName(data.getString("couponName"));
        couponDTO.setDefinitionId(data.getInteger("couponDefinitionId"));
        couponDTO.setInfo(data.getString("info"));
        couponDTO.setCouponType(CouponDTO.CouponTypeEnum.from(data.getInteger("preferentialType")));
        couponDTO.setMaxDiscountAmount(data.getBigDecimal("maxPreferential"));
        couponDTO.setCouponChannel(CouponDTO.CouponChannelEnum.from(data.getInteger("useChannel")));
        if (CouponDTO.CouponTypeEnum.CASH.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setAmount(data.getBigDecimal("money"));
        }
        if (CouponDTO.CouponTypeEnum.DISCOUNT.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setDiscount(data.getBigDecimal("discount").multiply(new BigDecimal("0.1")));
        }
        couponDTO.setCouponValidType(CouponDTO.CouponValidTypeEnum.from(data.getInteger("validType")));
        if (CouponDTO.CouponValidTypeEnum.RANGE.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setStartValidDate(data.getDate("validDateStart"));
            couponDTO.setEndValidDate(data.getDate("validDateEnd"));
        }
        if (CouponDTO.CouponValidTypeEnum.AFTER.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setValidDays(data.getInteger("validDay"));
            couponDTO.setGetDate(data.getDate("createDate"));
            if (couponDTO.getGetDate() == null) {
                couponDTO.setGetDate(data.getDate("getDate"));
            }
            couponDTO.setStartValidDate(couponDTO.getGetDate());
            couponDTO.setEndValidDate(new Date(couponDTO.getGetDate().getTime() + (long)couponDTO.getValidDays().intValue() * 86400000L));
        }
        couponDTO.setMinConsume(data.getBigDecimal("minConsume"));
        BigDecimal minDiscount = data.getBigDecimal("minDiscount");
        couponDTO.setCanUseDiscount(minDiscount == null ? BigDecimal.ZERO : minDiscount.multiply(new BigDecimal("0.1")));
        couponDTO.setIsAllowFoldUserDiscount(data.getBoolean("superpositionMemberCard"));
        couponDTO.setApplianceCommodityType(data.getByte("applianceCommodityType"));
        couponDTO.setCommodityWhitelist(data.getString("commodityWhitelist"));
        couponDTO.setCommodityBlacklist(data.getString("commodityBlacklist"));
        couponDTO.setApplianceStoreType(data.getByte("applianceStoreType"));
        couponDTO.setStoreWhitelist(data.getString("storeWhitelist"));
        couponDTO.setStoreBlacklist(data.getString("storeBlacklist"));
        couponDTO.setMaxCommodityNum(data.getInteger("maxCommodityNum"));
        return couponDTO;
    }

    public String getComponentAccessToken() {
        String url = this.bizvaneProperties.getComponentAccessTokenUrl();
        String data = this.doPost(url, new HashMap<String, Object>(), "\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0token").getString("data");
        return data;
    }

    public LoginUser decryptManagermentToken(String token) {
        String url = this.bizvaneProperties.getAdminTokenValidUrl();
        JSONObject result = (JSONObject)((PostRequest)HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url)).header("stageToken", token)).asBean(JSONObject.class);
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new CustomException("\u7528\u6237\u8eab\u4efd\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4ece\u4e2d\u53f0\u767b\u5f55");
        }
        JSONObject data = result.getJSONObject("data");
        log.info("decryptManagermentToken\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a{}", (Object)data.toJSONString());
        return LoginUser.builder().brandId(data.getInteger("brandId")).nickName(data.getString("name")).companyId(data.getInteger("sysCompanyId")).companyName(data.getString("companyName")).companyCode(data.getString("companyCode")).merchantName(data.getString("brandName")).merchantCode(data.getString("brandCode")).accountCode(data.getString("accountCode")).token(data.getString("token")).build();
    }

    public void notifyRefundApplied(RefundOrder od) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getRefundAppliedInfoNotifyUrl();
        OrderItems item = od.getItem();
        RefundDTO build = RefundDTO.builder().count(od.getSaleQuantity()).price(item.getMarketPrice()).specification(item.getGoodsSkuNo()).code(od.getItem().getGoodsNo()).standardPrice(item.getMarketPrice()).standardAmount(item.getMarketPrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).marketValue(item.getSalePrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).amountReceivable(od.getItemAmout()).transactionAmount(od.getRefundAmount()).build();
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)build).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u9000\u6b3e\u5230\u8d26\u901a\u77e5", url, JSONObject.toJSONString((Object)build), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new CustomException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void unLockCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getUnLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u89e3\u9501");
    }

    public void lockCoupon(final CouponDTO couponDTO) {
        if (couponDTO == null || couponDTO.getCode() == null) {
            return;
        }
        String url = this.bizvaneProperties.getLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u9501\u5b9a");
    }

    public String notifyPaidOrderInfoOffLine(Orders o) {
        Integer merchantId = o.getMerchantId();
        MerchantOfflineConfigPOExample merchantOfflineConfigPOExample = new MerchantOfflineConfigPOExample();
        merchantOfflineConfigPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<MerchantOfflineConfigPO> merchantOfflineConfigPOS = this.merchantOfflineConfigPOMapper.selectByExample(merchantOfflineConfigPOExample);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getPaidOrdersInfoNotifyUrl();
        String deductionIntegral = o.getDeductionIntegral() == null ? BigDecimal.ZERO.toString() : o.getDeductionIntegral().toString();
        String points = o.getPoints() == null ? BigDecimal.ZERO.toString() : o.getPoints().toString();
        OrderItems orderItems = o.getItems().get(0);
        String corporation = orderItems.getCorporation();
        String corporationIdCard = orderItems.getCorporationIdCard();
        Integer sealType = orderItems.getSealType();
        String uniformSocialCreditCode = orderItems.getCreditCode();
        Integer type = orderItems.getCompanyType();
        String legalName = orderItems.getLegalName();
        Integer brandId = merchantId;
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(companyBrandRelationPOS)) {
            brandId = companyBrandRelationPOS.get(0).getBrandId();
        }
        OrdersDTO ordersDTO = OrdersDTO.builder().brandId(brandId).orderNo(o.getOrderNo()).orderTime(sdf.format(o.getGmtCreate())).consigneeName(o.getShippingName()).consigneePhone(o.getShippingMobile()).consigneeProvince(o.getShippingProvince()).consigneeCity(o.getShippingCity()).consigneeArea(o.getShippingDistrict()).consigneeStreet("").consigneeDetailed(o.getShippingAddress()).erpId(StringUtils.isEmpty((Object)o.getErpId()) ? "" : o.getErpId()).erpStoreId(o.getErpStoreId() == null ? "" : o.getErpStoreId().toString()).erpGuideId(o.getErpGuideId() == null ? "" : o.getErpGuideId().toString()).erpGuideCode(StringUtils.isEmpty((Object)o.getErpGuideCode()) ? "" : o.getErpGuideCode().toString()).erpStoreCode(StringUtils.isEmpty((Object)o.getErpStoreCode()) ? "" : o.getErpStoreCode().toString()).pickStoreId(o.getPickStoreId() == null ? "" : o.getPickStoreId()).pickStoreCode(StringUtils.isEmpty((Object)o.getPickStoreCode()) ? "" : o.getPickStoreCode()).pickStoreName(StringUtils.isEmpty((Object)o.getPickStoreName()) ? "" : o.getPickStoreName()).shareGuideId("").vipName(o.getVipName()).offlineCardNo(o.getOfflineCardNo()).commodityAmount(o.getOrderAmount()).standardAmount(o.getOrderAmount()).preferentialAmount(o.getCouponDeduction()).deductibleAmount(BigDecimal.ZERO).deductibleBalance(o.getDeductionBalance()).otherPreferentialVolume(o.getActiveDeduction()).receivableAmount(o.getOrderAmount()).transactionAmount(o.getPayAmount()).isPost(o.getShippingMode().equals(0) ? "Y" : "N").shippingMode(o.getShippingMode()).postage(o.getShippingFee()).payMoney(o.getPayAmount()).vipcouponCode(o.getCouponNo()).costPoints(o.getPriceSystem() == 0 ? deductionIntegral : points).productCount(o.getItems().stream().mapToInt(OrderItems::getSaleQuantity).sum()).companyName(corporation).signetType(sealType).legalPersonId(corporationIdCard).legalPerson(legalName).creditCode(uniformSocialCreditCode).companyType("" + type).logisticsStatus(o.getLogisticsStatus().compareTo(LogisticsStatusEnum.SEND) == 0 ? 1 : (o.getLogisticsStatus().compareTo(LogisticsStatusEnum.UN_SEND) == 0 ? 0 : 1)).orderItem(o.getItems().stream().map(od -> OrdersDTO.OrderItem.builder().count(od.getSaleQuantity()).price(od.getMarketPrice()).specification(od.getGoodsSkuName()).standardPrice(od.getMarketPrice()).standardAmount(od.getMarketPrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).marketValue(od.getSalePrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).amountReceivable(od.getItemsAmount()).transactionAmount(od.getItemsPayAmount()).code(od.getGoodsNo()).skuCode(od.getGoodsSkuNo()).offlineSkuId(od.getOfflineSkuId()).offlineGoodsId(od.getOfflineGoodsId()).goodsName(od.getGoodsName()).onlineProductName(od.getGoodsName()).specCode(od.getSpecCode()).build()).collect(Collectors.toList())).build();
        if (Objects.nonNull(o.getIsCenterStore()) && o.getIsCenterStore().booleanValue()) {
            ordersDTO.setErpId(o.getErpCenterstoreId());
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(merchantOfflineConfigPOS)) {
            MerchantOfflineConfigPO merchantOfflineConfigPO = merchantOfflineConfigPOS.get(0);
            Integer isCloseConnector = merchantOfflineConfigPO.getIsCloseConnector();
            if (MallConnectorSendEnum.CLOSE_SEND.getCode().equals(isCloseConnector)) {
                log.info("\u5546\u57ce:{}\u914d\u7f6e\u4e0d\u63a8\u9001\u8fde\u63a5\u5668", (Object)merchantId);
                try {
                    log.info("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record", (Object)o.getOrderNo());
                    this.sendOrderMsgRecordService.addOrderMsgRecord(merchantId, o.getOrderNo(), o);
                    log.info("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u4fe1\u606f:{}", (Object)o.getOrderNo(), (Object)o);
                }
                catch (Exception e) {
                    log.error("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)o.getOrderNo());
                }
                return "success";
            }
        }
        try {
            log.info("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record", (Object)o.getOrderNo());
            this.sendOrderMsgRecordService.addOrderMsgRecord(merchantId, o.getOrderNo(), o);
            log.info("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u4fe1\u606f:{}", (Object)o.getOrderNo(), (Object)o);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)o.getOrderNo());
        }
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u8ba2\u5355\u521b\u5efa\u901a\u77e5\u7ebf\u4e0b", url, JSONObject.toJSONString((Object)ordersDTO)});
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)ordersDTO).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u8ba2\u5355\u521b\u5efa\u901a\u77e5\u7ebf\u4e0b", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                return "fail";
            }
            return "success";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "fail";
        }
    }

    public void notifyRefundOrderInfo(RefundOrder od) {
        Integer merchantId = od.getMerchantId();
        MerchantOfflineConfigPOExample merchantOfflineConfigPOExample = new MerchantOfflineConfigPOExample();
        merchantOfflineConfigPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<MerchantOfflineConfigPO> merchantOfflineConfigPOS = this.merchantOfflineConfigPOMapper.selectByExample(merchantOfflineConfigPOExample);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getRefundNotifyUrl();
        log.info("\u4ec5\u9000\u6b3e\u901a\u77e5:[{}]", (Object)url);
        RefundReq refundReq = RefundReq.builder().refundDate(sdf.format(od.getGmtCreate())).refundMoney(od.getRefundAmount().toString()).refundNo(od.getRefundNo()).refundRemark(od.getRefundReason()).brandId(merchantId + "").code(StringUtils.isEmpty((Object)od.getItems().get(0).getGoodsNo()) ? "" : od.getItems().get(0).getGoodsNo()).offlineCardNo(StringUtils.isEmpty((Object)od.getOfflineCardNo()) ? "" : od.getOfflineCardNo()).erpId(StringUtils.isEmpty((Object)od.getErpId()) ? "" : od.getErpId()).orderNo(od.getOrderNo()).vipName(od.getVipName()).skuCode(StringUtils.isEmpty((Object)od.getItems().get(0).getGoodsSkuNo()) ? "" : od.getItems().get(0).getGoodsSkuNo()).goodsName(StringUtils.isEmpty((Object)od.getGoodsName()) ? od.getItems().get(0).getGoodsName() : od.getGoodsName()).erpStoreId(od.getErpStoreId() == null ? "" : od.getErpStoreId().toString()).erpGuideId(od.getErpGuideId() == null ? "" : od.getErpGuideId().toString()).erpGuideCode(StringUtils.isEmpty((Object)od.getErpGuideCode()) ? "" : od.getErpGuideCode().toString()).erpStoreCode(StringUtils.isEmpty((Object)od.getErpStoreCode()) ? "" : od.getErpStoreCode().toString()).build();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(merchantOfflineConfigPOS)) {
            MerchantOfflineConfigPO merchantOfflineConfigPO = merchantOfflineConfigPOS.get(0);
            Integer isCloseConnector = merchantOfflineConfigPO.getIsCloseConnector();
            if (MallConnectorSendEnum.CLOSE_SEND.getCode().equals(isCloseConnector)) {
                log.info("\u5546\u57ce:{}\u914d\u7f6e\u4e0d\u63a8\u9001\u8fde\u63a5\u5668", (Object)merchantId);
                try {
                    this.sendOrderMsgRecordService.addRefundOrderMsgRecord(merchantId, od.getRefundNo(), od);
                }
                catch (Exception e) {
                    log.warn("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)od.getOrderNo());
                }
                return;
            }
        }
        try {
            this.sendOrderMsgRecordService.addRefundOrderMsgRecord(merchantId, od.getRefundNo(), od);
        }
        catch (Exception e) {
            log.warn("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)od.getOrderNo());
        }
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)refundReq).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u4ec5\u9000\u6b3e\u901a\u77e5", url, JSONObject.toJSONString((Object)refundReq), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new CustomException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void notifyRefundGoodsInfo(RefundOrder od) {
        Integer merchantId = od.getMerchantId();
        MerchantOfflineConfigPOExample merchantOfflineConfigPOExample = new MerchantOfflineConfigPOExample();
        merchantOfflineConfigPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<MerchantOfflineConfigPO> merchantOfflineConfigPOS = this.merchantOfflineConfigPOMapper.selectByExample(merchantOfflineConfigPOExample);
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getRefundGoodsNotifyUrl();
        log.info("\u9000\u6b3e\u9000\u8d27\u901a\u77e5:[{}]", (Object)url);
        RefundGoodsReq refundReq = RefundGoodsReq.builder().orderNo(od.getOrderNo()).brandId(merchantId + "").code(od.getItems().get(0).getGoodsNo()).orderItem(od.getItems().stream().map(e -> RefundGoodsReq.OrderItemRequestVO.builder().count(e.getSaleQuantity().toString()).price(e.getSalePrice().toEngineeringString()).specification(e.getGoodsSkuName()).code(e.getGoodsNo()).skuCode(StringUtils.isEmpty((Object)e.getGoodsSkuNo()) ? e.getGoodsNo() : e.getGoodsSkuNo()).standardPrice(e.getMarketPrice().toString()).standardAmount(e.getMarketPrice().multiply(BigDecimal.valueOf(new Double(e.getSaleQuantity() + ""))).setScale(2, 4).toString()).marketValue(e.getSalePrice().multiply(BigDecimal.valueOf(new Double(e.getSaleQuantity() + ""))).setScale(2, 4).toString()).amountReceivable(e.getSalePrice().multiply(BigDecimal.valueOf(new Double(e.getSaleQuantity() + ""))).setScale(2, 4).toString()).transactionAmount(e.getItemsPayAmount().toString()).specCode(e.getSpecCode()).offlineGoodsId(e.getOfflineGoodsId()).offlineSkuId(e.getOfflineSkuId()).goodsName(e.getGoodsName()).preferentialAmountToGoods(e.getItemsCouponDeduction()).deductibleAmountToGoods(e.getItemsPointDeduction()).otherPreferentialVolumeToGoods(e.getItemsUserDeduction()).build()).collect(Collectors.toList())).build();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(merchantOfflineConfigPOS)) {
            MerchantOfflineConfigPO merchantOfflineConfigPO = merchantOfflineConfigPOS.get(0);
            Integer isCloseConnector = merchantOfflineConfigPO.getIsCloseConnector();
            if (MallConnectorSendEnum.CLOSE_SEND.getCode().equals(isCloseConnector)) {
                log.info("\u5546\u57ce:{}\u914d\u7f6e\u4e0d\u63a8\u9001\u8fde\u63a5\u5668", (Object)merchantId);
                try {
                    this.sendOrderMsgRecordService.addRefundOrderMsgRecord(merchantId, od.getRefundNo(), od);
                }
                catch (Exception e2) {
                    log.error("\u9000\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)od.getRefundNo());
                }
                return;
            }
        }
        try {
            this.sendOrderMsgRecordService.addRefundOrderMsgRecord(merchantId, od.getRefundNo(), od);
        }
        catch (Exception e3) {
            log.error("\u9000\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)od.getRefundNo());
        }
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)refundReq).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u9000\u6b3e\u9000\u8d27\u901a\u77e5", url, JSONObject.toJSONString((Object)refundReq), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new CustomException(message);
            }
        }
        catch (Exception e1) {
            log.info(e1.getMessage());
        }
    }

    public Map<String, Object> pickupCoupon(Map<String, Object> map) {
        String url = this.bizvaneProperties.getPickCouponUrl();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JSONObject data = this.doPost(url, map, "\u9886\u53d6\u4f18\u60e0\u5238").getJSONObject("data");
            if (data == null || data.isEmpty()) {
                throw new CustomException("\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff01");
            }
            result.put("countTodaySum", data.getLong("countTodaySum"));
            result.put("countAllSum", data.getLong("countAllSum"));
        }
        catch (RuntimeException e) {
            throw new CustomException(e.getMessage());
        }
        return result;
    }

    public CouponDTO getCouponDetail(final Integer couponEntityId) {
        String url = this.bizvaneProperties.getCouponDetailUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponEntityId", couponEntityId);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5238\u8be6\u60c5").getJSONObject("data");
        log.info("BizvaneInterface#getCouponDetail data:{}", (Object)JSON.toJSONString((Object)data));
        return BizvaneInterface.getCouponDTOByDetailData(data);
    }

    public UserDiscountDTO userLevelDiscountInfo(final Integer levelId) {
        HashMap map;
        String url = this.bizvaneProperties.getMemberLevelDiscountUrl();
        JSONObject data = this.doPostNoException(url, map = new HashMap(){
            {
                this.put("mbrLevelId", levelId);
            }
        }, "\u83b7\u53d6\u4f1a\u5458\u7b49\u7ea7\u4f18\u60e0\u4fe1\u606f").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            log.info("\u8bbe\u7f6e\u9ed8\u8ba4\u6298\u6263\u4fe1\u606f");
            UserDiscountDTO userDiscountDTO = new UserDiscountDTO();
            userDiscountDTO.setDiscount(BigDecimal.ONE);
            return userDiscountDTO;
        }
        UserDiscountDTO userDiscountDTO = new UserDiscountDTO();
        String memberDiscount = data.getString("memberDiscount");
        if (StringUtils.isEmpty((Object)memberDiscount)) {
            log.info("\u62c9\u53d6\u4f1a\u5458\u7b49\u7ea7\u6298\u6263\u7387\u4e3a\u7a7a\uff0c\u5c06\u5176\u8bbe\u7f6e\u4e3a1\uff0c\u786e\u4fdd\u8ba1\u7b97\u4f1a\u5458\u6298\u6263\u4e0d\u62a5\u9519\u3002");
            userDiscountDTO.setDiscount(BigDecimal.ONE);
        } else {
            userDiscountDTO.setDiscount(new BigDecimal(memberDiscount).divide(BigDecimal.valueOf(100L)));
        }
        userDiscountDTO.setDiscountMethod(UserDiscountDTO.DiscountMethod.from(data.getInteger("discountMethod")));
        userDiscountDTO.setDiscountRange(UserDiscountDTO.DiscountRange.from(data.getInteger("discountControl")));
        userDiscountDTO.setDiscountMax(new BigDecimal(data.getString("discountMax")).divide(BigDecimal.valueOf(100L)));
        userDiscountDTO.setDiscountMin(new BigDecimal(data.getString("discountMin")).divide(BigDecimal.valueOf(100L)));
        userDiscountDTO.setMemberLevelName(data.getString("levelName"));
        if (userDiscountDTO.getDiscountMethod().equals((Object)UserDiscountDTO.DiscountMethod.FOLD_UP_THE_FOLD)) {
            String additionalDiscount = data.getString("additionalDiscount");
            if (StringUtils.isEmpty((Object)additionalDiscount)) {
                userDiscountDTO.setFoldUpDiscount(BigDecimal.ONE);
            } else {
                userDiscountDTO.setFoldUpDiscount(new BigDecimal(data.getString("additionalDiscount")).divide(BigDecimal.valueOf(100L)));
            }
        }
        return userDiscountDTO;
    }

    public void validCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getVerifyCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
                this.put("useBusinessCode", 1);
                this.put("profitMoney", couponDTO.getVerifyAmount());
                this.put("discountMoney", couponDTO.getDeductionAmount());
                this.put("brandId", couponDTO.getMerchantId());
            }
        };
        this.doPost(url, map, "\u4f18\u60e0\u5238\u6838\u9500");
    }

    public Map<String, Object> getCustomCounponList(final CouponDTO u, final Integer pageIndex) {
        String url = this.bizvaneProperties.getUserCouponListUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", u.getUserNo());
                this.put("couponStatus", 20);
                this.put("memberInfoModel.brandId", u.getMerchantId());
                this.put("pageNumber", pageIndex);
                this.put("pageSize", 20);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u7528\u6237\u4f18\u60e0\u5238").getJSONObject("data");
        log.info("data999999:{}", (Object)JSON.toJSONString((Object)data));
        JSONArray couponArr = data.getJSONArray("list");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (int i = 0; i < couponArr.size(); ++i) {
            CouponDTO couponDTO;
            JSONObject current = couponArr.getJSONObject(i);
            if (current.getBoolean("lock").booleanValue() || current.getBoolean("use") != null && current.getBoolean("use").booleanValue() || CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)(couponDTO = BizvaneInterface.getCouponByJSON(current)).getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        result.put("list", couponDTOList);
        result.put("hasNextPage", data.getBooleanValue("hasNextPage"));
        return result;
    }

    public List<CouponDTO> getCouponList(final CouponDTO u) {
        HashMap map;
        String url = this.bizvaneProperties.getCouponListUrl();
        JSONArray data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberInfoModel.memberCode", u.getUserNo());
                this.put("activityType", 4);
                this.put("memberInfoModel.brandId", u.getMerchantId());
            }
        }, "\u83b7\u53d6\u5238\u5217\u8868").getJSONArray("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject current = data.getJSONObject(i);
            if (!current.getBooleanValue("canReceive")) continue;
            JSONObject couponJson = current.getJSONObject("couponDetailResponseVO").getJSONObject("couponDefinitionPO");
            CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(couponJson);
            couponDTO.setActivityId(current.getInteger("mktActivityId"));
            couponDTO.setPerPersonMax(current.getInteger("perPersonMax"));
            couponDTO.setPerPersonPerDayMax(current.getInteger("perPersonPerDayMax"));
            if (CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)couponDTO.getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        return couponDTOList;
    }

    public User getMemberInfo(final User loginUserInfo) {
        String url = this.bizvaneProperties.getUserInfoUrl();
        final Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(loginUserInfo.getMerchantId());
        HashMap map = new HashMap(){
            {
                this.put("memberCode", loginUserInfo.getUserNo());
                this.put("brandId", brandId);
            }
        };
        log.info("\u652f\u4ed8\u6210\u529f");
        JSONObject data = null;
        try {
            data = this.doPost(url, map, "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f").getJSONObject("data");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            return null;
        }
        User remoteUser = new User();
        remoteUser.setUserNo(data.getString("memberCode"));
        remoteUser.setUserId(data.getLong("mbrMemberId"));
        remoteUser.setBrandId(data.getInteger("brandId"));
        remoteUser.setLevelId(data.getInteger("levelId"));
        remoteUser.setFullName(data.getString("name"));
        remoteUser.setOpenid(data.getString("wxOpenId"));
        remoteUser.setUserPhone(data.getString("phone"));
        String headPortraits = data.getString("headPortraits");
        if (!StringUtils.isEmpty((Object)headPortraits) && !headPortraits.contains("http")) {
            headPortraits = "https://" + this.qiNiuProperties.getDomain() + "/" + headPortraits;
        }
        remoteUser.setHeadImgUrl(headPortraits);
        remoteUser.setEnabledCommission(data.getBooleanValue("distributionState"));
        remoteUser.setCountIntegral(data.getLongValue("countIntegral"));
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4fe1\u606f\u8fd4\u56de\u53c2\u6570:[{}]", JSON.toJSON((Object)remoteUser));
        return remoteUser;
    }

    public User getMemberInfo1(final User loginUserInfo) {
        String url = this.bizvaneProperties.getUserInfoUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", loginUserInfo.getUserNo());
                this.put("brandId", loginUserInfo.getMerchantId());
            }
        };
        JSONObject data = null;
        try {
            data = this.doPost(url, map, "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f").getJSONObject("data");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            return null;
        }
        User remoteUser = new User();
        remoteUser.setUserNo(data.getString("memberCode"));
        remoteUser.setUserId(data.getLong("mbrMemberId"));
        remoteUser.setBrandId(data.getInteger("brandId"));
        remoteUser.setLevelId(data.getInteger("levelId"));
        remoteUser.setFullName(data.getString("name"));
        remoteUser.setOpenid(data.getString("wxOpenId"));
        remoteUser.setUserPhone(data.getString("phone"));
        String headPortraits = data.getString("headPortraits");
        if (!StringUtils.isEmpty((Object)headPortraits) && !headPortraits.contains("http")) {
            headPortraits = "https://" + this.qiNiuProperties.getDomain() + "/" + headPortraits;
        }
        remoteUser.setHeadImgUrl(headPortraits);
        remoteUser.setEnabledCommission(data.getBoolean("distributionState"));
        remoteUser.setCountIntegral(data.getLong("countIntegral"));
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4fe1\u606f\u8fd4\u56de\u53c2\u6570:[{}]", JSON.toJSON((Object)remoteUser));
        return remoteUser;
    }

    private JSONObject doPost(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/x-www-from-urlencoded");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("BizvaneInterface#doPost error:{}" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new CustomException(message);
        }
        return result;
    }

    private JSONObject doPostJSON(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)url);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/json");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("BizvaneInterface#doPostJSON error:{}" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new CustomException(message);
        }
        return result;
    }

    private JSONObject doPostObject(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/x-www-from-urlencoded");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        return result;
    }

    private JSONObject doPostNoException(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/x-www-from-urlencoded");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String HttpPostWithJson(String url, String json) {
        String returnValue = "\u8fd9\u662f\u9ed8\u8ba4\u8fd4\u56de\u503c\uff0c\u63a5\u53e3\u8c03\u7528\u5931\u8d25";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            log.info("json\u53c2\u6570:{}", (Object)json);
            StringEntity requestEntity = new StringEntity(json, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return returnValue;
    }

    private JSONObject doPost2(String url, Map<String, Object> param, String interfaceName) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u68c0\u67e5\u8c03\u7528\u5fc5\u8981\u53c2\u6570");
        PostRequest post = (PostRequest)HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url)).connectTimeout(60, TimeUnit.SECONDS);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/x-www-from-urlencoded");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new CustomException(message);
        }
        return result;
    }

    private boolean requestFail(JSONObject result) {
        return result == null || result.getInteger("code") != 0;
    }

    public RestResult refundIntegralChange(final IntegralRefundOrder integralRefundOrder) {
        log.info("\u9000\u8fd8\u79ef\u5206\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)integralRefundOrder));
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        HashMap map = new HashMap(){
            {
                this.put("memberCode", integralRefundOrder.getMemberCode());
                this.put("changeIntegral", integralRefundOrder.getRefundIntegral() * integralRefundOrder.getRefundQuantity());
                this.put("changeType", 2);
                this.put("changeBills", integralRefundOrder.getRefundNo());
                this.put("businessType", 31);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult consumeIntegralChange(final String memberCode, final Integer integral, final String orderNo, final String changeDetails) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost2(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 1);
                this.put("changeBills", orderNo);
                this.put("businessType", 30);
                this.put("changeDetails", changeDetails);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    private JSONObject doPostCrm(String url, Map<String, Object> param, String interfaceName) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u68c0\u67e5\u8c03\u7528\u5fc5\u8981\u53c2\u6570");
        PostRequest post = (PostRequest)HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url)).connectTimeout(60, TimeUnit.SECONDS);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            post.header("Content-Type", "application/x-www-from-urlencoded");
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new CustomException(message);
        }
        return result;
    }

    public Integer getUserIntegral(final String memberCode) {
        log.info("\u8c03\u53d6applet\u63a5\u53e3\u3002\u3002\u3002\u3002\u83b7\u53d6\u4f1a\u5458\u79ef\u5206");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u4f1a\u5458\u79ef\u5206").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return 0;
        }
        return data.getInteger("countIntegral");
    }

    public BigDecimal getIntegralProportion(final String memberCode) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return BigDecimal.valueOf(0.0);
        }
        return data.getBigDecimal("discountRatio");
    }

    public BigDecimal getUserBalance(final String memberCode) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return BigDecimal.valueOf(0.0);
        }
        BigDecimal balance = data.getBigDecimal("balance");
        return balance;
    }

    public String getAppid(final Integer brandId) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6appid");
        String url = this.bizvaneProperties.getQueryAppidUrl();
        HashMap map = new HashMap(){
            {
                this.put("sysBrandId", brandId);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u5c0f\u7a0b\u5e8fappid");
        if (data == null || data.isEmpty()) {
            return null;
        }
        String appid = data.getString("data");
        return appid;
    }

    public ResponseData getActivityCoupon(final Long sysBrandId, final Integer page, final Integer pageSize) {
        log.info("\u8c03\u7528applet.api_activityCoupon");
        String url = this.bizvaneProperties.getActivityCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("sysBrandId", sysBrandId);
                this.put("page", page);
                this.put("pageSize", pageSize);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u5fae\u5546\u57ce\u4f18\u60e0\u5238\u5217\u8868");
        if (data == null || data.isEmpty()) {
            return null;
        }
        log.info("applet.api_activityCoupon\u67e5\u8be2\u7ed3\u679c" + JSON.toJSON((Object)data.get((Object)"data")));
        return new ResponseData<Object>(data.get((Object)"data"));
    }

    private JSONObject doGet(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        url = this.bizvaneProperties.getRequestPrefix() + url;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    public RestResult wscRefundIntegralChange(final String memberCode, final Integer integral, final String orderNo) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 2);
                this.put("changeBills", orderNo);
                this.put("businessType", 36);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult wscConsumeIntegralChange(final String memberCode, final Integer integral, final String orderNo) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 1);
                this.put("changeBills", orderNo);
                this.put("businessType", 35);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult kafkaTrack(KafkaTrack kafkaTrack) {
        log.info("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\u3002\u3002\u3002\u884c\u4e3a\u91c7\u96c6\u5206\u6790");
        String url = this.bizvaneProperties.getKafkaTrack();
        String kafkaBusinessNumValue = this.bizvaneProperties.getKafkaBusinessNumValue();
        String kafkaApiKeyValue = this.bizvaneProperties.getKafkaApiKeyValue();
        kafkaTrack.setBusinessNum(kafkaBusinessNumValue);
        kafkaTrack.setApiKey(kafkaApiKeyValue);
        JSONObject data = this.executePost(url, kafkaTrack);
        log.info("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\u3002\u3002\u3002\u884c\u4e3a\u91c7\u96c6\u5206\u6790\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)data));
        if (1 == data.getIntValue("successFlag")) {
            return RestResult.success();
        }
        return RestResult.fail((String)data.getString("message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject executePost(String url, Object param) {
        JSONObject jsonObject = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).build();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        log.info("url:{}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setConfig(requestConfig);
        String parameter = JSON.toJSONString((Object)param);
        StringEntity se = null;
        try {
            log.info("post\u4f20json\u683c\u5f0f\u53c2\u6570\u7684\u5de5\u5177\u65b9\u6cd5,\u53c2\u6570\u4e3a:{}", (Object)parameter);
            se = new StringEntity(parameter, "utf-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        se.setContentType("text/json");
        httpPost.setEntity((HttpEntity)se);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            jsonObject = JSONObject.parseObject((String)result);
            httpClient.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return jsonObject;
    }

    public RestResult operationBalance(final String memberCode, final BigDecimal balance, final int code, final String orderNo) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\uff0c\u64cd\u4f5c\u4f1a\u5458\u4f59\u989d\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e3a:{}", (Object)OperationTypeEnum.getOperationTypeEnum(code).getMsg());
        String url = this.bizvaneProperties.getMemberBalanceAndIntegralUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("balance", balance);
                this.put("changeType", code);
                this.put("docno", orderNo);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u4f59\u989d");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int resultCode = data.getIntValue("code");
        return resultCode == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult operationIntegral(final String memberCode, final Integer integral, final int code, final String orderNo) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\uff0c\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e3a:{}", (Object)OperationTypeEnum.getOperationTypeEnum(code).getMsg());
        String url = this.bizvaneProperties.getMemberBalanceAndIntegralUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", code);
                this.put("docno", orderNo);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int resultCode = data.getIntValue("code");
        return resultCode == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult operationIntegral(final String memberCode, final Integer integral, final int code, final String businessType, final String orderNo) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\uff0c\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e3a:{}", (Object)OperationTypeEnum.getOperationTypeEnum(code).getMsg());
        String url = this.bizvaneProperties.getMemberBalanceAndIntegralUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", code);
                this.put("businessType", businessType);
                this.put("docno", orderNo);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int resultCode = data.getIntValue("code");
        return resultCode == 0 ? RestResult.success() : RestResult.fail();
    }

    public JSCode2SessionResponse getSession(final String appid, final String code) {
        log.info("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\uff0c\u83b7\u53d6session\u3001unionid\u4fe1\u606f");
        String url = "https://api.weixin.qq.com/sns/component/jscode2session";
        HashMap map = new HashMap(){
            {
                this.put("appid", appid);
                this.put("js_code", code);
                this.put("grant_type", "authorization_code");
                this.put("component_appid", BizvaneInterface.this.weixinProperties.getComponentAppid());
                this.put("component_access_token", BizvaneInterface.this.getComponentAccessToken());
            }
        };
        return (JSCode2SessionResponse)this.doGetSan(url, map, "\u5fae\u4fe1\u767b\u9646").toJavaObject(JSCode2SessionResponse.class);
    }

    private JSONObject doGetSan(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a[{}],\u8bf7\u6c42\u5730\u5740\uff1a [{}] ,\u8bf7\u6c42\u53c2\u6570\uff1a [{}] ==> \u54cd\u5e94:[{}]", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    public void notifySendOrderInfo(Orders o) {
        Integer merchantId = o.getMerchantId();
        MerchantOfflineConfigPOExample merchantOfflineConfigPOExample = new MerchantOfflineConfigPOExample();
        merchantOfflineConfigPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<MerchantOfflineConfigPO> merchantOfflineConfigPOS = this.merchantOfflineConfigPOMapper.selectByExample(merchantOfflineConfigPOExample);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getSendedOrdersInfoNotifyUrl();
        String deductionIntegral = o.getDeductionIntegral() == null ? BigDecimal.ZERO.toString() : o.getDeductionIntegral().toString();
        String points = o.getPoints() == null ? BigDecimal.ZERO.toString() : o.getPoints().toString();
        log.info("\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0burl:[{}]", (Object)url);
        OrdersDTO ordersDTO = OrdersDTO.builder().brandId(merchantId).orderNo(o.getOrderNo()).orderTime(sdf.format(o.getGmtCreate())).consigneeName(o.getShippingName()).consigneePhone(o.getShippingMobile()).consigneeProvince(o.getShippingProvince()).consigneeCity(o.getShippingCity()).consigneeArea(o.getShippingDistrict()).consigneeStreet("").consigneeDetailed(o.getShippingAddress()).erpId(StringUtils.isEmpty((Object)o.getErpId()) ? "" : o.getErpId()).erpStoreId(o.getErpStoreId() == null ? "" : o.getErpStoreId().toString()).erpGuideId(o.getErpGuideId() == null ? "" : o.getErpGuideId().toString()).erpGuideCode(StringUtils.isEmpty((Object)o.getErpGuideCode()) ? "" : o.getErpGuideCode().toString()).erpStoreCode(StringUtils.isEmpty((Object)o.getErpStoreCode()) ? "" : o.getErpStoreCode().toString()).shareGuideId(o.getErpGuideId() == null ? "" : o.getErpGuideId().toString()).offlineCardNo(o.getOfflineCardNo()).commodityAmount(o.getOrderAmount()).standardAmount(o.getOrderAmount()).preferentialAmount(o.getCouponDeduction()).deductibleAmount(BigDecimal.ZERO).otherPreferentialVolume(o.getActiveDeduction()).receivableAmount(o.getOrderAmount()).vipName(o.getVipName()).transactionAmount(o.getPayAmount()).isPost(o.getShippingMode().equals(0) ? "Y" : "N").shippingMode(o.getShippingMode()).postage(o.getShippingFee()).payMoney(o.getPayAmount()).vipcouponCode(o.getCouponNo()).costPoints(o.getPriceSystem() == 0 ? deductionIntegral : points).productCount(o.getItems().stream().mapToInt(OrderItems::getSaleQuantity).sum()).logisticsStatus(o.getLogisticsStatus().compareTo(LogisticsStatusEnum.SEND) == 0 ? 1 : (o.getLogisticsStatus().compareTo(LogisticsStatusEnum.UN_SEND) == 0 ? 0 : 1)).orderItem(o.getItems().stream().map(od -> OrdersDTO.OrderItem.builder().count(od.getSaleQuantity()).price(od.getMarketPrice()).specification(od.getGoodsSkuName()).offlineGoodsId(od.getOfflineGoodsId()).offlineSkuId(od.getOfflineSkuId()).standardPrice(od.getMarketPrice()).standardAmount(od.getMarketPrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).marketValue(od.getSalePrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).amountReceivable(od.getItemsAmount()).transactionAmount(od.getItemsPayAmount()).code(od.getGoodsNo()).skuCode(od.getGoodsSkuNo()).specCode(od.getSpecCode()).goodsName(od.getGoodsName()).build()).collect(Collectors.toList())).build();
        if (Objects.nonNull(o.getIsCenterStore()) && o.getIsCenterStore().booleanValue()) {
            ordersDTO.setErpId(o.getErpCenterstoreId());
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(merchantOfflineConfigPOS)) {
            MerchantOfflineConfigPO merchantOfflineConfigPO = merchantOfflineConfigPOS.get(0);
            Integer isCloseConnector = merchantOfflineConfigPO.getIsCloseConnector();
            if (MallConnectorSendEnum.CLOSE_SEND.getCode().equals(isCloseConnector)) {
                log.info("\u5546\u57ce:{}\u914d\u7f6e\u4e0d\u63a8\u9001\u8fde\u63a5\u5668", (Object)merchantId);
                try {
                    log.info("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record", (Object)o.getOrderNo());
                    this.sendOrderMsgRecordService.addOrderMsgRecord(merchantId, o.getOrderNo(), o);
                    log.info("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u4fe1\u606f:{}", (Object)o.getOrderNo(), (Object)o);
                }
                catch (Exception e) {
                    log.error("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)o.getOrderNo());
                }
                return;
            }
        }
        try {
            log.info("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record", (Object)o.getOrderNo());
            this.sendOrderMsgRecordService.addOrderMsgRecord(merchantId, o.getOrderNo(), o);
            log.info("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u4fe1\u606f:{}", (Object)o.getOrderNo(), (Object)o);
        }
        catch (Exception e) {
            log.error("2\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)o.getOrderNo());
        }
        log.info("\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b\u5165\u53c2:[{}]", JSONObject.toJSON((Object)ordersDTO));
        JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)ordersDTO).asBean(JSONObject.class);
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"----------->\u8ba2\u5355\u53d1\u8d27\u901a\u77e5", url, JSONObject.toJSONString((Object)ordersDTO), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new MallCommonException(message);
        }
    }

    public JSONArray getStoreList(final String lat, final String lng, final String brandId, final String userNo, final String searchValue, final Integer isWholeStore, Integer pageNum) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getSearchStoreUrl();
        if (pageNum == null) {
            pageNum = 1;
        }
        final Integer finalPageNum = pageNum;
        HashMap map = new HashMap(){
            {
                this.put("pageNum", finalPageNum);
                this.put("lat", lat);
                this.put("lng", lng);
                this.put("sysBrandId", brandId);
                this.put("memberCode", userNo);
                this.put("searchValue", searchValue);
                this.put("isWholeStore", isWholeStore);
            }
        };
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u5165\u53c2:[{}]", JSONObject.toJSON((Object)map));
        JSONObject jsonObject = this.executePost(url, map);
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u8fd4\u53c2:[{}]", (Object)jsonObject.toJSONString());
        if (jsonObject.getJSONObject("data") == null) {
            return null;
        }
        JSONArray storeList = jsonObject.getJSONObject("data").getJSONArray("appletSysStoreBos");
        return storeList;
    }

    public void wxRefundPushToOffline(RefundOrder refundOrder) {
        log.info("----->\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u53c2\u6570:[{}]----->", JSON.toJSON((Object)refundOrder));
        if (refundOrder.getRefundType().equals(1)) {
            this.notifyRefundOrderInfo(refundOrder);
        } else {
            this.notifyRefundGoodsInfo(refundOrder);
        }
    }

    public ResponseData<WxqyLoginResponseVO> wxqyLogin(String appid, String code) {
        log.info("enter wxqyLogin appid:{},code:{}", (Object)appid, (Object)code);
        Example mchExample = new Example(WechatMchNew.class);
        mchExample.createCriteria().andEqualTo("appId", (Object)appid);
        List wechatMchNewList = this.wechatMchNewMapper.selectByExample(mchExample);
        log.info("enter wxqyLogin request:{}", (Object)JSONObject.toJSONString((Object)wechatMchNewList));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)wechatMchNewList)) {
            return ResponseUtil.getFailedMsg(SysResponseEnum.WECHAT_MCH_NOT_EXISTS.getMessage());
        }
        Integer merchantId = ((WechatMchNew)wechatMchNewList.get(0)).getMerchantId();
        Example companyExample = new Example(CompanyBrandRelation.class);
        companyExample.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List companyBrandRelationList = this.companyBrandRelationMapper.selectByExample(companyExample);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)companyBrandRelationList)) {
            return ResponseUtil.getFailedMsg(SysResponseEnum.COMPANY_NOT_EXISTS.getMessage());
        }
        Integer companyId = ((CompanyBrandRelation)companyBrandRelationList.get(0)).getCompanyId();
        String url = "/wechatEnterprise.api/bizvaneMallRpc/getBizvaneMallLogin.do";
        TreeMap<String, Object> param = new TreeMap<String, Object>();
        param.put("sysCompanyId", companyId + "");
        param.put("sysBrandId", merchantId + "");
        param.put("code", code);
        log.info("BizvaneInterface#wxqyLogin wxqyLoginRequestVO param:{}", (Object)JSON.toJSONString(param));
        JSONObject result = this.doPostObject(url, param, "\u8c03\u7528\u4f01\u5fae\u767b\u9646\u63a5\u53e3");
        if (result == null) {
            return ResponseUtil.getFailedMsg("\u5bfc\u8d2d\u8d26\u53f7\u4e3a\u7a7a");
        }
        WxqyLoginResponseVO wxqyLoginResponseVO = (WxqyLoginResponseVO)JSON.parseObject((String)result.toJSONString(), WxqyLoginResponseVO.class);
        log.info("BizvaneInterface#wxqyLogin wxqyLoginResponseVO result:{}", (Object)JSON.toJSONString((Object)wxqyLoginResponseVO));
        if (StringUtils.isEmpty((Object)wxqyLoginResponseVO.getSysStoreOnlineCode()) || StringUtils.isEmpty((Object)wxqyLoginResponseVO.getStaffCode())) {
            return ResponseUtil.getFailedMsg("\u5bfc\u8d2d\u8d26\u53f7\u4e3a\u7a7a");
        }
        return ResponseUtil.getSuccessData(wxqyLoginResponseVO);
    }

    public void notifyNewOrderInfoToQW(Orders orders) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getNotifyAddOrdersQW();
        Integer merchantId = orders.getMerchantId();
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        Integer brandId = companyBrandRelationPO.getBrandId();
        Integer companyId = companyBrandRelationPO.getCompanyId();
        String shareSysStoreId = orders.getSysStoreId();
        String sysStaffId = orders.getSysStaffId();
        if (StringUtils.isEmpty((Object)shareSysStoreId) || StringUtils.isEmpty((Object)sysStaffId)) {
            log.info("\u8ba2\u5355sysStoreId\u6216sysStaffId\u4e3a\u7a7a\u4e0d\u8c03\u7528\u4f01\u5fae");
            return;
        }
        OrderGoodsVO build = OrderGoodsVO.builder().memberCode(orders.getUserNo()).orderNo(orders.getOrderNo()).staffCode(orders.getStaffCode()).sysBrandId(brandId).sysCompanyId(companyId).sysStoreOnlineCode(orders.getShareSysStoreOnlineCode()).sysStoreId(shareSysStoreId).sysStaffId(sysStaffId).shareFlag(orders.getShareFlag()).orderTime(orders.getGmtCreate()).orderGoodsListVOList(orders.getItems().stream().map(e -> {
            String specNames;
            ArrayList<String> specValueList = new ArrayList<String>();
            Integer skuId = e.getSkuId();
            GoodsSkuDetailPO goodsSkuDetailPO = this.goodsSkuDetailPOMapper.selectByPrimaryKey(skuId);
            if (goodsSkuDetailPO != null) {
                specNames = goodsSkuDetailPO.getSpecNames();
                if (specNames.contains(",")) {
                    List<String> strings = Arrays.asList(specNames.split(","));
                    specValueList.addAll(strings);
                } else {
                    specValueList.add(specNames);
                }
            } else {
                specNames = e.getGoodsSkuName();
                if (specNames.contains(",")) {
                    List<String> strings = Arrays.asList(specNames.split(","));
                    specValueList.addAll(strings);
                } else {
                    specValueList.add(specNames);
                }
            }
            BigDecimal discount = this.getDiscount((OrderItems)e);
            log.info("\u8ba1\u7b97\u6298\u6263\u662f:[{}]", (Object)discount.doubleValue());
            return OrderGoodsListVO.builder().goodsNo(e.getGoodsNo()).orderAmount(e.getSaleQuantity()).orderMoney(e.getWepayAmount()).discount(discount).goodsName(e.getGoodsName()).finalPrise(e.getWepayAmount()).goodsImg(e.getGoodsImg()).goodsId(e.getGoodsId().toString()).salePrise(e.getSalePrice()).saleNum(e.getSaleQuantity()).skuNo(e.getGoodsSkuNo()).specValueList(specValueList).build();
        }).collect(Collectors.toList())).build();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u521b\u5efa\u4e13\u5c5e\u8ba2\u5355\u9996\u5355\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString((Object)build)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)build));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u521b\u5efa\u4e13\u5c5e\u8ba2\u5355\u9996\u5355\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new MallCommonException(message);
            }
        }
        catch (Exception e2) {
            log.info(e2.getMessage(), (Throwable)e2);
        }
    }

    private BigDecimal getDiscount(OrderItems orderItems) {
        BigDecimal marketPrice = orderItems.getMarketPrice();
        BigDecimal wepayAmount = orderItems.getWepayAmount();
        if (marketPrice.compareTo(BigDecimal.ZERO) == 0) {
            throw new CustomException("\u8ba1\u7b97\u6298\u6263\u88ab\u9664\u6570\u4e0d\u80fd\u4e3a0");
        }
        BigDecimal dicount = wepayAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(10L) : wepayAmount.divide(marketPrice, 2, 4).multiply(BigDecimal.valueOf(10L));
        log.info("\u8ba1\u7b97\u6298\u6263:marketPrice:[{}]\uff0cwepayAmount:[{}]\uff0c\u7ed3\u679c:dicount:[{}]", new Object[]{marketPrice, wepayAmount, dicount});
        return dicount;
    }

    public void notifyPaidOrderInfoToQW(Orders orders) {
        String url = this.bizvaneProperties.getNotifyPaidOrdersQW();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u4ed8\u6b3e\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString((Object)orders.getOrderNo())});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderNo", orders.getOrderNo());
            map.put("sysStoreId", orders.getShareSysStoreId());
            map.put("sysStaffId", orders.getSysStaffId());
            JSONObject result = this.doGet(url, map, "\u4ed8\u6b3e\u63a8\u9001\u4f01\u5fae");
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u4ed8\u6b3e\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyRefundQW(RefundOrder refundOrder) {
        Integer merchantId = refundOrder.getMerchantId();
        CompanyBrandRelationPO companyBrandRelationPO = this.queryCompanyBrandRelation(merchantId);
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getNotifyRefundQW();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderNo", refundOrder.getOrderNo());
        OrderItems orderItems = refundOrder.getItems().get(0);
        param.put("goodsNo", orderItems.getGoodsNo());
        param.put("goodsAmount", orderItems.getSaleQuantity() + "");
        param.put("goodsMoney", refundOrder.getRefundAmount());
        DrawOrderGoodsVO drawOrderGoodsVO = new DrawOrderGoodsVO();
        drawOrderGoodsVO.setSysCompanyId(companyBrandRelationPO.getCompanyId().longValue());
        drawOrderGoodsVO.setSysBrandId(companyBrandRelationPO.getBrandId().longValue());
        drawOrderGoodsVO.setOrderNo(refundOrder.getOrderNo());
        drawOrderGoodsVO.setGoodsNo(orderItems.getGoodsNo());
        drawOrderGoodsVO.setSkuNo(orderItems.getGoodsSkuNo());
        drawOrderGoodsVO.setGoodsAmount(orderItems.getSaleQuantity().longValue());
        drawOrderGoodsVO.setGoodsMoney(refundOrder.getRefundAmount());
        drawOrderGoodsVO.setRefundOrderNo(refundOrder.getRefundNo());
        drawOrderGoodsVO.setRefundOrderTime(refundOrder.getGmtCreate());
        JSONObject stringObjectMap = JSONObject.parseObject((String)JSON.toJSONString((Object)drawOrderGoodsVO));
        log.info("\u8bf7\u6c42\u4f01\u5fae\u53c2\u6570:{]", (Object)JSON.toJSONString((Object)stringObjectMap));
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u9000\u6b3e\u6216\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString(param)});
            JSONObject result = this.executePost(url, stringObjectMap);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u9000\u6b3e\u6216\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyBrowse(ViewGoodsVO viewGoodsVO) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getNotifyBrowseGoodsQW();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"\u6d4f\u89c8\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString((Object)viewGoodsVO)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)viewGoodsVO));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"\u6d4f\u89c8\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject getOfflineMemberInfo(Integer companyId, Integer brandId, String memberCode) {
        String url = this.bizvaneProperties.getMemberOfStoreInfo();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCode);
        param.put("companyId", companyId);
        param.put("brandId", brandId);
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4f1a\u5458\u6570\u636e", url, param});
        JSONObject result = null;
        try {
            result = this.doGet(url, param, "\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4f1a\u5458\u6570\u636e");
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4f1a\u5458\u6570\u636e", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public String getAppid(String sysBrandId) {
        Example mchExample = new Example(WechatMchNew.class);
        mchExample.createCriteria().andEqualTo("merchantId", (Object)sysBrandId);
        List wechatMchNewList = this.wechatMchNewMapper.selectByExample(mchExample);
        String appid = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)wechatMchNewList)) {
            appid = ((WechatMchNew)wechatMchNewList.get(0)).getAppId();
        }
        return appid;
    }

    public ResponseData<SysParamConfigurationDTO> getParamConfiguration(String appid) {
        log.info("enter getParamConfiguration appid:{}", (Object)appid);
        Example mchExample = new Example(WechatMchNew.class);
        mchExample.createCriteria().andEqualTo("appId", (Object)appid);
        List wechatMchNewList = this.wechatMchNewMapper.selectByExample(mchExample);
        log.info("enter getParamConfiguration request:{}", (Object)JSONObject.toJSONString((Object)wechatMchNewList));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)wechatMchNewList)) {
            return ResponseUtil.getFailedMsg(SysResponseEnum.WECHAT_MCH_NOT_EXISTS.getMessage());
        }
        Integer merchantId = ((WechatMchNew)wechatMchNewList.get(0)).getMerchantId();
        Example companyExample = new Example(CompanyBrandRelation.class);
        companyExample.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List companyBrandRelationList = this.companyBrandRelationMapper.selectByExample(companyExample);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)companyBrandRelationList)) {
            return ResponseUtil.getFailedMsg(SysResponseEnum.COMPANY_NOT_EXISTS.getMessage());
        }
        Integer companyId = ((CompanyBrandRelation)companyBrandRelationList.get(0)).getCompanyId();
        String url = this.bizvaneProperties.getRequestPrefix() + "/wechatEnterprise.api/getParamConfiguration";
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("sysCompanyId", companyId + "");
        param.put("sysBrandId", merchantId + "");
        JSONObject jsonObject = (JSONObject)HttpClient.post((String)url).param(param).asBean(JSONObject.class);
        ResponseData dtoResponseData = (ResponseData)JSON.parseObject((String)jsonObject.toJSONString(), (TypeReference)new TypeReference<ResponseData<SysParamConfigurationDTO>>(){}, (Feature[])new Feature[0]);
        return dtoResponseData;
    }

    public JSONObject generateQrCode(CreateMiniprgmQRCodeRequestVO vo, String url) {
        Long sysBrandId = vo.getSysBrandId();
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(sysBrandId.intValue());
        vo.setSysBrandId(brandId.longValue());
        log.info("merchantId:{},sysBrandId:{}", (Object)sysBrandId, (Object)brandId);
        JSONObject code = this.executePost(url, vo);
        if (this.requestFail(code)) {
            String message = code == null ? "empty" : code.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        String data = code.getString("data");
        log.info("\u751f\u6210\u7684\u4e8c\u7ef4\u7801\u662f:[{}]", (Object)data);
        return code;
    }

    public List getOffLineGoodsInfo(List<SysDimSkuPoDto> dto) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getOfflineGoodsInfoUrl();
        JSONObject code = this.executePost(url, dto);
        if (this.requestFail(code)) {
            String message = code == null ? "empty" : code.getString("message");
            log.warn("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        JSONObject data = code.getJSONObject("data");
        JSONArray sysDimSkuVoList = data.getJSONArray("sysDimSkuVoList");
        Gson gson = new Gson();
        List list = (List)gson.fromJson(sysDimSkuVoList.toString(), new TypeToken<List<SysDimSkuPoDto>>(){}.getType());
        log.info("--------------->\u7ebf\u4e0b\u5546\u54c1\u6570\u636e:[{}]", (Object)data);
        return list;
    }

    public void notifyOrderInfoToQWFirst(Orders orders) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getSharedGoodsAddOrdersToQWUrl();
        ViewShareGoodsInformRequestVO build = ViewShareGoodsInformRequestVO.builder().goodsName(orders.getItems().get(0).getGoodsName()).goodsNo(orders.getItems().get(0).getGoodsNo()).memberCode(orders.getUserNo()).staffCode(orders.getStaffCode()).sysCompanyId(orders.getSysCompanyId()).sysStoreId(orders.getShareSysStoreId()).sysStaffId(orders.getSysStaffId()).build();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u5206\u4eab\u7684\u5546\u54c1\u88ab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae", url, JSONObject.toJSONString((Object)build)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)build));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u5206\u4eab\u7684\u5546\u54c1\u88ab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAddCartInfoQW(ViewShareGoodsInformRequestVO build) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getMemberAddGoodsShopCartToQWUrl();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u5206\u4eab\u5546\u54c1\u6dfb\u52a0\u8d2d\u7269\u8f66\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString((Object)build)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)build));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u5206\u4eab\u5546\u54c1\u6dfb\u52a0\u8d2d\u7269\u8f66\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public void viewShareGoodsInfo(ViewShareGoodsInformRequestVO build) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getViewShareGoodsInfoToQWUrl();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u5206\u4eab\u5546\u54c1\u88ab\u67e5\u770b\u63a8\u9001\u4f01\u5fae", url, JSONObject.toJSONString((Object)build)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)build));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u5206\u4eab\u5546\u54c1\u88ab\u67e5\u770b\u63a8\u9001\u4f01\u5fae", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject checkCorporation(String corporation, String corporationIdCard) {
        JSONObject jsonObject;
        log.info("checkCorporation\u8fdb\u5165");
        String url = this.bizvaneProperties.getCheckCorporationInfoUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unitName", corporation);
        map.put("idCardNumber", corporationIdCard);
        map.put("type", 2);
        try {
            jsonObject = this.doGetSan(url, map, "\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606ftype2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            jsonObject = new JSONObject();
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"\u68c0\u67e5\u4f01\u4e1a\u4fe1\u606f:2\u6709\u6548\u6027\u63a5\u53e3\u5f02\u5e38");
        }
        return jsonObject;
    }

    public JSONObject checkCorporationPassword(String corporationTel, String corporationPassword) {
        JSONObject jsonObject;
        log.info("checkCorporationPassword\u8fdb\u5165");
        String url = this.bizvaneProperties.getCheckCorporationInfoUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("telephone", corporationTel);
        map.put("password", corporationPassword);
        map.put("type", 1);
        try {
            jsonObject = this.doGetSan(url, map, "\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606ftype1");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            jsonObject = new JSONObject();
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"\u68c0\u67e5\u4f01\u4e1a\u4fe1\u606f:1\u6709\u6548\u6027\u63a5\u53e3\u5f02\u5e38");
        }
        return jsonObject;
    }

    public String obtainToken(String appid) {
        String url = this.bizvaneProperties.getObtainTokenUrl();
        log.info("ObtainTokenUrl:{}", (Object)url);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appid);
        try {
            JSONObject jsonObject = this.doPost(url, map, "\u901a\u8fc7appid\u83b7\u53d6accessToken");
            if (jsonObject.getInteger("code") != 0) {
                return null;
            }
            return jsonObject.getString("data");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ResponseData getClassifyQRCord(CompanyBrandRelationPO companyBrandRelationPO) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getIntegralClassifyQRCordUrl();
        log.info("BizvaneInterface_getClassifyQRCord_url:{}", (Object)url);
        JSONObject jsonObject = this.executePost(url, companyBrandRelationPO);
        return ResponseUtil.getSuccessData(jsonObject);
    }

    public JSONObject getStoreListName(SysStoreVo vo) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getIntegralGetStoreListUrl();
        JSONObject jsonObject = this.executePost(url, vo);
        return jsonObject;
    }

    public JSONObject getLevelList(Long brandId) {
        String url = this.bizvaneProperties.getIntegralGetLevelListUrl();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("brandid", brandId);
        JSONObject jsonObject = this.doGet(url, param, "\u79ef\u5206\u5546\u57ce\u83b7\u53d6\u54c1\u724c\u4e0b\u7684\u5168\u90e8\u4f1a\u5458\u7b49\u7ea7\u4fe1\u606f");
        return jsonObject;
    }

    public void notifyQw(GoodsBusinessVO vo) {
        log.info("bizvaneInterface\u4e2dnotifyQw\u5165\u53c2:[{}]", JSON.toJSON((Object)vo));
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getAddGoodsBusinessQWUrl();
        try {
            JSONObject jsonObject = this.executePost(url, vo);
            if (jsonObject != null) {
                log.info("bizvaneInterface\u4e2dnotifyQw\u8fd4\u53c2:[{}]", (Object)jsonObject.toString());
            }
        }
        catch (Exception e) {
            log.error("bizvaneInterface\u4e2dnotifyQw\u5f02\u5e38_" + e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject getofflineStoreById(String pickStoreId) {
        String url = this.bizvaneProperties.getOfflineStoreUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysStoreId", pickStoreId);
        return this.doPost(url, map, "\u67e5\u8be2\u7ebf\u4e0b\u95e8\u5e97\u4fe1\u606f").getJSONObject("data");
    }

    public User getSingleMemberInfo(final User loginUserInfo) {
        String openid = loginUserInfo.getOpenid();
        if (StringUtils.isEmpty((Object)openid)) {
            log.warn("\u4f1a\u5458openid\u4e3a\u7a7a\u76f4\u63a5return null");
            return null;
        }
        final UserCommissionAccounts userCommissionAccounts = this.userCommissionService.selectByOpenId(openid);
        log.info("\u5f53\u524dopenid:{}\u7684\u4f63\u91d1\u8d26\u6237\u4e3a:", (Object)openid, (Object)JSON.toJSONString((Object)userCommissionAccounts));
        if (userCommissionAccounts == null) {
            return null;
        }
        String url = this.bizvaneProperties.getSingleUserInfo();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", userCommissionAccounts.getUserNo());
                this.put("brandId", loginUserInfo.getBrandId());
            }
        };
        JSONObject data = null;
        try {
            data = this.doPost(url, map, "\u83b7\u53d6single\u4f1a\u5458\u4fe1\u606f").getJSONObject("data");
            log.info("BizvaneInterface#getSingleMemberInfo data:{}", (Object)JSON.toJSONString((Object)data));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            log.info("crm\u8fd4\u56de\u7684\u4f1a\u5458\u6570\u636e\u4e3anull\uff0c\u76f4\u63a5\u8fd4\u56de\u4e86");
            return null;
        }
        User remoteUser = new User();
        remoteUser.setUserNo(data.getString("memberCode"));
        remoteUser.setUserId(data.getLong("mbrMemberId"));
        remoteUser.setBrandId(data.getInteger("brandId"));
        remoteUser.setMerchantId(data.getLong("merchantId") == null ? null : Integer.valueOf(data.getLong("merchantId").intValue()));
        remoteUser.setLevelId(data.getInteger("levelId"));
        remoteUser.setFullName(data.getString("name"));
        remoteUser.setOpenid(data.getString("wxOpenId"));
        remoteUser.setUserPhone(data.getString("phone"));
        remoteUser.setSysStoreId(data.getLong("serviceStoreId"));
        remoteUser.setOfflineStoreId(data.getString("storeId"));
        String headPortraits = data.getString("headPortraits");
        if (!StringUtils.isEmpty((Object)headPortraits) && !headPortraits.contains("http")) {
            headPortraits = "https://" + this.qiNiuProperties.getDomain() + "/" + headPortraits;
        }
        remoteUser.setHeadImgUrl(headPortraits);
        remoteUser.setEnabledCommission(data.getBoolean("distributionState"));
        remoteUser.setCountIntegral(data.getLong("countIntegral"));
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4fe1\u606f\u8fd4\u56de\u53c2\u6570:[{}]", JSON.toJSON((Object)remoteUser));
        return remoteUser;
    }

    public JSONObject getSingleMemberInfoJSON(final String userNo) {
        String url = this.bizvaneProperties.getSingleUserInfo();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", userNo);
            }
        };
        JSONObject data = null;
        try {
            data = this.doPost(url, map, "\u65b0\u589e\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3").getJSONObject("data");
            log.info("BizvaneInterface#getSingleMemberInfoJSON data:{}", (Object)JSON.toJSONString((Object)data));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            log.info("crm\u8fd4\u56de\u7684\u4f1a\u5458\u6570\u636e\u4e3anull\uff0c\u76f4\u63a5\u8fd4\u56de\u4e86");
            return null;
        }
        return data;
    }

    public ResponseData<MallOpenCardResponseVo> openCard(MallOpenCardRequestVo mallOpenCardRequestVo, BrowseVO browseVO) {
        log.info("BizvaneInterface # openCard request:{}", (Object)JSON.toJSONString((Object)mallOpenCardRequestVo));
        HashMap hashMap = (HashMap)JSON.parseObject((String)JSON.toJSONString((Object)mallOpenCardRequestVo), HashMap.class);
        if (browseVO != null) {
            String sysStaffId = browseVO.getSysStaffId();
            String sysStoreId = browseVO.getSysStoreId();
            if (!StringUtils.isEmpty((Object)sysStaffId)) {
                hashMap.put("guideId", sysStaffId);
            }
            if (!StringUtils.isEmpty((Object)sysStoreId)) {
                hashMap.put("storeId", sysStoreId);
            }
        }
        String url = this.bizvaneProperties.getCrmOpenCardUrl();
        JSONObject result = this.doPost(url, hashMap, "\u8c03\u7528crm\u6ce8\u518c\u63a5\u53e3");
        ResponseData responseData = (ResponseData)JSON.parseObject((String)result.toJSONString(), ResponseData.class);
        log.info("BizvaneInterface # openCard response:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    public CompanyBrandRelationPO queryCompanyBrandRelation(Integer brandId) {
        CompanyBrandRelationPO companyBrandRelationPO = new CompanyBrandRelationPO();
        companyBrandRelationPO.setMerchantId(brandId);
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andBrandIdEqualTo(brandId);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            throw new CustomException("\u5546\u6237\u672a\u914d\u7f6e\u54c1\u724c,\u65e0\u6cd5\u5f00\u5361");
        }
        return companyBrandRelationPOS.get(0);
    }

    public void checkUnionId(String unionId) {
        if (StringUtils.isEmpty((Object)unionId)) {
            throw new CustomException("\u5546\u6237\u672a\u914d\u7f6e\uff0c\u6682\u65f6\u65e0\u6cd5\u67e5\u770b");
        }
    }

    public RestResult refundIntegralChangeFor361(final IntegralOrders orders) {
        log.info("\u9000\u8fd8\u79ef\u5206\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)orders));
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        final String changeBills = UUID.randomUUID().toString();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", orders.getMemberCode());
                this.put("changeIntegral", orders.getSaleIntegral() * orders.getSaleQuantity());
                this.put("changeType", 2);
                this.put("changeBills", changeBills);
                this.put("businessType", 31);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult pustIntegralOrder(String orderNo) {
        log.info("pustIntegralOrder\u53c2\u6570:{}", (Object)orderNo);
        String url = this.bizvaneProperties.getPustIntegralOrderUrl();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        Example integralOrdersExample = new Example(IntegralOrders.class);
        integralOrdersExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        IntegralOrders integralOrders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample(integralOrdersExample);
        if (integralOrders == null) {
            log.info("pustIntegralOrder IntegralOrders\u4e3a\u7a7a,\u76f4\u63a5return");
            return RestResult.fail();
        }
        Example integralOrdersDetailsExample = new Example(IntegralOrdersDetails.class);
        integralOrdersDetailsExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        IntegralOrdersDetails integralOrdersDetails = (IntegralOrdersDetails)this.integralOrdersDetailsMapper.selectOneByExample(integralOrdersDetailsExample);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("integralOrders", integralOrders);
        map.put("integralOrdersDetails", integralOrdersDetails);
        map.put("brandId", integralOrders.getMerchantId());
        JSONObject data = this.doPost(url, map, "push\u79ef\u5206\u8ba2\u5355");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public BaseResponse<List<GetStockResponseVO>> getStocks(GetStockRequestVO requestVO) {
        log.info("getStocks\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)requestVO));
        String url = this.bizvaneProperties.getHuaiRenGetStocksUrl();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        Map beanMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)requestVO), Map.class);
        JSONObject data = null;
        try {
            data = this.doPost(url, beanMap, "bizvaneInterface\u5b9e\u65f6\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3");
        }
        catch (Exception e) {
            log.info("\u53ef\u80fd\u5b58\u5728\u8c03\u7528\u6000\u4ec1\u63a5\u53e3\u8d85\u65f6\u5f02\u5e38:{},e:{}", (Object)e.getMessage(), (Object)e);
            throw new WechatException("\u8be5\u5546\u54c1\u5e93\u5b58\u4e3a0");
        }
        if (data != null && data.getInteger("code") == 0) {
            BaseResponse result = (BaseResponse)JSON.parseObject((String)data.toJSONString(), BaseResponse.class);
            return result;
        }
        return new BaseResponse<List<GetStockResponseVO>>(-1, "\u83b7\u53d6\u5e93\u5b58\u5931\u8d25!");
    }

    public BaseResponse<MemberInfoModel> getMemberInfoByCardNo(MemberInfoModel requestVO) {
        log.info("getMemberInfoByCardNo:{}", (Object)JSON.toJSONString((Object)requestVO));
        String url = this.bizvaneProperties.getGetMemberInfoByCardNo();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        Map beanMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)requestVO), Map.class);
        JSONObject data = this.doPost(url, beanMap, "bizvaneInterface\u5361\u53f7\u5b9e\u65f6\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3");
        if (data != null && data.getInteger("code") == 0) {
            BaseResponse result = (BaseResponse)JSON.parseObject((String)data.toJSONString(), BaseResponse.class);
            return result;
        }
        return new BaseResponse<MemberInfoModel>(-1, "\u5361\u53f7\u5b9e\u65f6\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3\u5931\u8d25!");
    }

    public BaseResponse<MemberInfoModel> pushOrderToConnector(IntegralOrderRequestVo integralOrderRequestVo) {
        log.info("pushOrderToConnector:{}", (Object)JSON.toJSONString((Object)integralOrderRequestVo));
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getPushOrderToConnector();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        Map beanMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)integralOrderRequestVo), Map.class);
        JSONObject data = (JSONObject)JSON.parseObject((String)this.HttpPostWithJson(url, JSON.toJSONString((Object)beanMap)), JSONObject.class);
        if (data != null && data.getInteger("code") == 0) {
            BaseResponse result = (BaseResponse)JSON.parseObject((String)data.toJSONString(), BaseResponse.class);
            return result;
        }
        return new BaseResponse<MemberInfoModel>(-1, "\u79ef\u5206\u8ba2\u5355\u5b9e\u65f6\u63a8\u9001\u63a5\u53e3\u5931\u8d25!");
    }

    public List<CouponDTO> getCoupon4Mall(final CouponDTO dto) {
        HashMap map;
        String url = this.bizvaneProperties.getCouponList4MallUrl();
        JSONArray data = this.doPost(url, map = new HashMap(){
            {
                this.put("pageNum", dto.getPageNumber());
                this.put("pageSize", dto.getPageSize());
                this.put("couponName", dto.getCouponName() == null ? "" : dto.getCouponName());
                this.put("sysBrandId", dto.getBrandId());
            }
        }, "\u5e97\u94fa\u88c5\u4fee\u9875\u67e5\u8be2\u4f18\u60e0\u5238\u5217\u8868").getJSONArray("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject current = data.getJSONObject(i);
            if (!current.getBooleanValue("canReceive")) continue;
            JSONObject couponJson = current.getJSONObject("couponDetailResponseVO").getJSONObject("couponDefinitionPO");
            CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(couponJson);
            couponDTO.setActivityId(current.getInteger("mktActivityId"));
            couponDTO.setPerPersonMax(current.getInteger("perPersonMax"));
            couponDTO.setPerPersonPerDayMax(current.getInteger("perPersonPerDayMax"));
            if (CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)couponDTO.getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        return couponDTOList;
    }

    public JSONObject getCompanyStoreCategory(final Integer brandId) {
        String url = this.bizvaneProperties.getCompanyStoreCategory() + "?brandId=" + brandId;
        HashMap map = new HashMap(){
            {
                this.put("brandId", brandId);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u4f01\u4e1a\u5343\u5e97\u5343\u9762\u914d\u7f6e");
        return data;
    }

    public void selfPickedOrderNoticeShow(final SelfPickNoticeRequestVO orders, String changeUrl) {
        log.info("\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)orders));
        String url = this.bizvaneProperties.getRequestPrefix() + changeUrl;
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        JSONObject jsonObject = new JSONObject(){
            {
                this.put("buyerName", orders.getBuyerName());
                this.put("buyerPhone", orders.getBuyerPhone());
                this.put("orderNo", orders.getOrderNo());
                this.put("orderTime", orders.getOrderTime());
                this.put("refundTime", orders.getRefundTime());
                this.put("sysBrandId", orders.getSysBrandId());
                this.put("offlineStoreId", orders.getOfflineStoreId());
                this.put("wxNick", orders.getWxNick());
            }
        };
        try {
            Response response = this.okHttp3PostJSON(url, jsonObject.toJSONString(), null);
            log.info("selfPickedOrderNoticeShow#response:{}", JSON.toJSON((Object)response));
            response.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u81ea\u63d0\u4e0b\u5355\u901a\u77e5\u5546\u79c0 ExceptionMessage:{}", (Object)e.getMessage());
        }
    }

    public Response okHttp3PostJSON(String url, String jsonStr, Map<String, String> headers) throws IOException {
        log.info("okHttp3PostJSON#jsonStr:{}url:{}", (Object)jsonStr, (Object)url);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonStr);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody);
        if (!CollectionUtils.isEmpty(headers)) {
            for (Map.Entry<String, String> mapEntry : headers.entrySet()) {
                if (Objects.isNull(mapEntry.getValue())) continue;
                requestBuilder.addHeader(mapEntry.getKey(), String.valueOf(mapEntry.getValue()));
            }
        }
        Request request = requestBuilder.build();
        OkHttpClient okHttpClient = new OkHttpClient();
        Response response = okHttpClient.newCall(request).execute();
        log.info(url + " postJSON response-->" + JSON.toJSON((Object)response));
        return response;
    }

    public ResponseData getCouponReceiveStatus(JSONObject param) {
        log.info("\u8c03\u7528applet.getCouponReceiveStatus");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getCouponReceiveStatusUrl();
        JSONObject result = this.executePost(url, param);
        if (result == null || result.isEmpty()) {
            return ResponseUtil.getFailedMsg("\u8bf7\u6c42\u62a5\u9519");
        }
        log.info("applet.api_getCouponReceiveStatus\u67e5\u8be2\u7ed3\u679c" + JSON.toJSON((Object)result.get((Object)"data")));
        return new ResponseData<Object>(result.get((Object)"data"));
    }

    public void insertShareGoodsOperatorUrl(ShareGoodsOperatorRequestVO shareGoodsOperatorRequestVO) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getInsertShareGoodsOperatorUrl();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u5546\u79c0\u5206\u4eab\u5546\u54c1\u64cd\u4f5c\u8bb0\u5f55", url, JSONObject.toJSONString((Object)shareGoodsOperatorRequestVO)});
            JSONObject result = this.executePost(url, JSON.toJSON((Object)shareGoodsOperatorRequestVO));
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u5546\u79c0\u5206\u4eab\u5546\u54c1\u64cd\u4f5c\u8bb0\u5f55", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5546\u79c0\u5206\u4eab\u5546\u54c1\u64cd\u4f5c\u8bb0\u5f55error:{}", (Throwable)e);
        }
    }

    public static void main(String[] args) throws IOException {
        String url = " https://www.test.bizvane.cn/applet.api/IntegralMallOrderPush";
    }

    public ResponseData notifyForCloseOrderById(final Integer ordersId) {
        String url = this.bizvaneProperties.getNotifyForCloseOrderByIdUrl() + ordersId;
        String changeBills = UUID.randomUUID().toString();
        HashMap map = new HashMap(){
            {
                this.put("ordersId", ordersId);
            }
        };
        JSONObject data = this.doPostJSON(url, map, "\u901a\u77e5wechat\u64cd\u4f5c\u5b9a\u91d1\u9884\u552e\u8ba2\u5355");
        if (data == null || data.isEmpty()) {
            return ResponseUtil.getFailedMsg("\u8c03\u7528\u63a5\u53e3\u5931\u8d25!");
        }
        int code = data.getIntValue("code");
        String message = data.getString("message");
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(code);
        responseData.setMessage(message);
        return responseData;
    }

    public String getIntegralShopGetDistributorName(String memberCode) {
        String url = this.bizvaneProperties.getIntegralShopGetDistributorName();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCode);
        JSONObject jsonObject = this.doGet(url, param, "\u79ef\u5206\u5546\u57ce\u83b7\u53d6\u8ba2\u5355\u7ecf\u9500\u5546");
        Integer code = jsonObject.getInteger("code");
        String data = jsonObject.getString("data");
        if (SysResponseEnum.SUCCESS.getCode() == code.intValue()) {
            return data;
        }
        return null;
    }

    public void payCouponSuccess(Integer convertCouponRecordId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("convertCouponRecordId", convertCouponRecordId);
        String url = this.bizvaneProperties.getPayCouponSuccess();
        try {
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ", new Object[]{"----------->\u5238\u652f\u4ed8\u6210\u529f", url, JSONObject.toJSONString(map)});
            JSONObject result = this.doGet(url, map, "\u5238\u652f\u4ed8\u6210\u529f");
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u54cd\u5e94\u53c2\u6570\uff1a {}", new Object[]{"----------->\u5238\u652f\u4ed8\u6210\u529f", url, result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.warn("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.error("\u79ef\u5206\u5546\u57ce\u4f18\u60e0\u5238\u652f\u4ed8\u5931\u8d25:{}", (Throwable)e);
        }
    }

    public JSONObject getStoreById(String storeId) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getGetStoreByIdUrl() + "?sysStoreId=" + storeId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysStoreId", storeId);
        return this.doPostJSON(url, map, "\u6839\u636e\u95e8\u5e97id\u67e5\u8be2\u95e8\u5e97\u8be6\u60c5").getJSONObject("data");
    }

    public JSONObject getStaffById(String staffId) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getGetStaffByIdUrl() + "?sysStaffId=" + staffId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysStoreId", staffId);
        return this.doPostJSON(url, map, "\u6839\u636e\u5458\u5de5id\u67e5\u8be2\u5458\u5de5\u8be6\u60c5").getJSONObject("data");
    }

    public void updateIntegralConfig2Redis(IntegralConfig config) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getUpdateIntegralConfig2Redis();
        log.info("\u83b7\u53d6\u7684url:{}", (Object)JSONObject.toJSONString((Object)url));
        JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString((Object)config));
        log.info("\u914d\u7f6e\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        try {
            Response response = this.okHttp3PostJSON(url, jsonObject.toJSONString(), null);
            log.info("updateIntegralConfig2Redis#response:{}", JSON.toJSON((Object)response));
            response.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u66f4\u65b0 ExceptionMessage:{}", (Object)e.getMessage());
        }
    }

    public ResponseData<String> upOrDownShelfIntegralCoupon(Long exchangeId, Boolean shelfJudge) {
        String url = this.bizvaneProperties.getAutoShelfIntegralCoupon();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exchangeId", exchangeId);
        map.put("shelfJudge", shelfJudge);
        JSONObject jsonObject = this.doGet(url, map, "\u4e0a\u4e0b\u67b6\u4f18\u60e0\u5238");
        ResponseData<String> responseData = new ResponseData<String>();
        responseData.setData(jsonObject.getString("data"));
        responseData.setCode(jsonObject.getInteger("code"));
        responseData.setMessage(jsonObject.getString("message"));
        log.info("BizvaneInterface#upOrDownShelfIntegralCoupon#data:{}", (Object)JSON.toJSONString(responseData));
        return responseData;
    }
}

