/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.FastbootApplication;
import com.wmeimob.fastboot.bizvane.dto.GoodsStockChangeResponseDTO;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.StorePriceStock;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.StockCheckServiceMapper;
import com.wmeimob.fastboot.bizvane.mapper.StorePriceStockMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.FeignClientInterface;
import com.wmeimob.fastboot.bizvane.service.StorePriceStockService;
import com.wmeimob.fastboot.bizvane.service.huairen.HuairenFeignService;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.BaseResponse;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.GetStockRequestVO;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.GetStockResponseVO;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class StorePriceStockServiceImpl
implements StorePriceStockService {
    private static final Logger log = LoggerFactory.getLogger(StorePriceStockServiceImpl.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private HuairenFeignService huairenFeignService;
    @Autowired
    private StorePriceStockMapper stockMapper;
    @Autowired
    private StockCheckServiceMapper stockCheckServiceMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    @Override
    public List<StorePriceStock> listByStoreId(long merchantId, long storeId, List<Long> ids) {
        List<StorePriceStock> list = this.stockMapper.selectByStoreId(merchantId, storeId, ids);
        return list;
    }

    @Override
    public List<StorePriceStock> listByGoodId(Integer goodId, Integer storeId) {
        return this.stockMapper.listByGoodId(goodId.intValue(), storeId.intValue());
    }

    @Override
    public boolean checkStockLocal(String skuNo, Integer sysStoreId, Integer quantity) {
        StorePriceStock storePriceStock = this.stockMapper.selectLocalStockAndPrice(sysStoreId.longValue(), skuNo);
        return storePriceStock.getStoreStock() != null && storePriceStock.getStoreStock() >= quantity;
    }

    @Override
    @Deprecated
    public boolean checkStockRemote(String skuNo, Integer sysStoreId, Integer brandId, Integer quantity) {
        GetStockRequestVO requestVO = new GetStockRequestVO();
        requestVO.setBrandId(brandId);
        requestVO.setSkuCodes(skuNo);
        requestVO.setStoreId(sysStoreId + "");
        BaseResponse<List<GetStockResponseVO>> response = this.bizvaneInterface.getStocks(requestVO);
        if (response.getData() != null && response.getData().size() > 0) {
            return response.getData().get(0).getStock() != null && response.getData().get(0).getStock() >= quantity;
        }
        return false;
    }

    public <T extends FeignClientInterface> T getFeignClientInterface(Integer merchantId) {
        String name = this.stockCheckServiceMapper.selectClassByMerchantId(merchantId);
        try {
            FeignClientInterface service = (FeignClientInterface)FastbootApplication.getBean(Class.forName(name));
            return (T)service;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<GetStockResponseVO> getRemoteStocks(Integer merchantId, String storeId, String skuCodes) {
        Object feignClientInterface = this.getFeignClientInterface(merchantId);
        GetStockRequestVO requestVO = new GetStockRequestVO();
        requestVO.setBrandId(merchantId);
        requestVO.setStoreId(storeId);
        requestVO.setSkuCodes(skuCodes);
        BaseResponse<List<GetStockResponseVO>> response = null;
        try {
            response = feignClientInterface.getStocks(requestVO);
        }
        catch (Exception e2) {
            log.info("\u53ef\u80fd\u5b58\u5728\u8c03\u7528\u6000\u4ec1\u63a5\u53e3\u8d85\u65f6\u5f02\u5e38:{},e:{}", (Object)e2.getMessage(), (Object)e2);
            throw new MallCommonException("\u5e93\u5b58\u4e3a0");
        }
        log.info("\u83b7\u53d6\u7ebf\u4e0b\u5e93\u5b58\u7ed3\u679c:{}", JSON.toJSON(response));
        if (response.getCode().equals(0)) {
            List offlineInfo = JSONObject.parseArray((String)JSON.toJSONString(response.getData()), GetStockResponseVO.class);
            List noStocks = offlineInfo.stream().filter(e -> e.getStock() <= 0).collect(Collectors.toList());
            log.info("\u66f4\u65b0\u7ebf\u4e0a\u5e93\u5b58\u5165\u53c2:{}", JSON.toJSON(noStocks));
            if (!CollectionUtils.isEmpty(noStocks)) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    List offlineRealStock = noStocks.stream().map(e -> {
                        StorePriceStock sps = new StorePriceStock();
                        sps.setMerchantId(merchantId.longValue());
                        sps.setStoreId(Long.parseLong(storeId));
                        sps.setSkuCode(e.getSkuCode());
                        sps.setGoodsCode(e.getGoodsNo());
                        sps.setStoreStock(e.getStock());
                        return sps;
                    }).collect(Collectors.toList());
                    offlineRealStock.stream().forEach(e -> {
                        Example example = new Example(StorePriceStock.class);
                        Example.Criteria criteria = example.createCriteria();
                        criteria.andEqualTo("storeId", (Object)storeId).andEqualTo("skuCode", (Object)e.getSkuCode()).andEqualTo("merchantId", (Object)merchantId).andEqualTo("goodsCode", (Object)e.getGoodsCode());
                        this.stockMapper.updateByExampleSelective(e, example);
                    });
                });
            }
            return JSONObject.parseArray((String)JSON.toJSONString(response.getData()), GetStockResponseVO.class);
        }
        log.info(response.getMessage());
        return null;
    }

    @Override
    public List<GoodsStockChangeResponseDTO> inventoryReduction(List<StorePriceStock> skuInfo) {
        ArrayList<GoodsStockChangeResponseDTO> responseDTOList = new ArrayList<GoodsStockChangeResponseDTO>();
        for (StorePriceStock skuDetail : skuInfo) {
            int result = this.stockMapper.inventoryReduction(skuDetail);
            if (result != 0) continue;
            responseDTOList.add(GoodsStockChangeResponseDTO.builder().goodsId(skuDetail.getGoodsId().intValue()).goodsName(skuDetail.getGoodsName()).skuNo(skuDetail.getSkuCode()).count(skuDetail.getStoreStock()).failReason("\u5e93\u5b58\u4e0d\u8db3").build());
        }
        return responseDTOList;
    }

    @Override
    public List<GoodsStockChangeResponseDTO> inventoryResume(List<StorePriceStock> skuInfo) {
        ArrayList<GoodsStockChangeResponseDTO> responseDTOList = new ArrayList<GoodsStockChangeResponseDTO>();
        for (StorePriceStock skuDetail : skuInfo) {
            this.stockMapper.inventoryResume(skuDetail);
        }
        return responseDTOList;
    }

    public List<StorePriceStock> findListByCondition(List<StorePriceStock> conditions) {
        Example example = new Example(GoodsSkuDetail.class);
        if (conditions.isEmpty()) {
            return new ArrayList<StorePriceStock>();
        }
        for (StorePriceStock condition : conditions) {
            this.checkQueryParam(condition);
            example.or(example.createCriteria().andEqualTo("goodsCode", (Object)condition.getGoodsId()).andEqualTo("storeId", (Object)condition.getStoreId()).andEqualTo("merchantId", (Object)condition.getMerchantId()).andEqualTo("skuCode", (Object)condition.getSkuCode()));
        }
        return this.stockMapper.selectByExample(example);
    }

    private void checkQueryParam(StorePriceStock condition) {
        InputValidator.checkNull((Object)condition.getGoodsId(), (String)"\u5546\u54c1ID");
        InputValidator.checkEmpty((Object)condition.getSkuCode(), (String)"\u5546\u54c1\u89c4\u683c");
    }

    @Override
    public List<StorePriceStock> listBySkuNos(List<String> skuNos, Long sysStoreId, Integer merchantId) {
        return this.stockMapper.listBySkuNos(merchantId.intValue(), sysStoreId, skuNos);
    }
}

