/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.region.impl;

import com.wmeimob.fastboot.bizvane.newmapper.RegionPOMapper;
import com.wmeimob.fastboot.bizvane.po.RegionPO;
import com.wmeimob.fastboot.bizvane.po.RegionPOExample;
import com.wmeimob.fastboot.bizvane.service.region.RegionService;
import com.wmeimob.fastboot.bizvane.vo.admin.RegionResponseVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RegionServiceImpl
implements RegionService {
    private static final Logger log = LoggerFactory.getLogger(RegionServiceImpl.class);
    @Resource
    private RegionPOMapper regionPoMapper;

    public List<RegionResponseVO> queryProvinceOrCityOrDistrictIfo(Integer pid) {
        try {
            RegionPOExample example = new RegionPOExample();
            example.setOrderByClause("ID ASC");
            RegionPOExample.Criteria criteria = example.createCriteria().andValidEqualTo(Boolean.TRUE);
            if (StringUtils.isEmpty((Object)pid)) {
                criteria.andPidEqualTo(Integer.valueOf(0));
            } else {
                criteria.andPidEqualTo(pid);
            }
            List regionPoList = this.regionPoMapper.selectByExample(example);
            ArrayList<RegionResponseVO> arrayList = new ArrayList<RegionResponseVO>();
            regionPoList.forEach(regionPo -> {
                RegionResponseVO responseVo = this.convertRegionPoToResponseVo(regionPo, new RegionResponseVO());
                arrayList.add(responseVo);
            });
            return arrayList;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5730\u533a\u4fe1\u606f\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private RegionResponseVO convertRegionPoToResponseVo(RegionPO regionPo, RegionResponseVO regionResponseVO) {
        regionResponseVO.setFullName(regionPo.getFullName());
        regionResponseVO.setId(regionPo.getId());
        return regionResponseVO;
    }
}

