/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigService;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralUnionPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralWeChatMchService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralCouponPayVO;
import java.math.BigDecimal;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IntegralPayServiceImpl
implements IntegralPayService {
    private static final Logger log = LoggerFactory.getLogger(IntegralPayServiceImpl.class);
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Autowired
    private IntegralWeChatMchService integralWeChatMchService;
    @Autowired
    private IntegralConfigService integralConfigService;
    @Autowired
    private IntegralUnionPayService integralUnionPayService;

    public ResponseData<JsPayResponse> payment(Integer orderId) {
        if (orderId == null) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570!");
        }
        IntegralOrders integralOrders = this.integralOrdersService.getOrderById(orderId);
        if (integralOrders == null) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        Integer merchantId = integralOrders.getMerchantId();
        String orderNo = integralOrders.getOrderNo();
        IntegralConfig integralConfig = this.integralConfigService.getConfig(merchantId);
        Integer cashPayChannel = integralConfig.getCashPayChannel();
        if (IntegralCashPayChannelEnum.NO_CASH_PAY.getCode() == cashPayChannel) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u57ce\u672a\u914d\u7f6e\u73b0\u91d1\u652f\u4ed8\u65b9\u5f0f,\u65e0\u6cd5\u652f\u4ed8!");
        }
        if (IntegralCashPayChannelEnum.UNION_PAY.getCode() == cashPayChannel) {
            log.info("\u79ef\u5206\u8ba2\u5355:{}_\u94f6\u8054\u652f\u4ed8", (Object)orderNo);
            ResponseData unionPayment = this.integralUnionPayService.payment(orderId);
            return unionPayment;
        }
        log.info("\u79ef\u5206\u8ba2\u5355:{}_\u5fae\u4fe1\u652f\u4ed8", (Object)orderNo);
        ResponseData weChatPayment = this.integralWeChatMchService.payment(orderId);
        return weChatPayment;
    }

    public ResponseData<JsPayResponse> paymentWithCoupon(IntegralCouponPayVO integralCouponPayVO) {
        if (integralCouponPayVO == null) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570!");
        }
        Integer merchantId = integralCouponPayVO.getMerchantId();
        String openId = integralCouponPayVO.getOpenId();
        String convertCouponRecordCode = integralCouponPayVO.getConvertCouponRecordCode();
        Long convertCouponRecordId = integralCouponPayVO.getConvertCouponRecordId();
        BigDecimal price = integralCouponPayVO.getPrice();
        if (merchantId == null || StringUtils.isEmpty((Object)openId) || StringUtils.isEmpty((Object)convertCouponRecordCode) || convertCouponRecordId == null || price == null) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570!");
        }
        IntegralConfig integralConfig = this.integralConfigService.getConfig(merchantId);
        Integer cashPayChannel = integralConfig.getCashPayChannel();
        if (IntegralCashPayChannelEnum.NO_CASH_PAY.getCode() == cashPayChannel) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u57ce\u672a\u914d\u7f6e\u73b0\u91d1\u652f\u4ed8\u65b9\u5f0f,\u65e0\u6cd5\u652f\u4ed8!");
        }
        if (IntegralCashPayChannelEnum.UNION_PAY.getCode() == cashPayChannel) {
            log.info("\u79ef\u5206\u4f18\u60e0\u5238\u8ba2\u5355:{}_\u94f6\u8054\u652f\u4ed8", (Object)convertCouponRecordCode);
            ResponseData unionPayment = this.integralUnionPayService.paymentWithCoupon(integralCouponPayVO);
            return unionPayment;
        }
        log.info("\u79ef\u5206\u4f18\u60e0\u5238\u8ba2\u5355:{}_\u5fae\u4fe1\u652f\u4ed8", (Object)convertCouponRecordCode);
        ResponseData weChatPayment = this.integralWeChatMchService.paymentWithCoupon(integralCouponPayVO);
        return weChatPayment;
    }
}

