/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderJobService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralOrderJobServiceImpl
implements IntegralOrderJobService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderJobServiceImpl.class);
    @Autowired
    private XxlJobUtil xxlJobUtil;
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;

    public void addCustomizedIntegralOrderCancelJob(Integer merchantId, String orderNo) {
        log.info("IntegralOrderJobServiceImpl#addCustomizedIntegralOrderCancelJob:merchantId={},orderNo={}", (Object)merchantId, (Object)orderNo);
        try {
            IntegralOrdersPO integralOrdersPo = this.integralOrdersNewService.queryIntegralOrderByOrderNo(orderNo);
            IntegralConfigPO integralConfigPo = this.integralOrdersNewService.queryIntegralConfigByMerchantId(merchantId);
            Integer awaitOrderCancel = integralConfigPo.getAwaitOrderCancel();
            Date orderTime = integralOrdersPo.getOrderTime();
            Date executeDate = DateUtils.addMinutes((Date)orderTime, (int)awaitOrderCancel);
            JSONObject paramsJsonObject = new JSONObject();
            paramsJsonObject.put("merchantId", (Object)merchantId);
            paramsJsonObject.put("orderNo", (Object)orderNo);
            String paramsJsonString = JSON.toJSONString((Object)paramsJsonObject);
            String bizCode = merchantId + "," + orderNo;
            this.xxlJobUtil.addJob(executeDate, "\u79ef\u5206\u5546\u57ce\u672a\u652f\u4ed8\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88", paramsJsonString, "mall_admin", "CustomizedIntegralOrderCancelJob", 1, bizCode, "mall_admin");
        }
        catch (Exception e) {
            log.warn("IntegralOrderJobServiceImpl#addCustomizedIntegralOrderCancelJob\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
    }
}

