/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelConfigDto;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewayChannelTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralRefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralRefundOrderPO;
import com.wmeimob.fastboot.bizvane.po.IntegralRefundOrderPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPO;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigServiceImpl;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayChannelService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralWeChatMchService;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayRefundOrderVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralRefundOrderServiceImpl
implements IntegralRefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(IntegralRefundOrderServiceImpl.class);
    @Resource
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Autowired
    private IntegralConfigServiceImpl integralConfigServiceImpl;
    @Autowired
    private IntegralWeChatMchService integralWeChatMchService;
    @Autowired
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Resource
    private IntegralRefundOrderPOMapper integralRefundOrderPOMapper;
    @Autowired
    private PayGatewayPayService payGatewayPayService;
    @Autowired
    private PayGatewayChannelService payGatewayChannelService;

    @Transactional(rollbackFor={Exception.class})
    public IntegralRefundOrder submitReturnGoods(IntegralRefundOrder refundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u8ba2\u5355\u3002\u3002\u3002\u3002\u3002\u3002\u3002START................");
        log.info("\u6821\u9a8c\u5546\u6237\u662f\u5426\u5173\u95ed\u53d6\u6d88\u8ba2\u5355\u529f\u80fd:{}", (Object)JSON.toJSONString((Object)refundOrder));
        IntegralConfig config = this.integralConfigServiceImpl.getConfig(refundOrder.getMerchantId());
        log.info("\u83b7\u53d6\u5230\u7684\u914d\u7f6e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)config));
        if (!config.isRefundSingle()) {
            throw new CustomException("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u9000\u5355");
        }
        log.info("\u6821\u9a8c\u662f\u5426\u5b58\u5728\u539f\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)refundOrder.getOrderNo());
        Example orderExample = new Example(IntegralOrders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)orderExample);
        if (orders == null) {
            throw new CustomException("\u4e0d\u5b58\u5728\u539f\u8d2d\u4e70\u8ba2\u5355,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        log.info("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)orders));
        IntegralOrdersDetails ordersDetails = (IntegralOrdersDetails)this.integralOrdersDetailsMapper.selectByPrimaryKey((Object)refundOrder.getOrderDetailId());
        if (ordersDetails == null) {
            throw new CustomException("\u4e0d\u5b58\u5728\u8ba2\u5355\u660e\u7ec6,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)ordersDetails));
        log.info("\u6821\u9a8c\u662f\u5426\u5b58\u5728\u9000\u8d27\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)refundOrder.getOrderNo());
        Example refundExample = new Example(IntegralRefundOrder.class);
        refundExample.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder oldRefundOrders = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)refundExample);
        if (oldRefundOrders != null) {
            throw new CustomException("\u5df2\u5b58\u5728\u9000\u8d27\u8ba2\u5355,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        refundOrder.setRefundNo(IntegralOrderNoUtil.getRefundOrderNo());
        refundOrder.setRefundIntegral(ordersDetails.getSaleIntegral());
        refundOrder.setRefundQuantity(ordersDetails.getSaleQuantity());
        refundOrder.setRefundCash(this.getRefundCashWithFreight(ordersDetails, orders));
        refundOrder.setGmtCreate(new Date());
        String cancel = "0";
        if (cancel.equals(refundOrder.getRefundType())) {
            refundOrder.setRefundTime(new Date());
            refundOrder.setAuditStatus("1");
            refundOrder.setAuditTime(new Date());
            refundOrder.setAuditReback("\u7528\u6237\u53d6\u6d88\u8ba2\u5355");
            refundOrder.setAuditStatus("1");
        } else {
            refundOrder.setAuditor(null);
            refundOrder.setAuditStatus("0");
        }
        this.integralRefundOrderMapper.insertSelective((Object)refundOrder);
        String orderStatus = orders.getOrderStatus();
        if (cancel.equals(refundOrder.getRefundType())) {
            Boolean refundMoney = Boolean.FALSE;
            if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equalsIgnoreCase(orderStatus)) {
                refundMoney = null;
            } else {
                BigDecimal freight;
                BigDecimal cashPrice = ordersDetails.getCashPrice();
                BigDecimal orderCash = cashPrice.add(freight = orders.getFreight());
                if (orderCash.compareTo(BigDecimal.ZERO) == 1) {
                    refundMoney = Boolean.TRUE;
                }
            }
            this.integralOrdersService.refund(orders.getOrderNo(), orders.getMerchantId(), null, null, refundMoney);
        }
        orders.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
        if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equalsIgnoreCase(orderStatus)) {
            orders.setOrderStatus(IntegralOrdersStatusEnum.CLOSE.getCode());
        }
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        log.info("\u63d0\u4ea4\u9000\u8d27\u8ba2\u5355\u3002\u3002\u3002\u3002\u3002\u3002\u3002END................");
        return refundOrder;
    }

    private BigDecimal getRefundCashWithFreight(IntegralOrdersDetails ordersDetails, IntegralOrders orders) {
        BigDecimal freight = orders.getFreight();
        BigDecimal salePrice = ordersDetails.getSalePrice();
        BigDecimal refundCashWithFreight = null;
        refundCashWithFreight = freight != null && freight.compareTo(BigDecimal.ZERO) == 1 ? refundCashWithFreight.add(freight) : salePrice;
        return refundCashWithFreight;
    }

    @Transactional(rollbackFor={Exception.class})
    public IntegralRefundOrder submitRefundLogistics(IntegralRefundOrder refundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u7269\u6d41\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002\u3002\u3002START................");
        Example example = new Example(IntegralRefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundOrder.getRefundNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder integralRefundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)example);
        if (integralRefundOrder == null) {
            throw new CustomException("\u6b64\u9000\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        String unAudited = "1";
        if (!unAudited.equals(integralRefundOrder.getAuditStatus())) {
            throw new CustomException("\u6b64\u9000\u8d27\u8ba2\u5355\u672a\u5ba1\u6838\u901a\u8fc7\uff01");
        }
        integralRefundOrder.setRefundCompanyCode(refundOrder.getRefundCompanyCode());
        integralRefundOrder.setRefundShippingCompany(refundOrder.getRefundShippingCompany());
        integralRefundOrder.setRefundShippingNo(refundOrder.getRefundShippingNo());
        integralRefundOrder.setGmtModified(new Date());
        integralRefundOrder.setRefundStatus("0");
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)integralRefundOrder);
        Example orderExample = new Example(IntegralOrders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)integralRefundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)orderExample);
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        return integralRefundOrder;
    }

    public IntegralRefundOrderPO findByRefundNo(String refundNo) {
        IntegralRefundOrderPOExample integralRefundOrderPOExample = new IntegralRefundOrderPOExample();
        integralRefundOrderPOExample.createCriteria().andRefundNoEqualTo(refundNo).andValidEqualTo(Boolean.TRUE);
        List integralRefundOrderPOS = this.integralRefundOrderPOMapper.selectByExample(integralRefundOrderPOExample);
        if (CollectionUtils.isEmpty((Collection)integralRefundOrderPOS)) {
            return null;
        }
        return (IntegralRefundOrderPO)integralRefundOrderPOS.get(0);
    }

    public void refundMoney(IntegralRefundOrder integralRefundOrder) {
        Integer orderDetailId = integralRefundOrder.getOrderDetailId();
        IntegralOrdersDetails integralOrdersDetails = (IntegralOrdersDetails)this.integralOrdersDetailsMapper.selectByPrimaryKey((Object)orderDetailId);
        BigDecimal salePrice = integralOrdersDetails.getSalePrice();
        if (salePrice.compareTo(BigDecimal.ZERO) == 1) {
            log.info("\u79ef\u5206\u8ba2\u5355\u9000\u73b0\u91d1:{},{}", (Object)JSON.toJSONString((Object)integralOrdersDetails), (Object)JSON.toJSONString((Object)integralRefundOrder));
            this.refundProcessing(integralOrdersDetails, integralRefundOrder);
        }
    }

    public void refundMoney(IntegralOrders integralOrders) {
        Integer saleQuantity = integralOrders.getSaleQuantity();
        Example example = new Example(IntegralOrdersDetails.class);
        example.createCriteria().andEqualTo("orderNo", (Object)integralOrders.getOrderNo()).andEqualTo("valid", (Object)1);
        List integralOrdersDetailsList = this.integralOrdersDetailsMapper.selectByExample((Object)example);
        IntegralOrdersDetails integralOrdersDetails = (IntegralOrdersDetails)integralOrdersDetailsList.get(0);
        BigDecimal salePrice = integralOrdersDetails.getSalePrice();
        if (salePrice.compareTo(BigDecimal.ZERO) == 1) {
            log.info("\u79ef\u5206\u8ba2\u5355\u9000\u73b0\u91d12:{}", (Object)JSON.toJSONString((Object)integralOrders));
            IntegralRefundOrder integralRefundOrder = new IntegralRefundOrder();
            integralRefundOrder.setOrderNo(integralOrders.getOrderNo());
            integralRefundOrder.setRefundNo("RE_" + integralOrders.getOrderNo());
            integralRefundOrder.setAuditor(integralOrders.getDeliverAuditorMark());
            integralRefundOrder.setRefundReason("\u5ba1\u6838\u9000\u6b3e");
            this.refundProcessing(integralOrdersDetails, integralRefundOrder);
        }
    }

    private void refundProcessing(IntegralOrdersDetails integralOrdersDetails, IntegralRefundOrder integralRefundOrder) {
        Integer orderId = integralOrdersDetails.getOrderId();
        String orderNo = integralOrdersDetails.getOrderNo();
        IntegralOrdersPO ordersPO = this.integralOrdersPOMapper.selectByPrimaryKey(orderId);
        if (ordersPO == null) {
            log.error("\u79ef\u5206\u8ba2\u5355:{}\u4e0d\u5b58\u5728,\u9000\u6b3e\u5931\u8d25", (Object)orderNo);
        }
        Integer cashPayChannel = ordersPO.getCashPayChannel();
        if (IntegralCashPayChannelEnum.UNION_PAY.getCode().equals(cashPayChannel)) {
            this.refundProcessingUnion(integralOrdersDetails, integralRefundOrder, ordersPO);
        } else {
            this.refundProcessingWeChat(integralOrdersDetails, integralRefundOrder);
        }
    }

    private void refundProcessingUnion(IntegralOrdersDetails integralOrdersDetails, IntegralRefundOrder integralRefundOrder, IntegralOrdersPO ordersPO) {
        BigDecimal refundAmount = integralOrdersDetails.getSalePrice().multiply(BigDecimal.valueOf(integralOrdersDetails.getSaleQuantity().intValue()));
        Integer merchantId = integralOrdersDetails.getMerchantId();
        String orderNo = integralOrdersDetails.getOrderNo();
        String bizvaneTradeNo = ordersPO.getBizvaneTradeNo();
        String openId = ordersPO.getOpenId();
        ChannelConfigDto remotePayGatewayChannelUnion = this.payGatewayChannelService.getRemotePayGatewayChannelUnion(merchantId);
        String bizvaneMid = remotePayGatewayChannelUnion.getBizvaneMid();
        IntegralPayGatewayRefundOrderVO integralPayGatewayRefundOrderVO = new IntegralPayGatewayRefundOrderVO();
        integralPayGatewayRefundOrderVO.setBizvaneMid(bizvaneMid);
        integralPayGatewayRefundOrderVO.setOutTradeNo(orderNo);
        String cryptData = this.payGatewayPayService.cryptData(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayRefundOrderVO.setCryptData(cryptData);
        integralPayGatewayRefundOrderVO.setPayType(PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayRefundOrderVO.setBizvaneTradeNo(bizvaneTradeNo);
        integralPayGatewayRefundOrderVO.setOutRefundNo(integralRefundOrder.getRefundNo());
        integralPayGatewayRefundOrderVO.setTotalFee(Integer.valueOf(refundAmount.multiply(new BigDecimal("100")).intValue()));
        integralPayGatewayRefundOrderVO.setRefundFee(Integer.valueOf(refundAmount.multiply(new BigDecimal("100")).intValue()));
        integralPayGatewayRefundOrderVO.setBuyerUserId(openId);
        ResultBean refundOrder = this.payGatewayPayService.createRefundOrder(integralPayGatewayRefundOrderVO);
    }

    private void refundProcessingWeChat(IntegralOrdersDetails integralOrdersDetails, IntegralRefundOrder integralRefundOrder) {
        BigDecimal refundAmount = integralOrdersDetails.getSalePrice().multiply(BigDecimal.valueOf(integralOrdersDetails.getSaleQuantity().intValue()));
        Integer merchantId = integralOrdersDetails.getMerchantId();
        IntegralWechatMchPO wechatMchPO = this.integralWeChatMchService.findByBrandId(merchantId);
        log.info("wechatMchPO:{}", (Object)JSON.toJSONString((Object)wechatMchPO));
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(wechatMchPO.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(wechatMchPO.getMchKey());
        wechatMch.setMchNo(wechatMchPO.getMchNo());
        wechatMch.setP12(wechatMchPO.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        String auditor = integralRefundOrder.getAuditor();
        if (StringUtils.isEmpty((Object)auditor)) {
            auditor = "system";
        }
        log.info("RefundOrderServiceImpl#updateRefundStatus wepay:{}", (Object)JSON.toJSONString((Object)wepay));
        RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
        refundApplyRequest.setOutTradeNo(integralRefundOrder.getOrderNo());
        refundApplyRequest.setOutRefundNo(integralRefundOrder.getRefundNo());
        refundApplyRequest.setRefundFee(Integer.valueOf(refundAmount.multiply(new BigDecimal("100")).intValue()));
        refundApplyRequest.setOpUserId(auditor);
        refundApplyRequest.setRefundDesc(integralRefundOrder.getRefundReason());
        refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-integral-notify"));
        refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
        refundApplyRequest.setTotalFee(Integer.valueOf(refundAmount.multiply(new BigDecimal("100")).intValue()));
        log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
        try {
            RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
            log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
        }
        catch (WepayException e) {
            throw new CustomException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CustomException(e.getMessage());
        }
    }
}

