/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.bo.IntegralGoodsSearchBO;
import com.wmeimob.fastboot.bizvane.constants.admin.ImportConstant;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.goods.IntegralGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.enums.admin.IntegralGoodsCouponImportEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralGoodsSearchFormTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralGoodsStockChangeTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ExcelImportPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralConfigPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuLogMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuPOMapper;
import com.wmeimob.fastboot.bizvane.po.ExcelImportPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuLog;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuLogExample;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPOExample;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.admin.ExcelImportUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.goods.GoodsCouponImportRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.goods.IntrgralGoodsSkuLogVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ErrorExportMessageVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralGoodsServiceImpl
implements IntegralGoodsService {
    private static final Logger log = LoggerFactory.getLogger(IntegralGoodsServiceImpl.class);
    @Resource
    private ExcelImportPOMapper excelImportPOMapper;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private IntegralClassifyMapper integralClassifyMapper;
    @Autowired
    private IntegralSpecMapper integralSpecMapper;
    @Autowired
    private IntegralConfigMapper integralConfigMapper;
    @Resource
    private IntegralGoodsSkuPOMapper integralGoodsSkuPOMapper;
    @Resource
    private IntegralGoodsByDesignerPOMapper integralGoodsByDesignerPOMapper;
    @Resource
    private IntegralConfigPOMapper integralConfigPOMapper;
    @Resource
    private IntegralGoodsSkuLogMapper integralGoodsSkuLogMapper;
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;

    @Transactional
    public ResponseData addGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u65b0\u589e\u3002\u3002\u3002  \u5165\u53c2={}", (Object)JSON.toJSONString((Object)integralGoods));
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getUpperShelfTimeStr(), (String)"\u4e0a\u67b6\u65f6\u95f4");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        if (integralGoods.getExchangeStatus() == 1) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getExchangeCount(), (String)"\u6bcf\u4eba\u9650\u8d2d\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true);
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtCreate(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date uppTime = sdf.parse(integralGoods.getUpperShelfTimeStr());
            integralGoods.setUpperShelfTime(uppTime);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        List goodsSkuList = integralGoods.getSkus();
        this.integralGoodsMapper.insertSelective((Object)integralGoods);
        if (integralGoods.getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
            GoodsCouponImportRequestVO requestVO = new GoodsCouponImportRequestVO();
            requestVO.setFileUrl(integralGoods.getFileUrl());
            requestVO.setGoodsId(integralGoods.getId());
            requestVO.setMerchantId(integralGoods.getMerchantId());
            requestVO.setAccountCode(integralGoods.getAccountCode());
            requestVO.setPrice(integralGoods.getPrice());
            requestVO.setCashPrice(integralGoods.getCashPrice());
            try {
                return this.goodsCouponImport(requestVO);
            }
            catch (MallAdminException e) {
                throw new MallAdminException(e.getMessage());
            }
        }
        InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
        Date date = new Date();
        for (IntegralGoodsSku sku : goodsSkuList) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("skuNo", (Object)sku.getSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("merchantId", (Object)integralGoods.getMerchantId());
            IntegralGoodsSku goodsSku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
            log.info("sku\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)goodsSku));
            if (goodsSku != null) {
                throw new CustomException("skuNo:" + sku.getSkuNo() + "\u91cd\u590d");
            }
            if (CommonUtil.hasChinese((String)sku.getSkuNo())) {
                throw new CustomException("\u5546\u54c1sku\u7f16\u7801\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
            }
            sku.setGoodsId(integralGoods.getId());
            sku.setGmtCreate(new Date());
            sku.setMerchantId(integralGoods.getMerchantId());
            this.integralGoodsSkuMapper.insertSelective((Object)sku);
            IntegralGoodsSkuLog integralGoodsSkuLog = new IntegralGoodsSkuLog();
            integralGoodsSkuLog.setGmtCreate(date);
            integralGoodsSkuLog.setGoodsId(integralGoods.getId());
            integralGoodsSkuLog.setMerchantId(integralGoods.getMerchantId());
            integralGoodsSkuLog.setCreateStock(sku.getStock());
            integralGoodsSkuLog.setOldStock(Integer.valueOf(0));
            integralGoodsSkuLog.setUserCreate(integralGoods.getAccountCode());
            integralGoodsSkuLog.setGoodsSkuNo(sku.getSkuNo());
            integralGoodsSkuLog.setCreateType(IntegralGoodsStockChangeTypeEnum.ADD.getCode());
            integralGoodsSkuLog.setValid(Boolean.TRUE);
            this.integralGoodsSkuLogMapper.insert(integralGoodsSkuLog);
        }
        return ResponseUtil.getSuccessData((Object)integralGoods);
    }

    @Transactional
    public ResponseData goodsCouponImport(GoodsCouponImportRequestVO vo) throws MallAdminException {
        log.info("goodsCouponImport:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        try {
            if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)vo.getFileUrl())) {
                throw new MallAdminException("\u5bfc\u5165\u5730\u5740\u4e3a\u7a7a");
            }
            String fileUrl = vo.getFileUrl().replace("https", "http").replace("http", "https");
            URL url = new URL(fileUrl);
            InputStream is = url.openConnection().getInputStream();
            if (is == null) {
                throw new MallAdminException("\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
            }
            Workbook wb = null;
            try {
                wb = WorkbookFactory.create((InputStream)is);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
                throw new MallAdminException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            Sheet firstSheet = wb.getSheetAt(0);
            int lastRowNum = firstSheet.getLastRowNum();
            log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
            if (lastRowNum > 50001) {
                throw new MallAdminException("\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
            }
            ExportTempleHelp exportTempleHelp = IntegralGoodsCouponImportEnum.getExportTempleHelp();
            List notesList = exportTempleHelp.getNotesList();
            List fieldsList = exportTempleHelp.getFieldsList();
            Row firstSheetRow = firstSheet.getRow(0);
            for (int i = 0; i < notesList.size(); ++i) {
                String header = firstSheetRow.getCell(i).getStringCellValue();
                if (StringUtils.isEmpty((Object)header)) {
                    throw new MallAdminException("\u8868\u5934\u6709\u7a7a\u5217,\u8bf7\u91cd\u65b0\u67e5\u770b\u6587\u4ef6\u540e\u4e0a\u4f20");
                }
                if (header.trim().equals(notesList.get(i))) continue;
                throw new MallAdminException("\u8868\u5934\u4fe1\u606f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\u6587\u4ef6");
            }
            ExcelImportPOWithBLOBs excelImportPOWithBLOBs = new ExcelImportPOWithBLOBs();
            excelImportPOWithBLOBs.setMerchantId(vo.getMerchantId());
            excelImportPOWithBLOBs.setImportTime(new Date());
            excelImportPOWithBLOBs.setImportUrl(vo.getFileUrl());
            excelImportPOWithBLOBs.setImportType("integralGoodsCoupon");
            excelImportPOWithBLOBs.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION);
            excelImportPOWithBLOBs.setGmtCreate(new Date());
            excelImportPOWithBLOBs.setBeginTime(new Date());
            excelImportPOWithBLOBs.setAccountcode(vo.getAccountCode());
            log.info("\u63d2\u5165\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)excelImportPOWithBLOBs));
            this.excelImportPOMapper.insertSelective(excelImportPOWithBLOBs);
            ArrayList<IntegralGoodsSkuPO> successCouponImportVOList = new ArrayList<IntegralGoodsSkuPO>(50001);
            ArrayList<ErrorExportMessageVO> errorGoodsExportTempleVOList = new ArrayList<ErrorExportMessageVO>(50001);
            HashMap categoryData = new HashMap();
            ArrayList<String> couponCodes = new ArrayList<String>(lastRowNum);
            for (int i = 1; i <= lastRowNum; ++i) {
                ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
                Row row = firstSheet.getRow(i);
                if (row == null) continue;
                String couponCode = ExcelImportUtil.getValue((Cell)row.getCell(0)).trim();
                Date startDate = null;
                Date endDate = null;
                try {
                    int startTimeType = row.getCell(1).getCellType();
                    int endTimeType = row.getCell(2).getCellType();
                    if (0 == startTimeType) {
                        startDate = row.getCell(1).getDateCellValue();
                    } else if (1 == startTimeType) {
                        startDate = DateUtil.stringToDate((String)row.getCell(1).getStringCellValue(), (String)DateUtil.ymdhms);
                    }
                    if (0 == endTimeType) {
                        endDate = row.getCell(2).getDateCellValue();
                    } else if (1 == endTimeType) {
                        endDate = DateUtil.stringToDate((String)row.getCell(2).getStringCellValue(), (String)DateUtil.ymdhms);
                    }
                }
                catch (Exception e) {
                    throw new MallAdminException("\u65f6\u95f4\u8f6c\u6362\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                if (ExcelImportUtil.rowIsNull((String[])new String[]{couponCode})) {
                    log.info("poi\u8bc6\u522b\u5230\u6570\u636e\u4e3a\u7a7a,\u884c\u53f7:{}", (Object)i);
                    continue;
                }
                if (!CollectionUtils.isEmpty(couponCodes)) {
                    Boolean judge = Boolean.FALSE;
                    for (String code : couponCodes) {
                        if (!code.equals(couponCode)) continue;
                        ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"excel\u4e2d\u91cd\u590d\u6570\u636e", null, null, null);
                        errorGoodsExportTempleVOList.add(errorExportMessageVO);
                        judge = true;
                        break;
                    }
                    if (judge.booleanValue()) continue;
                }
                if (startDate == null) {
                    ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"\u8d77\u59cb\u65e5\u671f\u4e3a\u7a7a", null, null, null);
                    errorGoodsExportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (endDate == null) {
                    ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"\u8d77\u59cb\u65e5\u671f\u4e3a\u7a7a", null, null, null);
                    errorGoodsExportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (endDate.before(startDate)) {
                    ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u622a\u6b62\u65e5\u671f", null, null, null);
                    errorGoodsExportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (endDate.before(new Date())) {
                    ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"\u622a\u6b62\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f", null, null, null);
                    errorGoodsExportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                IntegralGoodsSkuPOExample checkSingle = new IntegralGoodsSkuPOExample();
                checkSingle.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(vo.getMerchantId()).andSkuNoEqualTo(couponCode);
                List integralGoodsSkuPOS = this.integralGoodsSkuPOMapper.selectByExample(checkSingle);
                if (!CollectionUtils.isEmpty((Collection)integralGoodsSkuPOS)) {
                    ExcelImportUtil.setErrorMessage((ErrorExportMessageVO)errorExportMessageVO, (Integer)i, (String)couponCode, (String)"\u5238\u53f7\u5df2\u7ecf\u5bfc\u5165", null, null, null);
                    errorGoodsExportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                IntegralGoodsSkuPO successSku = new IntegralGoodsSkuPO();
                successSku.setGmtCreate(new Date());
                successSku.setGmtModified(new Date());
                successSku.setGoodsId(vo.getGoodsId());
                successSku.setMerchantId(vo.getMerchantId());
                successSku.setSkuNo(couponCode);
                successSku.setStock(Integer.valueOf(1));
                successSku.setStartTime(startDate);
                successSku.setEndTime(endDate);
                successSku.setCashPrice(vo.getCashPrice());
                Integer price = vo.getPrice() == null ? 0 : vo.getPrice().intValue();
                successSku.setPrice(price);
                successCouponImportVOList.add(successSku);
                log.info("couponCodes:{}", (Object)JSON.toJSONString(couponCodes));
                log.info("checkParam\u5f53\u524d\u884c:{},\u6570\u636e:{}", (Object)i, (Object)JSON.toJSONString((Object)successSku));
                couponCodes.add(couponCode);
            }
            ExcelImportPOWithBLOBs param = new ExcelImportPOWithBLOBs();
            param.setFirstErrorInfo(JSON.toJSONString(errorGoodsExportTempleVOList));
            param.setGmtModified(new Date());
            param.setExcelImportId(excelImportPOWithBLOBs.getExcelImportId());
            log.info("successCouponImportVOList:{},errorGoodsExportTempleVOList:{}", (Object)JSON.toJSONString(successCouponImportVOList), (Object)JSON.toJSONString(errorGoodsExportTempleVOList));
            if (CollectionUtils.isEmpty(successCouponImportVOList)) {
                throw new MallAdminException("\u60a8\u5bfc\u5165\u7684excel\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e!" + JSON.toJSONString(errorGoodsExportTempleVOList));
            }
            this.excelImportPOMapper.updateByPrimaryKeySelective(param);
            log.info("\u66f4\u65b0\u4efb\u52a1:{}", (Object)JSON.toJSONString((Object)param));
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info("\u79ef\u5206\u8ba2\u5355\u5bfc\u5165\u5f00\u542f\u7ebf\u7a0b");
                try {
                    this.updateCoupon(successCouponImportVOList, excelImportPOWithBLOBs.getExcelImportId(), vo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("updateCoupon_exception:{}", (Object)e.getMessage());
                }
            });
            return ResponseUtil.getSuccessData(errorGoodsExportTempleVOList, (String)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MallAdminException(e.getMessage());
        }
    }

    @Transactional
    public void updateCoupon(List<IntegralGoodsSkuPO> updatePos, Integer excelImportId, GoodsCouponImportRequestVO vo) {
        Date date = new Date();
        log.info("\u5f02\u6b65\u66f4\u65b0\u5f00\u59cb");
        IntegralGoodsSkuPOExample existsPoExample = new IntegralGoodsSkuPOExample();
        existsPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(vo.getGoodsId());
        List existsPOS = this.integralGoodsSkuPOMapper.selectByExample(existsPoExample);
        if (CollectionUtils.isEmpty((Collection)existsPOS)) {
            log.info("\u5168\u90e8\u63d2\u5165\u6570\u636e:{}", (Object)JSON.toJSONString(updatePos));
            this.integralGoodsByDesignerPOMapper.batchInsertCouponSku(updatePos);
            updatePos.stream().forEach(e -> {
                IntegralGoodsSkuLog integralGoodsSkuLog = new IntegralGoodsSkuLog();
                integralGoodsSkuLog.setGmtCreate(date);
                integralGoodsSkuLog.setGoodsId(e.getGoodsId());
                integralGoodsSkuLog.setMerchantId(e.getMerchantId());
                integralGoodsSkuLog.setCreateStock(e.getStock());
                integralGoodsSkuLog.setOldStock(Integer.valueOf(0));
                integralGoodsSkuLog.setGoodsSkuNo(e.getSkuNo());
                integralGoodsSkuLog.setCreateType(IntegralGoodsStockChangeTypeEnum.ADD.getCode());
                integralGoodsSkuLog.setValid(Boolean.TRUE);
                this.integralGoodsSkuLogMapper.insert(integralGoodsSkuLog);
            });
        } else {
            log.info("\u6709\u4ea4\u96c6\uff0c\u9700\u8981\u6570\u636e\u5904\u7406");
            Iterator<IntegralGoodsSkuPO> updatePosIterator = updatePos.iterator();
            while (updatePosIterator.hasNext()) {
                IntegralGoodsSkuPO updatePo = updatePosIterator.next();
                for (IntegralGoodsSkuPO existsPO : existsPOS) {
                    if (!existsPO.getSkuNo().equals(updatePo.getSkuNo())) continue;
                    updatePosIterator.remove();
                }
            }
            log.info("\u5904\u7406\u540e\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(updatePos));
            this.integralGoodsByDesignerPOMapper.batchInsertCouponSku(updatePos);
        }
        ExcelImportPOWithBLOBs param = new ExcelImportPOWithBLOBs();
        param.setGmtModified(new Date());
        param.setExcelImportId(excelImportId);
        param.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_COMPLETED);
        this.excelImportPOMapper.updateByPrimaryKeySelective(param);
    }

    @Transactional
    public ResponseData updateGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u4fee\u6539\u3002\u3002\u3002 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)integralGoods));
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getUpperShelfTimeStr(), (String)"\u4e0a\u67b6\u65f6\u95f4");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        if (integralGoods.getExchangeStatus() == 1) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getExchangeCount(), (String)"\u6bcf\u4eba\u9650\u8d2d\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true).andNotEqualTo("id", (Object)integralGoods.getId());
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtModified(new Date());
        if (integralGoods.getSort() == null || com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getSort())) {
            integralGoods.setSort(Integer.valueOf(0));
        }
        this.integralGoodsMapper.updateByPrimaryKeySelective((Object)integralGoods);
        if (integralGoods.getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
            GoodsCouponImportRequestVO requestVO = new GoodsCouponImportRequestVO();
            requestVO.setFileUrl(integralGoods.getFileUrl());
            requestVO.setGoodsId(integralGoods.getId());
            requestVO.setMerchantId(integralGoods.getMerchantId());
            requestVO.setAccountCode(integralGoods.getAccountCode());
            requestVO.setPrice(integralGoods.getPrice());
            requestVO.setCashPrice(integralGoods.getCashPrice());
            if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getFileUrl())) {
                try {
                    return this.goodsCouponImport(requestVO);
                }
                catch (MallAdminException e) {
                    throw new MallAdminException(e.getMessage());
                }
            }
        } else {
            InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
            this.integralGoodsSkuMapper.deleteSkuByGoodId(integralGoods.getId());
            List goodsSkuList = integralGoods.getSkus();
            Date date = new Date();
            for (IntegralGoodsSku sku : goodsSkuList) {
                Example skuExample = new Example(IntegralGoodsSku.class);
                skuExample.createCriteria().andEqualTo("skuNo", (Object)sku.getSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("merchantId", (Object)integralGoods.getMerchantId());
                IntegralGoodsSku goodsSku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
                log.info("sku\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)goodsSku));
                if (goodsSku != null) {
                    throw new CustomException("skuNo:[" + sku.getSkuNo() + "]\u91cd\u590d");
                }
                sku.setGmtCreate(date);
                sku.setGoodsId(integralGoods.getId());
                sku.setHistoryStock(sku.getStock());
                if (sku.getIsChange().booleanValue()) {
                    IntegralGoodsSkuLog integralGoodsSkuLog = new IntegralGoodsSkuLog();
                    integralGoodsSkuLog.setGmtCreate(date);
                    integralGoodsSkuLog.setGoodsId(integralGoods.getId());
                    integralGoodsSkuLog.setMerchantId(integralGoods.getMerchantId());
                    integralGoodsSkuLog.setCreateStock(Integer.valueOf(sku.getStock() - sku.getOldStock()));
                    integralGoodsSkuLog.setOldStock(sku.getOldStock());
                    integralGoodsSkuLog.setGoodsSkuNo(sku.getSkuNo());
                    integralGoodsSkuLog.setUserCreate(integralGoods.getAccountCode());
                    integralGoodsSkuLog.setCreateType(IntegralGoodsStockChangeTypeEnum.CHANGE.getCode());
                    integralGoodsSkuLog.setValid(Boolean.TRUE);
                    this.integralGoodsSkuLogMapper.insert(integralGoodsSkuLog);
                }
                this.integralGoodsSkuMapper.insertSelective((Object)sku);
            }
        }
        return ResponseUtil.getSuccessData((Object)integralGoods);
    }

    public List<IntegralGoods> getGoods(IntegralGoodsSearchBO integralGoodsSearchBO) {
        List list;
        log.info("IntegralGoodsServiceImpl#getGoods#integralGoodsSearchBO:{}", (Object)JSON.toJSONString((Object)integralGoodsSearchBO));
        IntegralGoods integralGoods = integralGoodsSearchBO.getIntegralGoods();
        InputValidator.checkEmpty((Object)integralGoodsSearchBO.getMerchantId(), (String)"\u54c1\u724cid");
        String desc = "desc";
        String pc = IntegralGoodsSearchFormTypeEnum.pc.getType();
        Example example = new Example(IntegralGoods.class);
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoodsSearchBO.getColumn()) && !com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoodsSearchBO.getOrderBy())) {
            if (desc.equals(integralGoodsSearchBO.getOrderBy())) {
                example.orderBy(integralGoodsSearchBO.getColumn()).desc();
            } else {
                example.orderBy(integralGoodsSearchBO.getColumn()).asc();
            }
        } else {
            example.orderBy("sort").desc();
            example.orderBy("gmtCreate").desc();
        }
        Example.Criteria criteria = example.createCriteria();
        if (pc.equals(integralGoodsSearchBO.getFromType())) {
            criteria.andEqualTo("merchantId", (Object)integralGoodsSearchBO.getMerchantId()).andEqualTo("valid", (Object)Boolean.TRUE);
        } else {
            criteria.andEqualTo("merchantId", (Object)integralGoodsSearchBO.getMerchantId()).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        }
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoodsSearchBO.getSearchValue())) {
            example.and().andLike("goodsNo", "%" + integralGoodsSearchBO.getSearchValue() + "%").orLike("goodsName", "%" + integralGoodsSearchBO.getSearchValue() + "%");
        }
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getShelf())) {
            criteria.andEqualTo("shelf", (Object)integralGoods.getShelf());
        }
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getClassifyId())) {
            example.and().andLike("classifyId", "%" + integralGoods.getClassifyId() + "%");
        }
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getHot())) {
            criteria.andEqualTo("hot", (Object)integralGoods.getHot());
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.integralGoodsMapper.selectByExample((Object)example)))) {
            this.getIntegralGoodsTotalStock(list, integralGoodsSearchBO);
        }
        return list;
    }

    private void getIntegralGoodsTotalStock(List<IntegralGoods> list, IntegralGoodsSearchBO integralGoodsSearchBO) {
        if (!CollectionUtils.isEmpty(list)) {
            ResponseData integralConfigPoByMerchantId = this.getIntegralConfigPoByMerchantId(integralGoodsSearchBO.getMerchantId());
            if (SysResponseEnum.FAILED.getCode() == integralConfigPoByMerchantId.getCode()) {
                throw new RuntimeException(integralConfigPoByMerchantId.getMessage());
            }
            IntegralConfigPOWithBLOBs data = (IntegralConfigPOWithBLOBs)integralConfigPoByMerchantId.getData();
            Iterator<IntegralGoods> iterator = list.iterator();
            while (iterator.hasNext()) {
                IntegralGoods goods = iterator.next();
                if (data.getHiddenGoods().booleanValue() && IntegralGoodsSearchFormTypeEnum.wx.getType().equals(integralGoodsSearchBO.getFromType()) && this.checkMember(goods, integralGoodsSearchBO.getStoreId(), integralGoodsSearchBO.getLevelName())) {
                    iterator.remove();
                }
                this.getIntegralGoodTotalStock(goods);
            }
        }
    }

    private void getIntegralGoodTotalStock(IntegralGoods goods) {
        List skuList;
        IntegralGoodsSkuPOExample integralGoodsSkuPOExample = new IntegralGoodsSkuPOExample();
        IntegralGoodsSkuPOExample.Criteria skuCriteria = integralGoodsSkuPOExample.createCriteria();
        skuCriteria.andGoodsIdEqualTo(goods.getId()).andValidEqualTo(Boolean.TRUE).andEnabledEqualTo(Boolean.TRUE);
        if (IntegralGoodsTypeEnum.COUPON.getCode().equals(goods.getGoodsType())) {
            Date nowTime = new Date();
            skuCriteria.andStockGreaterThan(Integer.valueOf(0)).andEndTimeGreaterThanOrEqualTo(nowTime);
        }
        if (!CollectionUtils.isEmpty((Collection)(skuList = this.integralGoodsSkuPOMapper.selectByExample(integralGoodsSkuPOExample)))) {
            int stock = 0;
            int historyStock = 0;
            for (IntegralGoodsSkuPO sku : skuList) {
                stock += sku.getStock().intValue();
                if (!Objects.nonNull(sku.getHistoryStock())) continue;
                historyStock += sku.getHistoryStock().intValue();
            }
            goods.setTotalStock(Integer.valueOf(stock));
            goods.setHistoryStock(Integer.valueOf(historyStock));
        } else {
            goods.setTotalStock(Integer.valueOf(0));
            goods.setHistoryStock(Integer.valueOf(0));
        }
    }

    public IntegralGoods getGoodsById(Integer id, String type) {
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002===\u4f20\u5165\u7684id:{}", (Object)id);
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        String pc = IntegralGoodsSearchFormTypeEnum.pc.getType();
        String wx = IntegralGoodsSearchFormTypeEnum.wx.getType();
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        Integer merchantId = integralGoods.getMerchantId();
        log.info("\u67e5\u8be2\u5230\u7684\u5546\u54c1\uff1a{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        if (integralGoods != null) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            if (pc.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            } else if (wx.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("enabled", (Object)Boolean.TRUE);
            }
            List skuList = new ArrayList();
            log.info("skuList:{}", (Object)JSON.toJSONString(skuList));
            if (integralGoods.getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
                this.getIntegralGoodTotalStock(integralGoods);
            } else {
                skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
                Integer totalStock = 0;
                if (skuList.size() > 0) {
                    for (IntegralGoodsSku sku : skuList) {
                        totalStock = totalStock + sku.getStock();
                        ArrayList<GoodSkuSpecDTO> list = new ArrayList<GoodSkuSpecDTO>();
                        List specMainList = this.integralSpecMapper.getPidList(sku.getSpecIds());
                        for (IntegralSpec mainSpec : specMainList) {
                            GoodSkuSpecDTO goodSkuSpecDTO = new GoodSkuSpecDTO();
                            IntegralSpec specMain = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)mainSpec.getPid());
                            goodSkuSpecDTO.setMainSpec(specMain);
                            list.add(goodSkuSpecDTO);
                        }
                        for (GoodSkuSpecDTO dto : list) {
                            ArrayList<IntegralSpec> child = new ArrayList<IntegralSpec>();
                            Example specExample = new Example(IntegralSpec.class);
                            specExample.createCriteria().andCondition("id in (" + sku.getSpecIds() + ")");
                            List specList = this.integralSpecMapper.selectByExample((Object)specExample);
                            for (IntegralSpec childSpec : specList) {
                                if (!childSpec.getPid().equals(dto.getMainSpec().getId())) continue;
                                child.add(childSpec);
                            }
                            dto.setChilds(child);
                        }
                        sku.setGoodSkuSpecDetails(list);
                    }
                }
                integralGoods.setTotalStock(totalStock);
            }
            integralGoods.setSkus(skuList);
            ArrayList<IntegralClassify> integralClassifyList = new ArrayList<IntegralClassify>();
            String classifyStr = integralGoods.getClassifyId();
            if (classifyStr.contains(",")) {
                String[] classifyArray;
                for (String classify : classifyArray = classifyStr.split(",")) {
                    IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classify);
                    if (integralClassify == null) continue;
                    integralClassifyList.add(integralClassify);
                }
            } else {
                IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classifyStr);
                if (integralClassify != null) {
                    integralClassifyList.add(integralClassify);
                }
            }
            integralGoods.setClassifyList(integralClassifyList);
            if (integralGoods.getUpperShelfTime() != null) {
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(integralGoods.getUpperShelfTime());
                integralGoods.setUpperShelfTimeStr(time);
            }
        }
        Example example1 = new Example(IntegralConfig.class);
        example1.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List integralConfigs = this.integralConfigMapper.selectByExample((Object)example1);
        if (CollectionUtils.isEmpty((Collection)integralConfigs)) {
            log.info("\u672a\u521d\u59cb\u5316\u79ef\u5206\u5546\u57ce\u914d\u7f6e");
            return null;
        }
        Integer isWholeStore = ((IntegralConfig)integralConfigs.get(0)).getIsWholeStore();
        log.info("\u662f\u5426\u67e5\u8be2\u5168\u90e8\u95e8\u5e97\uff1a{}", (Object)isWholeStore);
        integralGoods.setIsWholeStore(isWholeStore);
        log.info("\u5546\u54c1\u8be6\u60c5\u8fd4\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        return integralGoods;
    }

    public void deleteGoods(Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods != null) {
            if (Boolean.TRUE.equals(integralGoods.getShelf())) {
                throw new CustomException("\u4e0a\u67b6\u5546\u54c1\u4e0d\u80fd\u5220\u9664!");
            }
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            IntegralGoodsSku sku = new IntegralGoodsSku();
            sku.setValid(Boolean.FALSE);
            int skuDeleteNum = this.integralGoodsSkuMapper.updateByExampleSelective((Object)sku, (Object)skuExample);
            log.info("skuDeleteNum:{}", (Object)skuDeleteNum);
            integralGoods.setValid(Boolean.FALSE);
            int goodsDeleteNum = this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
            log.info("goodsDeleteNum:{}", (Object)goodsDeleteNum);
        }
    }

    public List<IntegralGoods> getLowerGoods() {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("shelf", (Object)Boolean.FALSE).andEqualTo("valid", (Object)Boolean.TRUE).andIsNotNull("upperShelfTime");
        List goods = this.integralGoodsMapper.selectByExample((Object)example);
        return goods;
    }

    public List<IntegralGoods> getHotGoods(IntegralGoodsSearchBO integralGoodsSearchBO) {
        log.info("IntegralGoodsServiceImpl#getHotGoods:{}", (Object)JSON.toJSONString((Object)integralGoodsSearchBO));
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)integralGoodsSearchBO.getMerchantId()).andEqualTo("valid", (Object)true).andEqualTo("hot", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        example.setOrderByClause("sort desc");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        this.getIntegralGoodsTotalStock(list, integralGoodsSearchBO);
        return list;
    }

    public List<IntegralGoods> getGoodsByClassifyId(IntegralGoodsSearchBO integralGoodsSearchBO) {
        String desc = "desc";
        Example example = new Example(IntegralGoods.class);
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoodsSearchBO.getColumn()) && !com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoodsSearchBO.getOrderBy())) {
            if (desc.equals(integralGoodsSearchBO.getOrderBy())) {
                example.orderBy(integralGoodsSearchBO.getColumn()).desc();
            } else {
                example.orderBy(integralGoodsSearchBO.getColumn()).asc();
            }
        }
        example.createCriteria().andEqualTo("merchantId", (Object)integralGoodsSearchBO.getMerchantId()).andEqualTo("valid", (Object)true).andEqualTo("shelf", (Object)Boolean.TRUE).andCondition(" FIND_IN_SET(" + integralGoodsSearchBO.getClassifyId() + ",classify_id)");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        this.getIntegralGoodsTotalStock(list, integralGoodsSearchBO);
        return list;
    }

    public Integer getSkuStock(Integer skuId) {
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectByPrimaryKey((Object)skuId);
        if (sku == null) {
            return 0;
        }
        return sku.getStock();
    }

    public int upperOrlower(Integer goodId, Boolean shelf) {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)goodId);
        IntegralGoods goods = new IntegralGoods();
        goods.setShelf(shelf);
        if (Boolean.TRUE.equals(shelf)) {
            goods.setUpperShelfTime(new Date());
        } else {
            goods.setLowerShelfTime(new Date());
        }
        return this.integralGoodsMapper.updateByExampleSelective((Object)goods, (Object)example);
    }

    public PageInfo getStockLog(IntrgralGoodsSkuLogVO intrgralGoodsSkuLogVO) {
        PageHelper.startPage((int)intrgralGoodsSkuLogVO.getPage(), (int)intrgralGoodsSkuLogVO.getPageSize());
        IntegralGoodsSkuLogExample integralGoodsSkuLogExample = new IntegralGoodsSkuLogExample();
        integralGoodsSkuLogExample.createCriteria().andGoodsIdEqualTo(intrgralGoodsSkuLogVO.getGoodId());
        integralGoodsSkuLogExample.setOrderByClause("gmt_create desc");
        List integralGoodsSkuLogList = this.integralGoodsSkuLogMapper.selectByExample(integralGoodsSkuLogExample);
        PageInfo pageInfo = new PageInfo(integralGoodsSkuLogList);
        log.info("\u79ef\u5206\u5546\u54c1\u5e93\u5b58\u6d41\u6c34\uff1a{}", (Object)JSON.toJSONString((Object)integralGoodsSkuLogList));
        return pageInfo;
    }

    private ResponseData<IntegralConfigPOWithBLOBs> getIntegralConfigPoByMerchantId(Integer merchangId) {
        log.info("IntegralGoodsServiceImpl#getIntegralConfigPo#merchangId:{}", (Object)merchangId);
        IntegralConfigPOExample integralConfigPOExample = new IntegralConfigPOExample();
        integralConfigPOExample.createCriteria().andMerchantIdEqualTo(merchangId).andValidEqualTo(Boolean.TRUE);
        List integralConfigPOWithBLOBs = this.integralConfigPOMapper.selectByExampleWithBLOBs(integralConfigPOExample);
        if (CollectionUtils.isEmpty((Collection)integralConfigPOWithBLOBs)) {
            return ResponseUtil.getFailedMsg((String)"\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a");
        }
        if (integralConfigPOWithBLOBs.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u591a\u4e2a\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u6570\u636e");
        }
        return ResponseUtil.getSuccessData(integralConfigPOWithBLOBs.get(0));
    }

    public boolean checkMember(IntegralGoods integralGoods, String storeId, String levelName) {
        log.info("WxIntegralOrdersController#checkMember integralGoods:{}", (Object)JSON.toJSONString((Object)integralGoods));
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)storeId) && com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)levelName)) {
            log.info("\u7528\u6237\u6240\u5c5e\u5e97\u94fa\u548c\u7528\u6237\u7b49\u7ea7\u4e3a\u7a7a");
            return false;
        }
        if (integralGoods != null && integralGoods.getMemberScope() != 0) {
            String storeWhiteList;
            Object list;
            List list1;
            log.info("\u8be5\u5546\u54c1\u9700\u8981\u6821\u9a8c\u662f\u5426\u9002\u7528\u7b49\u7ea7\u548c\u5e97\u94fa");
            if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getStoreWhiteList()) && !CollectionUtils.isEmpty((Collection)(list1 = (List)(list = new Gson().fromJson(storeWhiteList = integralGoods.getStoreWhiteList(), new /* Unavailable Anonymous Inner Class!! */.getType())))) && list1.stream().noneMatch(e -> storeId.equals(e.getSysStoreId()))) {
                log.info("\u60a8\u76ee\u524d\u7684\u5f00\u5361\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u95e8\u5e97\u8303\u56f4");
                return true;
            }
            if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralGoods.getMemberLevelNames())) {
                if (Arrays.stream(integralGoods.getMemberLevelNames().split(",")).noneMatch(levelName::equals)) {
                    log.info("\u60a8\u76ee\u524d\u7684\u5361\u7b49\u7ea7\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u7b49\u7ea7\u8303\u56f4");
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

