/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.GoodsStockChangeResponseDTO;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsSkuDetailServiceImpl
implements GoodsSkuDetailService {
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;

    public List<GoodsSkuDetail> update(List<GoodsSkuDetail> goodsSkuDetailList, Integer goodsId) {
        Date date = new Date();
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("goodsId", (Object)goodsId);
        this.goodsSkuDetailMapper.deleteByExample((Object)example);
        this.goodsSkuDetailMapper.insertList(goodsSkuDetailList);
        return goodsSkuDetailList;
    }

    public List<GoodsSpecRelation> relation(List<GoodsSpecRelation> goodsSpecRelations, Integer goodsId) {
        Example example = new Example(GoodsSpecRelation.class);
        example.createCriteria().andEqualTo("goodsId", (Object)goodsId);
        this.goodsSpecRelationMapper.deleteByExample((Object)example);
        this.goodsSpecRelationMapper.insertList(goodsSpecRelations);
        return goodsSpecRelations;
    }

    public List<GoodsSkuDetail> findByGoodsId(Integer id) {
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("isDel", (Object)false);
        return this.goodsSkuDetailMapper.selectByExample((Object)example);
    }

    public List<GoodsStockChangeResponseDTO> inventoryReduction(List<GoodsSkuDetail> skuInfo) {
        ArrayList<GoodsStockChangeResponseDTO> responseDTOList = new ArrayList<GoodsStockChangeResponseDTO>();
        for (GoodsSkuDetail skuDetail : skuInfo) {
            int result = this.goodsSkuDetailMapper.inventoryReduction(skuDetail);
            if (result != 0) continue;
            responseDTOList.add(GoodsStockChangeResponseDTO.builder().goodsId(skuDetail.getGoodsId()).goodsName(skuDetail.getGoodsName()).skuNo(skuDetail.getSkuNo()).count(skuDetail.getStock()).failReason("\u5e93\u5b58\u4e0d\u8db3").build());
        }
        return responseDTOList;
    }
}

