/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityGift;
import com.wmeimob.fastboot.bizvane.entity.ActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.ActivityStipulation;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityStipulationMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityGiftPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRuleCombinationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRuleGiftPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityRulePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityStipulationPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRuleCombinationPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRuleGiftPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityRulePO;
import com.wmeimob.fastboot.bizvane.po.ActivityRulePOExample;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityStipulationMapper activityStipulationMapper;
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private ActivityGiftMapper activityGiftMapper;
    @Autowired
    private ActivityRuleCombinationPOMapper activityRuleCombinationPOMapper;
    @Autowired
    private ActivityRuleGiftPOMapper activityRuleGiftPOMapper;
    @Autowired
    private ActivityRulePOMapper activityRulePOMapper;
    @Autowired
    private ActivityGoodsPOMapper activityGoodsPOMapper;
    @Autowired
    private ActivityPOMapper activityPOMapper;
    @Autowired
    private ActivityStipulationPOMapper activityStipulationPOMapper;
    @Autowired
    private ActivityGiftPOMapper activityGiftPOMapper;

    public Activity add(Activity activity) {
        InputValidator.checkLengthRange((Object)activity.getName(), (int)1, (int)50, (String)"\u6d3b\u52a8\u540d\u79f0");
        InputValidator.checkEmpty((Object)activity.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        InputValidator.checkEmpty((Object)activity.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        InputValidator.checkDateTime((Date)activity.getBeginDate(), (Date)activity.getEndDate());
        Date date = new Date();
        activity.setGmtCreate(date);
        this.activityMapper.insertSelective((Object)activity);
        if (activity.getType() == 1) {
            List stipulationList = activity.getStipulationList();
            if (stipulationList == null || stipulationList.size() < 1) {
                throw new MallAdminException("\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (Object stipulation : stipulationList) {
                InputValidator.checkNumber((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)stipulation.getDiscount(), (String)"\u6298\u6263\u8303\u56f4");
                stipulation.setActivityId(activity.getId());
                stipulation.setGmtCreate(date);
            }
            this.activityStipulationMapper.insertList(stipulationList);
            List goodsList = activity.getGoodsList();
            if (goodsList == null || goodsList.size() < 1) {
                throw new MallAdminException("\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            for (ActivityGoods goods : goodsList) {
                goods.setMerchantId(activity.getMerchantId());
                goods.setBeginDate(activity.getBeginDate());
                goods.setEndDate(activity.getEndDate());
                Integer count = this.activityGoodsMapper.selectCountGoodsByActivity(goods);
                if (count > 0) {
                    throw new MallAdminException("\u5546\u54c1\uff1a" + goods.getGoodsName() + "\u5df2\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8");
                }
                goods.setActivityId(activity.getId());
                goods.setGmtCreate(date);
            }
            this.activityGoodsMapper.insertList(goodsList);
        } else {
            List activityGiftList = activity.getActivityGiftList();
            if (activityGiftList == null || activityGiftList.size() < 1) {
                throw new MallAdminException("\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            for (ActivityGift goods : activityGiftList) {
                goods.setActivityId(activity.getId());
                goods.setGmtCreate(date);
            }
            this.activityGiftMapper.insertList(activityGiftList);
        }
        return activity;
    }

    @Transactional
    public int delete(Integer activityId) {
        log.info("ActivityServiceImpl#delete activityId:{}", (Object)JSON.toJSONString((Object)activityId));
        this.activityPOMapper.deleteByPrimaryKey(activityId);
        ActivityGoodsPOExample activityGoodsPOExample = new ActivityGoodsPOExample();
        activityGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityId);
        int i = this.activityGoodsPOMapper.deleteByExample(activityGoodsPOExample);
        ActivityRulePOExample activityRulePOExample = new ActivityRulePOExample();
        activityRulePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActivityIdEqualTo(activityId);
        List rules = this.activityRulePOMapper.selectByExample(activityRulePOExample);
        if (rules.size() > 0) {
            for (ActivityRulePO rule1 : rules) {
                if (rule1.getId() == null) continue;
                ActivityRuleCombinationPOExample activityRuleCombinationPOExample = new ActivityRuleCombinationPOExample();
                activityRuleCombinationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule1.getId());
                this.activityRuleCombinationPOMapper.deleteByExample(activityRuleCombinationPOExample);
                ActivityRuleGiftPOExample activityRuleGiftPOExample = new ActivityRuleGiftPOExample();
                activityRuleGiftPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andRuleIdEqualTo(rule1.getId());
                this.activityRuleGiftPOMapper.deleteByExample(activityRuleGiftPOExample);
            }
        }
        this.activityRulePOMapper.deleteByExample(activityRulePOExample);
        return i;
    }

    public int update(Activity activity) {
        block12: {
            Date date;
            block11: {
                List goodsList;
                InputValidator.checkLengthRange((Object)activity.getName(), (int)1, (int)50, (String)"\u6d3b\u52a8\u540d\u79f0");
                InputValidator.checkEmpty((Object)activity.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
                InputValidator.checkEmpty((Object)activity.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
                InputValidator.checkDateTime((Date)activity.getBeginDate(), (Date)activity.getEndDate());
                date = new Date();
                activity.setGmtModified(date);
                if (activity.getType() != 1) break block11;
                List stipulationList = activity.getStipulationList();
                if (stipulationList != null) {
                    for (ActivityStipulation stipulation : stipulationList) {
                        stipulation.setActivityId(activity.getId());
                        stipulation.setGmtCreate(date);
                        if (stipulation.getId() == null) {
                            stipulation.setActivityId(activity.getId());
                            stipulation.setGmtCreate(date);
                            this.activityStipulationMapper.insertSelective((Object)stipulation);
                            continue;
                        }
                        if (stipulation.getIsDelete().booleanValue()) {
                            this.activityStipulationPOMapper.deleteByPrimaryKey(stipulation.getId());
                            continue;
                        }
                        this.activityStipulationMapper.updateByPrimaryKeySelective((Object)stipulation);
                    }
                }
                if ((goodsList = activity.getGoodsList()) == null) break block12;
                for (ActivityGoods goods : goodsList) {
                    goods.setActivityId(activity.getId());
                    goods.setGmtCreate(date);
                    if (goods.getId() == null) {
                        goods.setMerchantId(activity.getMerchantId());
                        goods.setBeginDate(activity.getBeginDate());
                        goods.setEndDate(activity.getEndDate());
                        Integer count = this.activityGoodsMapper.selectCountGoodsByActivity(goods);
                        if (count > 0) {
                            throw new MallAdminException("\u5546\u54c1\uff1a" + goods.getGoodsName() + "\u5df2\u53c2\u4e0e\u5176\u4ed6\u5df2\u542f\u7528\u7684\u6d3b\u52a8");
                        }
                        goods.setActivityId(activity.getId());
                        goods.setGmtCreate(date);
                        this.activityGoodsMapper.insertSelective((Object)goods);
                        continue;
                    }
                    if (!goods.getIsDelete().booleanValue()) continue;
                    this.activityGoodsPOMapper.deleteByPrimaryKey(goods.getId());
                }
                break block12;
            }
            List goodsList = activity.getActivityGiftList();
            if (goodsList != null) {
                for (ActivityGift activityGift : goodsList) {
                    activityGift.setActivityId(activity.getId());
                    activityGift.setGmtCreate(date);
                    if (activityGift.getId() == null) {
                        activityGift.setActivityId(activity.getId());
                        activityGift.setGmtCreate(date);
                        this.activityGiftMapper.insertSelective((Object)activityGift);
                        continue;
                    }
                    if (activityGift.getIsDelete().booleanValue()) {
                        this.activityGiftPOMapper.deleteByPrimaryKey(activityGift.getId());
                        continue;
                    }
                    this.activityGiftMapper.updateByPrimaryKey((Object)activityGift);
                }
            }
        }
        return this.activityMapper.updateByPrimaryKeySelective((Object)activity);
    }

    public List<Activity> findByCondition(Activity activity) {
        return this.activityMapper.selectList(activity);
    }

    public Activity findById(Integer id) {
        return this.activityMapper.findById(id);
    }

    public int deleteGoodsById(Integer id) {
        return this.activityGoodsPOMapper.deleteByPrimaryKey(id);
    }

    public int deleteStipulationById(Integer id) {
        return this.activityStipulationPOMapper.deleteByPrimaryKey(id);
    }

    public void deleteActivityGoods(Integer id) {
        ActivityGoodsPOExample activityGoodsPOExample = new ActivityGoodsPOExample();
        activityGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(id);
        this.activityGoodsPOMapper.deleteByExample(activityGoodsPOExample);
    }
}

