/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.navigation;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.navigation.NavigationButtonService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.navigation.NavigationConfigUpdateChoseRequestVO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"navigationButton"})
public class NavigationButtonController {
    private static final Logger log = LoggerFactory.getLogger(NavigationButtonController.class);
    @Autowired
    private NavigationButtonService navigationButtonService;

    @PostMapping(value={"searchNavigationListNoPage"})
    public ResponseData searchNavigationListNoPage(@RequestHeader Integer merchantId) {
        log.info("NavigationController#searchNavigationListNoPage:{}", (Object)merchantId);
        return this.navigationButtonService.searchNavigationListNoPage(merchantId);
    }

    @PostMapping(value={"updateNavigationChose"})
    public ResponseData updateNavigationChose(@RequestHeader Integer merchantId, @RequestBody NavigationConfigUpdateChoseRequestVO vo) {
        log.info("NavigationController#updateNavigationChose merchantId:{} vo:{}", (Object)merchantId, (Object)JSON.toJSONString((Object)vo));
        vo.setMerchantId(merchantId);
        if (CollectionUtils.isEmpty((Collection)vo.getAllOption())) {
            return ResponseUtil.getFailedMsg((String)"\u914d\u7f6e\u5217\u8868\u4e3a\u7a7a");
        }
        return this.navigationButtonService.updateNavigationChose(vo);
    }
}

