/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.goods.IntegralGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.idempotent.Idempotent;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderJobService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralPayService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.fegin.IntegralApiService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralCouponPayVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.IntegralOrderFeightVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.GetPushIntegralOrderToErpRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/orders"})
public class WxIntegralOrdersController {
    private static final Logger log = LoggerFactory.getLogger(WxIntegralOrdersController.class);
    @Autowired
    private IntegralGoodsService integralGoodsService;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsPOMapper integralGoodsPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private IntegralApiService integralApiService;
    @Autowired
    private IntegralPayService integralPayService;
    @Autowired
    private IntegralOrderJobService integralOrderJobService;
    @Autowired
    private ErpOrderApiService erpOrderApiService;

    @Idempotent(value="/confirmGoods", expireMillis=5000L)
    @RequestMapping(value={"/confirmGoods"}, method={RequestMethod.POST})
    public Map<String, Object> confirmGoods(@RequestBody IntegralOrders integralOrders) {
        log.info("\u786e\u8ba4\u4e0b\u5355...");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
            InputValidator.checkEmpty((Object)integralOrders.getMemberCode(), (String)"\u4f1a\u5458code");
            InputValidator.checkEmpty((Object)integralOrders.getMemberCardNo(), (String)"\u4f1a\u5458\u5361\u53f7");
            InputValidator.checkEmpty((Object)integralOrders.getMemberPhone(), (String)"\u4f1a\u5458\u7535\u8bdd");
            InputValidator.checkEmpty((Object)integralOrders.getGoodId(), (String)"\u5546\u54c1id");
            InputValidator.checkEmpty((Object)integralOrders.getSaleQuantity(), (String)"\u8d2d\u4e70\u6570\u91cf");
        }
        catch (Exception e) {
            throw new MallAdminException(e.getMessage());
        }
        log.info("\u67e5\u770bintegralOrders:{}", (Object)JSONObject.toJSONString((Object)integralOrders));
        if (integralOrders.getSaleQuantity() < 1) {
            throw new MallAdminException("\u8d2d\u4e70\u6570\u91cf\u4e0d\u5f97\u5c0f\u4e8e1\u4ef6\u3002");
        }
        IntegralGoods searchGoods = this.integralGoodsService.getGoodsById(integralOrders.getGoodId(), "pc");
        integralOrders.setIntegralGoods(searchGoods);
        if (!searchGoods.getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
            InputValidator.checkEmpty((Object)integralOrders.getGoodSkuNo(), (String)"\u5546\u54c1sku\u7f16\u53f7");
            String distributionMode = this.integralOrdersService.getDistributionModeBySkuNo(integralOrders.getGoodSkuNo());
            if ("0".equals(distributionMode)) {
                this.checkEmptyByShipping(integralOrders);
            } else if ("2".equals(distributionMode) && integralOrders.getOrderType().equals("0")) {
                this.checkEmptyByShipping(integralOrders);
            }
        }
        this.checkMember(integralOrders);
        if ("null".equals(integralOrders.getOrderType())) {
            if (!StringUtils.isEmpty((Object)integralOrders.getShippingAddress())) {
                integralOrders.setOrderType("0");
            } else {
                integralOrders.setOrderType("1");
            }
        }
        IntegralOrders orders = this.integralOrdersService.confirm(integralOrders);
        log.info("WxIntegralOrdersController#confirmGoods#orders:{}", (Object)JSON.toJSONString((Object)orders));
        if (orders != null) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u6210\u529f");
            map.put("data", orders);
            this.scheduledThreadPoolExecutor.execute(() -> {
                if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(orders.getOrderStatus())) {
                    this.scheduledThreadPoolExecutor.execute(() -> {
                        log.info("\u8ba2\u5355\u5f85\u652f\u4ed8\u8fdb\u5165job\u5b9a\u65f6\u53d6\u6d88[" + orders.getOrderNo() + "]" + new Date());
                        this.integralOrderJobService.addCustomizedIntegralOrderCancelJob(orders.getMerchantId(), orders.getOrderNo());
                    });
                }
                if (IntegralOrdersStatusEnum.UN_SHIPPED.getCode().equals(orders.getOrderStatus())) {
                    this.scheduledThreadPoolExecutor.execute(() -> this.erpOrderApiService.pushIntegralOrderOf361ToErp(this.getParams(orders)));
                }
            });
            String priceType = searchGoods.getPriceType();
            if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().toString().equalsIgnoreCase(priceType)) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("\u79ef\u5206\u8ba2\u5355pust\u4f7f\u7528\u7ebf\u7a0b\u6c60");
                    this.bizvaneInterface.pustIntegralOrder(orders.getOrderNo());
                });
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("\u79ef\u5206\u8ba2\u5355push\u4f7f\u7528\u7ebf\u7a0b\u6c60");
                    this.integralApiService.pushOrderToConnector(orders.getOrderNo());
                });
            }
        } else {
            map.put("code", -1);
            map.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return map;
    }

    private GetPushIntegralOrderToErpRequestVO getParams(IntegralOrders orders) {
        GetPushIntegralOrderToErpRequestVO request = new GetPushIntegralOrderToErpRequestVO();
        request.setOrderId(orders.getId());
        request.setOrderNo(orders.getOrderNo());
        request.setExecuteType("pushByIdOrOrderNo");
        request.setMerchantId(orders.getMerchantId());
        return request;
    }

    @PostMapping(value={"/getFeight"})
    public ResponseData getFeight(@RequestBody IntegralOrderFeightVO integralOrderFeightVO) {
        log.info("\u79ef\u5206\u5546\u54c1\u8fd0\u8d39\u8ba1\u7b97\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)integralOrderFeightVO));
        ResponseData responseData = this.integralOrdersService.getFeight(integralOrderFeightVO);
        return responseData;
    }

    public void checkMember(IntegralOrders integralOrders) {
        log.info("checkMember\u5165\u53c2:[{}]", JSON.toJSON((Object)integralOrders));
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        log.info("WxIntegralOrdersController#checkMember integralGoods:{}", (Object)JSON.toJSONString((Object)integralGoods));
        if (integralGoods != null && integralGoods.getMemberScope() != 0) {
            String storeWhiteList;
            Object list;
            List list1;
            log.info("\u8be5\u5546\u54c1\u9700\u8981\u6821\u9a8c\u662f\u5426\u9002\u7528\u7b49\u7ea7\u548c\u5e97\u94fa");
            if (!StringUtils.isEmpty((Object)integralGoods.getStoreWhiteList()) && !CollectionUtils.isEmpty((Collection)(list1 = (List)(list = new Gson().fromJson(storeWhiteList = integralGoods.getStoreWhiteList(), new /* Unavailable Anonymous Inner Class!! */.getType())))) && list1.stream().noneMatch(e -> integralOrders.getStoreId().toString().equals(e.getSysStoreId()))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5f00\u5361\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u95e8\u5e97\u8303\u56f4");
            }
            if (!StringUtils.isEmpty((Object)integralGoods.getMemberLevelNames()) && Arrays.stream(integralGoods.getMemberLevelNames().split(",")).noneMatch(e -> integralOrders.getLevelName().equals(e))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5361\u7b49\u7ea7\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u7b49\u7ea7\u8303\u56f4");
            }
        }
        log.info("\u5546\u54c1\u901a\u8fc7\u6821\u9a8c:_\u5546\u54c1Id:[{}]", (Object)integralOrders.getGoodId());
    }

    @RequestMapping(value={"/getOrderListByStatus/{merchantId}/{orderStatus}/{memberCode}/{pageNum}/{pageSize}"}, method={RequestMethod.GET})
    public JSONObject getOrderListByStatus(@PathVariable(value="merchantId") Integer merchantId, @PathVariable(value="orderStatus", required=false) String orderStatus, @PathVariable(value="memberCode") String memberCode, @PathVariable(value="pageNum") Integer pageNum, @PathVariable(value="pageSize") Integer pageSize) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u5217\u8868...");
        log.info("merchantId/orderStatus/memberCode:{}", (Object)(merchantId + "/" + orderStatus + "/" + memberCode));
        PageInfo orderListByStatus = this.integralOrdersService.getOrderListByStatus(merchantId, orderStatus, memberCode, pageNum, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)0);
        jsonObject.put("data", (Object)orderListByStatus);
        return jsonObject;
    }

    @RequestMapping(value={"/getOrderListByStatus/{merchantId}/{orderStatus}/{memberCode}"}, method={RequestMethod.GET})
    public List<IntegralOrders> getOrderListByStatus(@PathVariable(value="merchantId") Integer merchantId, @PathVariable(value="orderStatus") String orderStatus, @PathVariable(value="memberCode") String memberCode) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u5217\u8868...");
        log.info("merchantId/orderStatus/memberCode:{}", (Object)(merchantId + "/" + orderStatus + "/" + memberCode));
        return this.integralOrdersService.getOrderListByStatus(merchantId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/getOrderById/{orderId}"}, method={RequestMethod.GET})
    public IntegralOrders getOrderById(@PathVariable(value="orderId") Integer orderId) {
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5...");
        return this.integralOrdersService.getOrderById(orderId);
    }

    private void checkEmptyByShipping(IntegralOrders integralOrders) {
        if (StringUtils.isEmpty((Object)integralOrders.getShippingName()) || StringUtils.isEmpty((Object)integralOrders.getShippingMobile()) || StringUtils.isEmpty((Object)integralOrders.getShippingProvince()) || StringUtils.isEmpty((Object)integralOrders.getShippingCity()) || StringUtils.isEmpty((Object)integralOrders.getShippingDistrict()) || StringUtils.isEmpty((Object)integralOrders.getShippingAddress()) || "undefined".equals(integralOrders.getShippingName()) || "undefined".equals(integralOrders.getShippingMobile()) || "undefined".equals(integralOrders.getShippingProvince()) || "undefined".equals(integralOrders.getShippingCity()) || "undefined".equals(integralOrders.getShippingDistrict()) || "undefined".equals(integralOrders.getShippingAddress())) {
            throw new MallAdminException("\u8bf7\u5b8c\u5584\u6536\u8d27\u4fe1\u606f\uff01");
        }
    }

    @GetMapping(value={"payment"})
    public ResponseData getJspayResponse(Integer ordersId) {
        log.info("payment_request:{}", (Object)ordersId);
        ResponseData payment = this.integralPayService.payment(ordersId);
        log.info("payment_response:{}", (Object)JSON.toJSONString((Object)payment));
        return payment;
    }

    @PostMapping(value={"paymentWithCoupon"})
    public ResponseData paymentWithCoupon(@RequestBody IntegralCouponPayVO integralCouponPayVO) {
        log.info("paymentWithCoupon_request:{}", (Object)JSON.toJSONString((Object)integralCouponPayVO));
        ResponseData payment = this.integralPayService.paymentWithCoupon(integralCouponPayVO);
        log.info("paymentWithCoupon_response:{}", (Object)JSON.toJSONString((Object)payment));
        return payment;
    }
}

