/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.api.self_mention;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.selfMention.SelfMentionReceivedRequestVO;
import com.wmeimob.fastboot.bizvane.entity.selfMention.SelfMentionRefundSecondRequestVO;
import com.wmeimob.fastboot.bizvane.enums.SelfMentionRefundSecondTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.enums.self.SelfPickOrdersTypeEnum;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.bizvane.service.selfmentionorder.SelfMentionOrderService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.util.StringUtil;

@RestController
@RequestMapping(value={"selfMention"})
public class SelfMentionOrderController {
    private static final Logger log = LoggerFactory.getLogger(SelfMentionOrderController.class);
    @Autowired
    private OrdersService ordersService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private SelfMentionOrderService selfMentionOrderService;
    @Resource
    private OrdersServiceImpl ordersServiceImpl;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private LoginUtil loginUtil;

    @PostMapping(value={"/orders"})
    public ResponseData orderList(@RequestHeader(value="erpStoreId") String erpStoreId, @RequestBody(required=false) Orders orders, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        log.info("\u81ea\u63d0\u8ba2\u5355\u5546\u79c0\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f param:{}", JSON.toJSON((Object)orders));
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 5;
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)erpStoreId)) {
            return ResponseUtil.getFailedMsg((String)"erpStoreId\u4e3a\u7a7a");
        }
        if (orders == null || orders.getSysCompanyId() == null) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u4e3a\u7a7a");
        }
        orders.setErpStoreId(erpStoreId);
        orders.setShippingMode(Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()));
        orders.setMerchantIds(this.selfMentionOrderService.getMerchantIdByCompanyId(orders.getSysCompanyId()));
        if (CollectionUtils.isEmpty((Collection)orders.getMerchantIds())) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u5bf9\u5e94\u54c1\u724c\u672a\u627e\u5230\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.ordersService.findByCondition((Serializable)orders);
        PageInfo ordersPageInfo = new PageInfo(list);
        log.info("ordersPageInfo:{}", (Object)ordersPageInfo);
        return ResponseUtil.getSuccessData((Object)ordersPageInfo);
    }

    @PostMapping(value={"/orders/{id}"})
    public ResponseData getOrderById(@PathVariable(value="id") Integer id) {
        log.info("\u81ea\u63d0\u8ba2\u5355\u5546\u79c0\u83b7\u53d6\u8ba2\u5355\u4fe1\u606fgetOrderById\u63a5\u53e3 id:{}", (Object)id);
        return ResponseUtil.getSuccessData((Object)this.commonOrdersService.findById(id));
    }

    @PostMapping(value={"/refundOrders"})
    public ResponseData refundOrderList(@RequestHeader(value="erpStoreId") String erpStoreId, @RequestBody(required=false) RefundOrder refundOrder, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        log.info("\u81ea\u63d0\u8ba2\u5355\u5546\u79c0\u9000\u5355\u5217\u8868\u4fe1\u606f:{}", JSON.toJSON((Object)refundOrder));
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 5;
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)erpStoreId)) {
            return ResponseUtil.getFailedMsg((String)"erpStoreId\u4e3a\u7a7a");
        }
        if (refundOrder == null || refundOrder.getSysCompanyId() == null) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u4e3a\u7a7a");
        }
        refundOrder.setMerchantIds(this.selfMentionOrderService.getMerchantIdByCompanyId(refundOrder.getSysCompanyId()));
        if (CollectionUtils.isEmpty((Collection)refundOrder.getMerchantIds())) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u5bf9\u5e94\u54c1\u724c\u672a\u627e\u5230\u4e3a\u7a7a");
        }
        refundOrder.setErpStoreId(erpStoreId);
        refundOrder.setPageNum(pageNum);
        refundOrder.setPageSize(pageSize);
        refundOrder.setShippingMode(Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()));
        PageInfo refundOrderPageInfo = this.refundOrderService.findByConditionSX(refundOrder);
        log.info("refundOrderPageInfo:{}", (Object)refundOrderPageInfo);
        return ResponseUtil.getSuccessData((Object)refundOrderPageInfo);
    }

    @PostMapping(value={"/refundOrders/{id}"})
    public ResponseData getRefundOrderById(@PathVariable(value="id") Integer id) {
        log.info("\u81ea\u63d0\u8ba2\u5355\u5546\u79c0\u9000\u5355\u8be6\u7ec6\u4fe1\u606f:{}", (Object)id);
        return ResponseUtil.getSuccessData((Object)this.refundOrderService.findById(id));
    }

    @PostMapping(value={"/selfMentionReceived"})
    public ResponseData selfMentionReceived(@RequestBody SelfMentionReceivedRequestVO vo) {
        log.info("\u81ea\u63d0\u8ba2\u5355\u5546\u79c0\u81ea\u63d0\u8be6\u7ec6\u4fe1\u606f:{}", JSON.toJSON((Object)vo));
        if (StringUtil.isEmpty((String)vo.getPickErpGuideId())) {
            return ResponseUtil.getFailedMsg((String)"\u786e\u8ba4\u6536\u8d27\u5bfc\u8d2did\u4e3a\u7a7a");
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)vo.getId())) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)vo.getPickErpGuideName())) {
            return ResponseUtil.getFailedMsg((String)"\u786e\u8ba4\u6536\u8d27\u5bfc\u8d2d\u59d3\u540d\u4e3a\u7a7a");
        }
        try {
            this.selfMentionOrderService.confirm(vo);
            return ResponseUtil.getSuccessData(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
    }

    @PostMapping(value={"/selfMentionRefundFirst"})
    public ResponseData selfMentionRefundFirst(@RequestBody RefundOrder refundOrder) {
        int result = 0;
        if (refundOrder.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u552e\u540e\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)refundOrder.getAuditor())) {
            return ResponseUtil.getFailedMsg((String)"\u5ba1\u6279\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundOrder.getAuditorId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5ba1\u6279\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundOrder.getAuditStatus() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            log.info("\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5165\u53c2:{}", JSON.toJSON((Object)refundOrder));
            result = this.refundOrderService.update((Serializable)refundOrder);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return ResponseUtil.getFailedMsg((String)"\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5931\u8d25");
        }
        return result < 0 ? ResponseUtil.getFailedData((Object)"\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5931\u8d25") : ResponseUtil.getSuccessData(null);
    }

    @PostMapping(value={"/selfMentionRefundSecond"})
    public ResponseData selfMentionRefundSecond(@RequestBody SelfMentionRefundSecondRequestVO vo) {
        log.info("\u9000\u6b3e\u5ba1\u6838\uff1a{}", JSON.toJSON((Object)vo));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u9000\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RefundOrder refundOrder = new RefundOrder();
        BeanUtils.copyProperties((Object)vo, (Object)refundOrder);
        if (StringUtils.isEmpty((Object)vo.getAuditor())) {
            vo.setAuditor("Mall-" + this.loginUtil.getLoginUser(this.request).getNickName());
        }
        if (SelfMentionRefundSecondTypeEnum.ACCEPT.getCode().equals(vo.getSelfMentionRefundSecondType())) {
            try {
                int result = this.refundOrderService.updateRefundStatus(refundOrder);
                return ResponseUtil.getSuccessData(null, (String)"\u9000\u6b3e\u6210\u529f!");
            }
            catch (Exception e) {
                log.warn("\u786e\u8ba4\u9000\u6b3e\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                return ResponseUtil.getFailedMsg((String)e.getMessage());
            }
        }
        if (SelfMentionRefundSecondTypeEnum.REJECT.getCode().equals(vo.getSelfMentionRefundSecondType())) {
            return this.refundOrderService.updateRefundStatusReject(vo);
        }
        return ResponseUtil.getFailedMsg((String)"\u4f60\u7684\u9000\u6b3e\u7c7b\u578b\u4e0d\u5339\u914d");
    }

    @PostMapping(value={"/selfMentionOrdersCount"})
    public ResponseData selfMentionOrdersCount(@RequestHeader(value="erpStoreId") String erpStoreId, @RequestBody(required=false) Orders vo) {
        log.info("SelfMentionOrderController selfMentionOrdersCount erpStoreId:{} vo:{}", (Object)erpStoreId, (Object)vo);
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)erpStoreId)) {
            return ResponseUtil.getFailedMsg((String)"erpStoreId\u4e3a\u7a7a");
        }
        if (vo == null || vo.getSysCompanyId() == null) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u4e3a\u7a7a");
        }
        Orders orders = new Orders();
        orders.setErpStoreId(erpStoreId);
        orders.setSearchCondition(vo.getSearchCondition());
        orders.setMerchantIds(this.selfMentionOrderService.getMerchantIdByCompanyId(vo.getSysCompanyId()));
        if (CollectionUtils.isEmpty((Collection)orders.getMerchantIds())) {
            return ResponseUtil.getFailedMsg((String)"sysCompanyId\u5bf9\u5e94\u54c1\u724c\u672a\u627e\u5230\u4e3a\u7a7a");
        }
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        orders.setQueryStatus(SelfPickOrdersTypeEnum.UNLOGISTICS.getQueryStatus());
        result.put(SelfPickOrdersTypeEnum.UNLOGISTICS.getStatus(), this.ordersService.countByConditionSelfPick(orders));
        orders.setQueryStatus(SelfPickOrdersTypeEnum.SUCCESS_DEAL.getQueryStatus());
        result.put(SelfPickOrdersTypeEnum.SUCCESS_DEAL.getStatus(), this.ordersService.countByConditionSelfPick(orders));
        RefundOrder refundOrder = new RefundOrder();
        refundOrder.setSearchCondition(vo.getSearchCondition());
        refundOrder.setErpStoreId(erpStoreId);
        refundOrder.setPageNum(Integer.valueOf(1));
        refundOrder.setPageSize(Integer.valueOf(1));
        refundOrder.setMerchantIds(orders.getMerchantIds());
        refundOrder.setShippingMode(Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()));
        refundOrder.setQueryStatus(SelfPickOrdersTypeEnum.REFUND_WAIT_AUDIT.getQueryStatus());
        result.put(SelfPickOrdersTypeEnum.REFUND_WAIT_AUDIT.getStatus(), this.refundOrderService.findByConditionSX(refundOrder).getTotal());
        refundOrder.setQueryStatus(SelfPickOrdersTypeEnum.REFUNDING.getQueryStatus());
        result.put(SelfPickOrdersTypeEnum.REFUNDING.getStatus(), this.refundOrderService.findByConditionSX(refundOrder).getTotal());
        refundOrder.setQueryStatus(SelfPickOrdersTypeEnum.ORDERS_CLOSE.getQueryStatus());
        result.put(SelfPickOrdersTypeEnum.ORDERS_CLOSE.getStatus(), this.refundOrderService.findByConditionSX(refundOrder).getTotal());
        return ResponseUtil.getSuccessData(result);
    }

    @PostMapping(value={"/selfMentionJudge/{id}"})
    public Map selfMentionJudge(@PathVariable Integer id) {
        log.info("SelfMentionOrderController selfMentionJudge id:{}", (Object)id);
        return this.ordersServiceImpl.judgeSend(id);
    }
}

