/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.core.context.RequestAttributeContext;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;

    @GetMapping(value={"user-info"})
    public LoginUser getLoginUser(String accessToken, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("LoginController#loginUser accessToken:{},merchantId:{}", (Object)accessToken, (Object)merchantId);
        if (StringUtils.isEmpty((Object)accessToken) || "null".equals(accessToken) || merchantId == null) {
            HttpServletResponse response = RequestAttributeContext.getResponse();
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return null;
        }
        LoginUser loginUser = new LoginUser();
        try {
            loginUser = this.bizvaneInterface.decryptManagermentToken(accessToken);
        }
        catch (Exception e) {
            log.error("LoginController#loginUser:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        log.info("LoginController#getLoginUser  ,{}", (Object)JSONObject.toJSONString((Object)loginUser));
        Example example = new Example(CompanyBrandRelation.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("companyId", (Object)loginUser.getCompanyId());
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)example);
        if (companyBrandRelation == null) {
            companyBrandRelation = new CompanyBrandRelation();
            companyBrandRelation.setMerchantId(merchantId);
            companyBrandRelation.setBrandId(loginUser.getBrandId());
            companyBrandRelation.setCompanyId(loginUser.getCompanyId());
            companyBrandRelation.setCompanyCode(loginUser.getCompanyCode());
            companyBrandRelation.setCompanyName(loginUser.getCompanyName());
            companyBrandRelation.setMerchantName(loginUser.getMerchantName());
            companyBrandRelation.setMerchantCode(loginUser.getMerchantCode());
            companyBrandRelation.setAuthenticationKey(UUID.randomUUID().toString());
            this.companyBrandRelationMapper.insertSelective((Object)companyBrandRelation);
        } else if (StringUtils.isEmpty((Object)companyBrandRelation.getAuthenticationKey())) {
            companyBrandRelation.setAuthenticationKey(UUID.randomUUID().toString());
            this.companyBrandRelationMapper.updateByPrimaryKeySelective((Object)companyBrandRelation);
        }
        Example classifyExa = new Example(GoodsClassify.class);
        classifyExa.createCriteria().andEqualTo("merchantId", (Object)merchantId).andCondition("(coding='bargain' or coding='assemble')");
        List goodsClassifies = this.goodsClassifyMapper.selectByExample((Object)classifyExa);
        if (goodsClassifies.size() < 2) {
            if (goodsClassifies.size() == 1) {
                this.goodsClassifyMapper.deleteByPrimaryKey((Object)((GoodsClassify)goodsClassifies.get(0)).getId());
            }
            for (int i = 0; i < 2; ++i) {
                String coding = "";
                String name = "";
                if (i == 0) {
                    coding = "bargain";
                    name = "\u780d\u4ef7\u6d3b\u52a8";
                }
                if (i == 1) {
                    coding = "assemble";
                    name = "\u62fc\u56e2\u6d3b\u52a8";
                }
                GoodsClassify classify = new GoodsClassify();
                classify.setCoding(coding);
                classify.setName(name);
                classify.setMerchantId(merchantId);
                classify.setPid(Integer.valueOf(0));
                this.goodsClassifyMapper.insertSelective((Object)classify);
                GoodsClassify classify1 = new GoodsClassify();
                classify1.setCoding(coding + "Child");
                classify1.setName(name);
                classify1.setMerchantId(merchantId);
                classify1.setPid(classify.getId());
                this.goodsClassifyMapper.insertSelective((Object)classify1);
            }
        }
        loginUser.setMerchantId(merchantId);
        return loginUser;
    }
}

