package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 商户
 */
@Getter
@Setter
public class TBasicMerchantVo implements Serializable {


    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "商户code")
    private String merchantCode;

    @ApiModelProperty(value = "商户编码")
    private String merchantNo;

    @ApiModelProperty(value = "商户名称")
    private String merchantName;

    @ApiModelProperty(value = "所属机场")
    private String airportCode;
    @ApiModelProperty(value = "机场名称")
    private String airportName;

    @ApiModelProperty(value = "所属业态")
    private String businessCode;
    @ApiModelProperty(value = "业态名称")
    private String businessName;

    @ApiModelProperty(value = "所属楼宇")
    private String buildingCode;
    @ApiModelProperty(value = "楼宇名称")
    private String buildingName;

    @ApiModelProperty(value = "所属区域")
    private String areaCode;

    @ApiModelProperty(value = "状态：0=禁用；1=启用")
    private Boolean status;

    @ApiModelProperty(value = "Logo")
    private String logo;

    @ApiModelProperty(value = "营业时间（开始）")
    private Date timeStart;

    @ApiModelProperty(value = "营业时间（结束）")
    private Date timeEnd;

    @ApiModelProperty(value = "主营业务")
    private String mainBusiness;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "商户铺位号")
    private String berthNumbers;

    @ApiModelProperty(value = "创建人id")
    private String createUserCode;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private String modifiedUserCode;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty(value = "备注")
    private String remark;


}
