package com.bizvane.basic.feign.model.rsp.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

@Getter
@Setter
@ApiModel
public class QueryApproveConfigListResponseVO {


    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("流程code")
    private String approveConfigCode;

    @ApiModelProperty("流程名称")
    private String approveName;

    @ApiModelProperty("审批范围")
    private String approveRange;

    @ApiModelProperty("审批范围名称")
    private String approveRangeName;

    @ApiModelProperty("审批业务")
    private String approveBusiness;

    @ApiModelProperty("审批业务名称")
    private String approveBusinessName;

    @ApiModelProperty("状态（0禁用 1启用）")
    private Boolean status;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "审批配置节点")
    private List<QueryApproveConfigNodeListResponseVO> approveConfigNodeList;
}
