package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.AccountLoginReq;
import com.bizvane.basic.feign.model.req.TSysAccountChangePasswordReq;
import com.bizvane.basic.feign.model.req.TSysAccountPageReq;
import com.bizvane.basic.feign.model.vo.TSysAccountAddOrModifyVo;
import com.bizvane.basic.feign.model.vo.TSysAccountSaveVo;
import com.bizvane.basic.feign.model.vo.TSysAccountVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysAccount")
@Api(value = "账号信息RPC")
public interface SysAccountRpcFeign {

    @RequestMapping(value = "/getAccountInfo", method = RequestMethod.POST)
    @ApiOperation(value = "获取账号信息")
    ResponseData<List<TSysAccountVo>> getAccountInfo(@RequestBody TSysAccountVo tSysAccountReq);

    @RequestMapping(value = "/login", method = RequestMethod.POST)
    @ApiOperation(value = "登录")
    ResponseData<TSysAccountVo> login(@RequestBody AccountLoginReq accountLoginReq);

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysAccountAddOrModifyVo>> pageList(@RequestBody TSysAccountPageReq req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加账号")
    ResponseData<Boolean> save(@RequestBody TSysAccountSaveVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "修改账号")
    ResponseData<Boolean> modify(@RequestBody TSysAccountAddOrModifyVo req);

    @RequestMapping(value = "/changePassword", method = RequestMethod.POST)
    @ApiOperation(value = "修改密码")
    ResponseData<Boolean> changePassword(@RequestBody TSysAccountChangePasswordReq req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "账号详情")
    ResponseData<TSysAccountAddOrModifyVo> detail(@RequestBody TSysAccountAddOrModifyVo req);


}
