package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.vo.TStaffOrderVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tStaffOrder")
@Api(value = "员工订单RPC")
public interface StaffOrderRpcFeign {

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "保存订单")
    ResponseData<Boolean> save(@RequestBody @Validated TStaffOrderVo req);

}
