package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBasicStaffPageReq;
import com.bizvane.basic.feign.model.vo.TBasicStaffVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicStaff")
@Api(value = "员工RPC")
public interface BasicStaffRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TBasicStaffVo>> pageList(@RequestBody TBasicStaffPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "员工列表")
    ResponseData<List<TBasicStaffVo>> list(@RequestBody TBasicStaffVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加员工")
    ResponseData<Boolean> save(@RequestBody TBasicStaffVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑员工")
    ResponseData<Boolean> modify(@RequestBody TBasicStaffVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TBasicStaffVo> detail(@RequestBody TBasicStaffVo req);

}
