package com.bizvane.basic.feign.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 审批业务枚举
 */

@Getter
public enum ApproveBusinessEnum {

    MARKETING("MARKETING", "营销任务"),
    SEND_COUPON("SEND_COUPON", "发券任务"),
    ;
    private final String code;
    private final String value;

    ApproveBusinessEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static ApproveBusinessEnum getByCode(String code) {
        for (ApproveBusinessEnum value : ApproveBusinessEnum.values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
