package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 员工
 */
@Data
public class TBasicStaffVo implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "员工code")
    private String staffCode;

    @ApiModelProperty(value = "员工名称")
    private String staffName;

    @ApiModelProperty(value = "员工类型(1-内部员工  2-委外员工)")
    private Integer staffType;

    @ApiModelProperty(value = "员工编码")
    private String staffNo;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "退休（1退休 0未退休）")
    private Boolean retire;

    @ApiModelProperty(value = "状态：0=离职；1=在职")
    private Boolean status;

    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty(value = "备注")
    private String remark;



}
