package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.AccountLoginReq;
import com.bizvane.basic.feign.model.vo.TSysAccountVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysAccount")
@Api(value = "账号信息RPC")
public interface SysAccountRpcFeign {

    @RequestMapping(value = "/getAccountInfo", method = RequestMethod.POST)
    @ApiOperation(value = "获取账号信息")
    ResponseData<TSysAccountVo> getAccountInfo(@RequestBody TSysAccountVo tSysAccountReq);



    @RequestMapping(value = "/login", method = RequestMethod.POST)
    @ApiOperation(value = "登录")
    ResponseData<TSysAccountVo> login(@RequestBody AccountLoginReq accountLoginReq);

}
