/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.baseservice.oss.utils;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.io.FileTypeUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);

    public static String getBase64Content(MultipartFile file, String fullFileName) throws IOException {
        if (OssUtils.checkFileTypeMismatch(fullFileName, file.getInputStream())) {
            return Base64Encoder.encodeUrlSafe((byte[])file.getBytes());
        }
        throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5230base-oss\u672a\u901a\u8fc7\u6821\u9a8c");
    }

    public static boolean checkFileTypeMismatch(String fileFullName, InputStream inputStream) {
        String type = null;
        if (fileFullName.contains(".")) {
            String[] split = fileFullName.split("\\.");
            String lastName = split[1];
            type = FileTypeUtil.getType((InputStream)inputStream);
            log.info("\u4e0a\u4f20\u6587\u4ef6\u7684\u6269\u5c55\u540d:{} \u5b9e\u9645\u7684\u6269\u5c55\u540d\u662f:{}", (Object)lastName, (Object)type);
            return type.toLowerCase().equals(lastName.toLowerCase());
        }
        if (StringUtils.isEmpty(type)) {
            log.error("\u6587\u4ef6\u540d\u5fc5\u987b\u5305\u542b\u6269\u5c55\u540d");
        }
        return false;
    }
}

