package com.bizvane.baison.facade.models.request;


import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单明细信息
 */
@Data
@Valid
public class RecordDetailModel implements Serializable {


    /***************************内部需要*******************************/
    private String erpId;
    private String memberCode;
    private Long sysCompanyId;
    private Long brandId;
    private String offlineCompanyCode;
    private String offlineBrandCode;
    //店铺服务导购提成比例(多导购)
    @JSONField(name = "assistant_list_weight")
    private String serviceGuideProportion;
    /*************************外部传入*********************************/


    //小票单号
    @NotBlank(message = "record_code不能为空")
    @JSONField(name ="record_code")
    private String orderNo;

    //小票单详情号
    @NotBlank(message = "record_detail_code不能为空")
    @JSONField(name ="record_detail_code")
    private String orderDetailNo;

    //商品品牌code
    @NotBlank(message = "brand_code不能为空")
    @JSONField(name ="brand_code")
    private String brandCode;

    //商品名称 商品名称
    @JSONField(name ="good_name")
    private String productName;

    //商品代码 商品编号
    @NotBlank(message = "good_code不能为空")
    @JSONField(name ="good_code")
    private String productNo;

    @NotBlank(message = "sku_code不能为空")
    @JSONField(name ="sku_code")
    private String sku;

    //条码，中台展示
    private String productItemId;

    //数量
    @JSONField(name ="num")
    private Integer quantity;

    //颜色描述
    @JSONField(name ="color_name")
    private String color;

    //尺码描述
    @JSONField(name ="size_name")
    private String size;

    //实际金额   成交价
    @JSONField(name ="money")
    private BigDecimal tradeAmountDetail;

    //标准金额	 吊牌价
    @JSONField(name ="standard_money")
    private BigDecimal tagPrice;

    //实际折扣  折扣率
    @JSONField(name ="discount")
    private BigDecimal rebate;

    //实际单价  折后价
    @JSONField(name ="price")
    private BigDecimal discountPrice;


    //暂无字段存储，但是需存储
    //商品状态 0-正常 1-促销 2-换购 3-赠品 4-让利 5-补差优惠 6-VIP叠加优惠 7-生日优惠 8-整单叠加优惠 9-积分换购 11-换货，12-已换货,13-打折券,14-产品定制,15-外卡叠加优惠,16-满购品’
    @JSONField(name ="good_status")
    private Integer goodStatus;

    //暂无字段存储，但是需存储
    //积分倍率
    @JSONField(name ="integral_double")
    private BigDecimal integralDouble;

    //折扣券代码
    @JSONField(name ="discount_coupon_code")
    private String discountCouponCode;

    //折扣券代码金额
    @JSONField(name ="discount_coupon_money")
    private BigDecimal discountCouponMoney;

    //颜色代码
    @JSONField(name ="color_code")
    private String colorCode;

    //尺码code
    @JSONField(name ="size_code")
    private String sizeCode;

    @JSONField(name = "assistant_list_code")
    private String serviceGuideIds;

}
