package com.bizvane.baison.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class IntegralModel {

    @ApiModelProperty(value = "vip会员代码" , name = "vip_code")
    @JSONField(name = "vip_code")
    private String erpId;

    @ApiModelProperty(value = "操作编号(消费操作) 0初始建档 5积分调整 7积分清零 10充值积分", name = "type")
    @JSONField(name = "type")
    private Integer type;

    @ApiModelProperty(value = "积分变化", name = "integral")
    @JSONField(name = "integral")
    private Integer changeIntegral;

    @ApiModelProperty(value = "积分变化后" , name = "integral_after")
    private Integer integral_after;

    @ApiModelProperty(value = "操作时间", name = "add_time")
    @JSONField(name = "add_time")
    private Long createTime;

    @ApiModelProperty(value = "操作单号", name = "relation_code")
    @JSONField(name = "relation_code")
    private String changeBills;

    @ApiModelProperty(value = "备注", name = "remark")
    private String remark;

    @ApiModelProperty(value = "品牌code", name = "brand_code")
    @JSONField(name = "brand_code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "唯一流水号", name = "serial_number")
    @JSONField(name = "serial_number")
    private String offlineIntegralId;

}
