package com.bizvane.baison.facade.enums;

/**
 * 百胜订单 支付 结算方式
 */
public enum PayType {

    //结算代码 000,现金，001 银行卡,002 储值卡,003 VIP储值卡,004 礼券,005 VIP积分
    // 096 订金付款,097 VIP变现,098 线上优惠,099 线上支付
    // JDCOUPON 京东优惠券,
    // passport_yh Passport支付优惠,
    // VIPCZK_JE VIP储值卡实付金额,
    // VIPCZK_YH VIP储值卡优惠金额

    _CASH_000("000", "现金"),
    _BANK_CARD_001("001", "银行卡"),
    _STORED_VALUE_CARD_002("002", "储值卡"),
    _CASH_003("003", "VIP储值卡"),
    _COUPON_004("004", "礼券"),
    _VIP_INTEGRAL_005("005", "VIP积分"),
    _CASH_006("006", "VIP积分"),
    _DEPOSIT_PAYMENT_096("096", "订金付款"),
    _VIP_INTO_CASH_097("097", "VIP变现"),
    _ONLINE_SALE_098("098", "线上优惠"),
    _ONLINE_PAY_099("099", "线上支付"),
    _JDCOUPON_097("JDCOUPON", "京东优惠券"),
    _PASSPORT_YH("passport_yh", "Passport支付优惠"),
    _VIPCZK_JE("VIPCZK_JE", "VIP储值卡实付金额"),
    _VIPCZK_YH("VIPCZK_YH", "VIP储值卡优惠金额");


    private String code;

    private String msg;

    PayType(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (PayType type : PayType.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
