package com.bizvane.baisonBase.facade.models.e3;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author huangxinliu
 * @date: 2021/1/19 10:39
 */
@ApiModel("百胜E3请求基本参数")
@Data
public class BaisonE3ReqBasicModel implements Serializable {

    private String ak;
    @ApiModelProperty("请求数据内容，为json字符串")
    private String dataContent;
    private String date;
    private Integer number;
    private String pk;

    @ApiModelProperty("登录E3+系统的签名，MD5withRSA算法")
    private String sign;

    @ApiModelProperty("由登录E3+系统返回token， 用于其他业务接口调用")
    private String token;

}
