package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.baisonBase.facade.models.mj.QueryGiftRecordsResponseVo;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 梦洁会员接口
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/icrmMember")
public interface MjMemberServiceRpc {

    /**
     * 查询会员
     * */
    @RequestMapping(value ="queryMemberInfo",method = RequestMethod.POST)
    Result<MemberLoginResponseVO> queryMemberInfo(MjQueryMemberInfoRequestVo requestVo);

    /**
     * 会员注册修改
     * */
    @RequestMapping(value ="addAndUpdateMember",method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> addAndUpdateMember(MemberOpenCardRequestVO requestVo);

    /**
     * 会员积分调整
     * */
    @RequestMapping(value ="adjustIntegral",method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustIntegral(IntegralAdjustRequestVO requestVo);

    /**
     * 礼品卡绑卡
     */
    @RequestMapping(value ="giftCardBind",method = RequestMethod.POST)
    Result giftCardBind(MjQueryMemberInfoRequestVo requestVo);

    /**
     * 查询会员礼品卡流水
     */
    @RequestMapping(value ="queryGiftRecords",method = RequestMethod.POST)
    Result<List<QueryGiftRecordsResponseVo>> queryGiftRecords(MjQueryMemberInfoRequestVo requestVo);


    @ApiOperation( value = "查询会员即将过期积分",notes = "查询会员即将过期积分",tags = {"mj"},httpMethod = "POST")
    @RequestMapping(value = "queryExpireIntegral", method = RequestMethod.POST)
    Result<Long> queryExpireIntegral(@RequestBody MjQueryMemberInfoRequestVo requestVo);


}
