package com.bizvane.baisonBase.facade.service.mj;


import com.bizvane.baisonBase.facade.models.mj.*;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.members.facade.vo.MemberCouponExpireRequestVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

public interface MjShuyunMemberService {

    MjShuyunMemberQueryResponseVO queryMemberInfo(String brandCode, String erpId);

    Result<MemberOpenCardResponseVO> register(MemberOpenCardRequestVO requestVo);

    Result<Object> mbrUpdate(MemberOpenCardRequestVO requestVo);

    String getShuyunMbrLevel(String brandCode, String erpId);

    Integer getShuyunMbrIntegral(String brandCode, String erpId);

    ResponseData<IntegralAdjustResponseVO> adjustIntegral(MjShuyunIntegralAdjustRequestVO requestVo);

    PageInfo<IntegralRecordModel> listIntegralRecord(IntegralRecordVo integralRecordVo);

    PageInfo<MjShuyunCouponExpireMemberResponseVO> listCouponExpireMember(MemberCouponExpireRequestVo requestVO);

    ResponseData<Object> mbrLabelAdd(MjShuyunMbrLabelAddRequestVO requestVO);

    ResponseData<Object> mbrLabelDelete(MjShuyunMbrLabelDeleteRequestVO requestVO);

    ResponseData<MjShuyunMbrGuideQueryResp> mbrGuideUpdateQuery(MjShuyunMbrGuideUpdateQueryReq requestVO);

    ResponseData<Object> mbrGuideUpdateConfirm(MjShuyunMbrGuideUpdateConfirmReq requestVO);
}
