package com.bizvane.baisonBase.facade.models.e3.vo;

import lombok.Data;

import java.util.Date;

/**
 * 百胜E3员工档案Vo
 * @author huangxinliu
 * @date: 2021/1/19 15:00
 */
@Data
public class BaisonE3StaffVo {

    //生日
    private Date birthday;
    //籍贯,id
    private String birthplace;
    //所属组织
    private BaisonE3ChannelVo channel;
    //所属组织id
    private String channelId;
    //店员类型  0 店长 1导购员  2 收银员
    private String clerkType;
    //员工id
    private String staffId;
    //工号
    private String code;
    //姓名
    private String name;
    //学历 0-博士  1-硕士  2-本科 3-专科 4-高中 5-初中 6-小学 7-其他
    private String degree;
    //员工改价权限
    private Object details;
    //创建组织
    private String createChannel;
    //创建组织id
    private Long createChannelId;
    //离职日期
    private Date dimissDate;
    //停用人
    private String disableBy;
    //停用时间
    private Date disableDate;
    //启用人
    private String enableBy;
    //启用时间
    private Date enableDate;
    //是否来源数据库
    private Boolean fromDB;
    //修改人
    private String modifyBy;
    //修改时间
    private Date modifyTime;
    //创建时间
    private Date createTime;
    //创建人
    private String createBy;
    //状态
    private String status;
    //入职日期
    private Date hireDate;
    //身份证
    private String iDCard;
    //职务级别
    private String level;
    //婚姻状态  0 未婚 1 已婚 2 离异
    private Integer maritalStatus;
    //删除标记* 0：初始状态，1：已删除
    private Integer recordFlag;
    //所属商店
    private Object shop;
    //所属商店编码
    private String shopCode;
    //所属商店id
    private String shopId;
    //员工状态  0 在职 1 离职
    private String staffStatus;
    //联系电话
    private String tel;
    //员工类型  0 普通员工 1 店员
    private Integer type;
    //关联用户id
    private String userId;
    //关联用户
    private Object userInfo;


    @Data
    public static class BaisonE3ChannelVo{

        //所属组织编码
        private String code;

        //所属组织名称
        private String name;

    }

}
