package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.mj.*;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 梦洁会员接口
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/mjShuyunCoupon")
public interface MjShuyunCouponServiceRpc {

    @RequestMapping(value ="couponDetail",method = RequestMethod.POST)
    ResponseData<CouponEntityAndDefinitionVO> couponDetail(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("couponCode") String couponCode);

    @RequestMapping(value ="listCoupon",method = RequestMethod.POST)
    ResponseData<PageInfo<CouponEntityAndDefinitionVO>> listCoupon(@RequestBody CouponListByMemberCodeRequestVO vo);

    @RequestMapping(value ="sendCoupon",method = RequestMethod.POST)
    ResponseData<String> sendCoupon(@RequestBody MjShuyunCouponSendRequestVo requestVO);

    @RequestMapping(value ="couponUse",method = RequestMethod.POST)
    ResponseData<Object> couponUse(@RequestBody MjShuyunCouponUseRequestVO requestVO);

    @RequestMapping(value ="couponReversal",method = RequestMethod.POST)
    ResponseData<Object> couponReversal(@RequestBody MjShuyunCouponReversalRequestVO requestVO);

    @RequestMapping(value ="couponTransfer",method = RequestMethod.POST)
    ResponseData<String> couponTransfer(@RequestBody MjShuyunCouponTransferRequestVo requestVO);

    @RequestMapping(value ="couponReceive",method = RequestMethod.POST)
    ResponseData<String> couponReceive(@RequestBody MjShuyunCouponReceiveRequestVo requestVO);

}
