package com.bizvane.baisonBase.facade.models.mj;

import com.bizvane.connectorservice.entity.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class MjShuyunIntegralAdjustRequestVO extends BaseModel {

    private String brandCode;

    private String erpId;

    private String businessType;

    private String shopCode;

    /**
     * 订单编号
     */
    private String orderBillNo;

    /**
     * 线下卡号   361必填
     */
    private String offlineCardNo;

    /**
     * 调整积分数量  361必填
     */
    private Integer changeIntegral;

    /**
     * 调整类型
     */
    private Integer changeType;


    /**
     * 调整详情
     */
    private String detail;

    /**
     * 所属门店UR
     */
    private String  storeId;
    /**
     * 积分数额UR
     */
    private Double pointsAmount;

    /**
     * 来源 UR  361必填为999
     */
    private String  source;

    /**
     * 关联积分流水id
     */
    private String relationPointsIdUnique;

    /**
     * 积分流水id防重 UR
     */
    private String pointsIdUnique;

    /**
     * 以下为361 加的字段
     */
    /**
     * 关联单据
     */
    private String relationCode;

    /**
     *	新增时间
     * @return
     */
    private String addTime;

    /**
     * 顾客代码
     */


    /**
     * 渠道
     */
    private String orgCode;

    /**
     * 店铺code
     */


    /**
     * 兑换的优惠券号
     */
    private String  couponCode;

    /**
     * 产生类型
     */
    private String createType;


    /**
     * 会员淘宝Nick
     * */
    private String taobaoNick;

    /**
     * linkflow
     * 积分唯一流水号
     * */
    private String serialNumber;

    /**
     * 手机号
     */
    private String phone;

    @ApiModelProperty(name = "changeDetails", value = "开启负积分")
    private Boolean enableNegativeIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启线下积分幂等")
    private Boolean enableIdempotentIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启补偿积分")
    private Boolean enableCompensateIntegral = Boolean.FALSE;
}
