package com.bizvane.baisonBase.facade.models.mj;

import com.bizvane.connectorservice.entity.base.BaseModel;
import com.bizvane.members.facade.vo.ExtendPropertySingleVO;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.members.facade.vo.MemberExtendPropertyValueVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.List;

@ToString
@Data
public class LedengMemberUpdateRequest {

    public LedengMemberUpdateRequest(String brandCode, String cardNo, String erpId, String phone, String name, Integer gender, String birthday, String email, String serviceStoreCode, String serviceGuideCode, Integer status) {
        this.brandCode = brandCode;
        this.cardNo = cardNo;
        this.erpId = erpId;
        this.phone = phone;
        this.name = name;
        this.gender = gender;
        this.birthday = birthday;
        this.email = email;
        this.serviceStoreCode = serviceStoreCode;
        this.serviceGuideCode = serviceGuideCode;
        this.status = status;
    }

    public LedengMemberUpdateRequest(String brandCode, String cardNo, Integer status) {
        this.brandCode = brandCode;
        this.cardNo = cardNo;
        this.status = status;
    }

    public LedengMemberUpdateRequest() {
    }

    private String brandCode;
    private String cardNo;

    private String erpId;
    /**
     * 手机号
     */
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 会员性别(1男   0女)
     */
    private Integer gender;

    /**
     * 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    @ApiModelProperty(value = "会员省份", name = "province")
    private String province;

    @ApiModelProperty(value = "会员城市", name = "city")
    private String city;

    @ApiModelProperty(value = "会员区县", name = "county")
    private String county;

    /**
     * 详细地址
     */
    private String address;


    /**
     * 邮箱
     */
    private String email;


    private String serviceStoreCode;


    private String serviceGuideCode;

    //  状态（1：正常，2冻结，3黑名单，4已合并）
    private Integer status = 1;

    // 扩展属性
    private List<MemberExtendPropertyValueVo> extendPropertyValueList;

}
