package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.mj.*;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.connectorservice.entity.yzw.RechargeCardInfoResponseVo;
import com.bizvane.connectorservice.entity.yzw.RechargeRecordInfoResponseVo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/ledeng")
public interface LedengServiceRpc {

    @RequestMapping(value ="queryMemberInfoByErpId",method = RequestMethod.POST)
    Result<MemberLoginResponseVO> queryMemberInfoByErpId(@RequestParam("brandCode") String brandCode, @RequestParam("cardNo") String cardNo);

    @RequestMapping(value ="queryMemberInfo",method = RequestMethod.POST)
    Result<MemberLoginResponseVO> queryMemberInfo(@RequestParam("brandCode") String brandCode, @RequestParam("phone") String phone);

    @RequestMapping(value ="addMember",method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> addMember(@RequestBody MemberOpenCardRequestVO requestVo);

    @RequestMapping(value ="updateMember",method = RequestMethod.POST)
    Result<Boolean> updateMember(@RequestBody LedengMemberUpdateRequest requestVo);

    @RequestMapping(value ="adjustIntegral",method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustIntegral(@RequestBody IntegralAdjustRequestVO requestVo);

    @RequestMapping(value ="getExpireIntegral",method = RequestMethod.POST)
    Result<Long> getExpireIntegral(@RequestBody MjQueryMemberInfoRequestVo requestVo);

    @RequestMapping(value ="addAndUpdateLabelDef",method = RequestMethod.POST)
    Result<Boolean> addAndUpdateLabelDef(@RequestBody MjLabelDefRequestVo requestVo);

    @RequestMapping(value ="addAndUpdateMbrLabel",method = RequestMethod.POST)
    Result<Boolean> addAndUpdateMbrLabel(@RequestBody MjMbrLabelRequestVo requestVo);

    @RequestMapping(value ="definitionAdd",method = RequestMethod.POST)
    Result<Boolean> definitionAdd(@RequestBody CouponDefinitionPOWithBLOBs definitionPO);

    @RequestMapping(value ="definitionUpdate",method = RequestMethod.POST)
    Result<Boolean> definitionUpdate(@Valid @RequestBody LedengCouponDefinitionUpdateRequest request);

    @RequestMapping(value ="couponSend",method = RequestMethod.POST)
    Result<Boolean> couponSend(@RequestBody LedengCouponSendRequest requestVo);
    
    /**
     * 优惠券核销
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="couponUse",method = RequestMethod.POST)
    Result<Boolean> couponUse(@RequestBody MjCouponUseRequestVo requestVo);
    
    /**
     * 优惠券转赠
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="couponTransfer",method = RequestMethod.POST)
    Result<Boolean> couponTransfer(@RequestBody MjCouponTransferRequestVo requestVo);

    /**
     * 查询储值卡列表，cardNo和erpId不能都是空，优先使用erpId作为查询条件
     * @return
     */
    @RequestMapping(value ="getRechargeCardList",method = RequestMethod.POST)
    Result<List<RechargeCardInfoResponseVo>> getRechargeCardList(@RequestParam("sysBrandId") long sysBrandId, @RequestParam("cardNo") String cardNo);

    /**
     * 查询储值卡流水列表，cardNo和erpId不能都是空，优先使用erpId作为查询条件
     * @param petCard 储值卡号
     * @return
     */
    @RequestMapping(value ="getRechargeCardRecordList",method = RequestMethod.POST)
    Result<PageInfo<RechargeRecordInfoResponseVo>> getRechargeCardRecordList(@RequestParam("petCard") String petCard, @RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize);

}
