/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.ExportAudiencesRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.ExportAudiencesResponse;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListAudiencesResponse;
import com.bizvane.audience.bo.AudienceDownloadBO;
import com.bizvane.audience.bo.AudienceDownloadLogBO;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.service.audience.SearchService;
import javax.annotation.Resource;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@RocketMQMessageListener(topic="qa_audiences_contentitem_export")
public class AudienceContentItemListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(AudienceContentItemListener.class);
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Autowired
    private SearchService searchService;

    public void onMessage(ConsumerMessage<String> message) {
        block5: {
            try {
                String objStr = new String(message.getBody(), Charsets.UTF_8);
                log.info("AudienceContentItemListener get message :{}", (Object)objStr);
                ListAudiencesResponse.Data.ContentItem contentItem = (ListAudiencesResponse.Data.ContentItem)JSONObject.parseObject((String)objStr, ListAudiencesResponse.Data.ContentItem.class);
                String audiencesId = contentItem.getId();
                String serialNumber = message.getKeys();
                QATestAcsClient client = new QATestAcsClient();
                ExportAudiencesRequest request = new ExportAudiencesRequest();
                request.setAccessId(this.accessId);
                request.setAudienceId(audiencesId);
                AudienceDownloadEntity audienceDownloadEntity = this.audienceDownloadMapper.selectByAudienceId(audiencesId);
                if (null == audienceDownloadEntity) {
                    throw new AudienceException(AudienceErrorCode.SELECT_BY_AUDIENCEID_ERROR, new Object[]{audiencesId});
                }
                request.setTenantId("bea3937b-1ff5-4aab-9a6a-f90514a0f584");
                ExportAudiencesResponse response = (ExportAudiencesResponse)client.getAcsResponse((AcsRequest)request);
                if (response.getSuccess().booleanValue()) {
                    AudienceDownloadLogBO audienceDownloadLogBO = new AudienceDownloadLogBO();
                    audienceDownloadLogBO.setInformStatus(Boolean.TRUE);
                    audienceDownloadLogBO.setAckStatus(Boolean.TRUE);
                    audienceDownloadLogBO.setRequestStatus(AudienceStatus.CREATE_STATUS_ING);
                    audienceDownloadLogBO.setDownloadPath(response.getData());
                    audienceDownloadLogBO.setSerialNumber(serialNumber);
                    Boolean logResult = this.searchService.updateAudienceDownloadLog(audienceDownloadLogBO);
                    AudienceDownloadBO audienceDownloadBO = new AudienceDownloadBO();
                    audienceDownloadBO.setSerialNumber(serialNumber);
                    audienceDownloadBO.setDataStatus(AudienceStatus.CREATE_ING);
                    Boolean downloadResult = this.searchService.updateAudienceDownload(audienceDownloadBO);
                    if (logResult.booleanValue() && downloadResult.booleanValue()) {
                        throw new AudienceException("updateAudienceDownloadLog updateAudienceDownload error serialNumber:{}", serialNumber);
                    }
                    break block5;
                }
                throw new AudienceException(AudienceErrorCode.EXPORT_AUDIENCES_REQUEST_ERROR, new Object[]{audiencesId, serialNumber});
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
    }
}

