/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.yw;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.yw.YwRechargeService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.baisonBase.facade.models.yw.YwRechargeCardInfoResponseVo;
import com.bizvane.customized.facade.interfaces.CusYwRechargeServiceFeign;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwResponseVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YwRechargeServiceImpl
implements YwRechargeService {
    private static final Logger log = LoggerFactory.getLogger(YwRechargeServiceImpl.class);
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CusYwRechargeServiceFeign cusYwRechargeServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;

    public ResponseData<PageInfo<YwRechargeCardInfoResponseVo>> getCardList(RechargeCardYwQueryVo rechargeCardYwQueryVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        log.info("bizvaneSessionId:{}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = rechargeCardYwQueryVo.getSysBrandId();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(brandId);
        memberInfoModel.setMemberCode(memberCode);
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        String phone = ((MemberInfoModel)memberInfoModelResponseData.getData()).getPhone();
        rechargeCardYwQueryVo.setPhone(phone);
        log.info("\u5f00\u59cb\u8c03\u7528cusYwRechargeServiceFeign.getCardList params:{}", (Object)JSON.toJSONString((Object)rechargeCardYwQueryVo));
        ResponseData pageInfoResponseData = this.cusYwRechargeServiceFeign.getCardList(rechargeCardYwQueryVo);
        log.info("cusYwRechargeServiceFeign.getCardList response:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
        List<Object> list = new ArrayList();
        if (pageInfoResponseData == null || pageInfoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || !CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoResponseData.getData()).getList())) {
            if (pageInfoResponseData.getCode() == SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode()) {
                log.info("\u7ebf\u4e0b\u50a8\u503c\u5361\u4e0d\u5b58\u5728:{}", (Object)rechargeCardYwQueryVo.getPhone());
                responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
                responseData.setMessage("\u7ebf\u4e0b\u50a8\u503c\u5361\u4e0d\u5b58\u5728");
                return responseData;
            }
            pageInfoResponseData.setCode(SysResponseEnum.FAILED.getCode());
            pageInfoResponseData.setMessage("\u8bf7\u4e0a\u4f20\u5361\u9762");
            return pageInfoResponseData;
        }
        list = ((PageInfo)pageInfoResponseData.getData()).getList().stream().map(ywRechargeCardInfoResponseVo -> {
            String styleUrl = ywRechargeCardInfoResponseVo.getStyleUrl();
            ywRechargeCardInfoResponseVo.setStyleUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)styleUrl));
            return ywRechargeCardInfoResponseVo;
        }).collect(Collectors.toList());
        ((PageInfo)pageInfoResponseData.getData()).setList(list);
        responseData.setData((Object)pageInfoResponseData);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return pageInfoResponseData;
    }

    public ResponseData<RechargeCardYwResponseVo> getCardInfo(RechargeCardYwQueryVo rechargeCardYwQueryVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = rechargeCardYwQueryVo.getSysBrandId();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(brandId);
        memberInfoModel.setMemberCode(memberCode);
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        String phone = ((MemberInfoModel)memberInfoModelResponseData.getData()).getPhone();
        rechargeCardYwQueryVo.setPhone(phone);
        return this.cusYwRechargeServiceFeign.getCardInfo(rechargeCardYwQueryVo);
    }
}

