/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.teddy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.teddy.TeddyCouponVerifyService;
import com.bizvane.appletservice.models.vo.TeddyCouponVerifyResultVo;
import com.bizvane.appletservice.models.vo.TeddyCouponVo;
import com.bizvane.appletserviceimpl.impl.teddy.util.AppletAESUnionIdUtil;
import com.bizvane.appletserviceimpl.impl.teddy.util.CheckResultUtil;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.centerstageservice.models.bo.StoreStaffRelBo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.StoreStaffRelReqVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreStaffRelServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailModelVO;
import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;
import com.bizvane.customized.facade.interfaces.CusTeddyCouponServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class TeddyCouponVerifyServiceImpl
implements TeddyCouponVerifyService {
    private static final Logger log = LoggerFactory.getLogger(TeddyCouponVerifyServiceImpl.class);
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CusTeddyCouponServiceFeign cusTeddyCouponServiceFeign;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private StoreStaffRelServiceRpc storeStaffRelServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private HttpServletRequest request;
    private static final String TEDDY_COUPON_TOKEN = "teddyCouponToken_";
    private String OPEN_ID_URL = "https://api.weixin.qq.com/sns/jscode2session";
    @Value(value="${teddy.couponMini.appId}")
    private String couponMiniAppId;
    @Value(value="${teddy.couponMini.appSecret}")
    private String couponMiniappSecret;
    @Value(value="${teddy.sysCompanyId}")
    private Long sysCompanyId;
    @Value(value="${teddy.sysBrandId}")
    private Long sysBrandId;

    public ResponseData<TeddyCouponVo> getPhone(String encryptedData, String iv, String code) {
        ResponseData responseData = new ResponseData();
        ResponseEntity forEntity = new RestTemplate().getForEntity(this.OPEN_ID_URL + "?appid=" + this.couponMiniAppId + "&secret=" + this.couponMiniappSecret + "&js_code=" + code + "&grant_type=authorization_code", String.class, new Object[0]);
        log.info("\u83b7\u53d6\u5fae\u4fe1\u63a5\u53e3\u8fd4\u56de\u6570\u636e==> {}", (Object)forEntity.toString());
        JSONObject jsonObject = JSONObject.parseObject((String)((String)forEntity.getBody()));
        log.info("\u6839\u636ecode\u83b7\u53d6\u7528\u6237openid,session_key,unionid==>{}", (Object)jsonObject.toJSONString());
        String session_key = jsonObject.getString("session_key");
        String openid = jsonObject.getString("openid");
        String bizvaneSessionIdForTeddyCoupon = null;
        String phoneNumber = null;
        String identity = null;
        Long sysCompnyId = null;
        Object sysBrandId = null;
        try {
            phoneNumber = AppletAESUnionIdUtil.getPhoneNumber((String)encryptedData, (String)session_key, (String)iv);
            log.info("\u624b\u673a\u53f7\u89e3\u5bc6\uff0cphone ==> {}", (Object)phoneNumber);
        }
        catch (Exception e) {
            log.error("CouponVerifyContorller getPhone error", (Throwable)e);
            throw LogicException.error((Integer)-1, (String)"\u624b\u673a\u53f7\u89e3\u5bc6\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((CharSequence)phoneNumber)) {
            ResponseData staffPoResponseData = this.staffServiceRpc.getStaffByPhone(this.sysCompanyId, phoneNumber);
            log.info("\u6839\u636e\u52a0\u5bc6\u624b\u673a\u53f7\u67e5\u8be2\u5458\u5de5\u4fe1\u606f \u901a\u8fc7phone\u83b7\u53d6\u5458\u5de5\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)staffPoResponseData));
            if (staffPoResponseData.getData() != null) {
                identity = "1";
                sysCompnyId = ((SysStaffPo)staffPoResponseData.getData()).getSysCompanyId();
                bizvaneSessionIdForTeddyCoupon = UUIDUtils.getUUID();
                this.redisTemplateService.stringSetValueAndExpireTime((Object)(TEDDY_COUPON_TOKEN + bizvaneSessionIdForTeddyCoupon), (Object)phoneNumber, 7776000000L);
            } else {
                identity = "2";
            }
        }
        TeddyCouponVo vo = TeddyCouponVo.builder().bizvaneSessionIdForTeddyCoupon(bizvaneSessionIdForTeddyCoupon).sysCompnyId(sysCompnyId).phone(phoneNumber).identity(identity).openId(openid).build();
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<TeddyCouponVerifyResultVo> verify(String couponCode) {
        String bizvaneSessionIdForTeddyCoupon = this.request.getHeader("bizvaneSessionIdForTeddyCoupon");
        if (StringUtils.isBlank((CharSequence)bizvaneSessionIdForTeddyCoupon)) {
            throw LogicException.error((Integer)-1, (String)"\u672a\u767b\u5f55");
        }
        String phone = (String)this.redisTemplateService.stringGetStringByKey((Object)(TEDDY_COUPON_TOKEN + bizvaneSessionIdForTeddyCoupon));
        if (StringUtils.isBlank((CharSequence)phone)) {
            throw LogicException.error((Integer)-1, (String)"\u672a\u767b\u5f55\u6216\u8eab\u4efd\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        ResponseData staffPoResponseData = this.staffServiceRpc.getStaffByPhone(this.sysCompanyId, phone);
        SysStaffPo staffPo = (SysStaffPo)CheckResultUtil.checkResponseData((ResponseData)staffPoResponseData, (String)"\u672a\u627e\u5230\u5458\u5de5\u4fe1\u606f");
        StoreStaffRelReqVo storeStaffRelReqVo = new StoreStaffRelReqVo();
        storeStaffRelReqVo.setSysCompanyId(this.sysCompanyId);
        storeStaffRelReqVo.setGuideIds(Arrays.asList(staffPo.getSysStaffId()));
        ResponseData staffRelBoResponseData = this.storeStaffRelServiceRpc.queryStoreIdByGuideId(storeStaffRelReqVo);
        StoreStaffRelBo staffRelBo = (StoreStaffRelBo)((List)CheckResultUtil.checkResponseData((ResponseData)staffRelBoResponseData, (String)"\u672a\u627e\u5230\u5458\u5de5\u5e97\u94fa\u4fe1\u606f")).get(0);
        ResponseData storePoResponseData = this.storeServiceRpc.getStoreById(staffRelBo.getSysStoreId());
        SysStorePo storePo = (SysStorePo)CheckResultUtil.checkResponseData((ResponseData)storePoResponseData, (String)"\u672a\u627e\u5230\u5458\u5de5\u5e97\u94fa\u4fe1\u606f");
        ResponseData couponDetailModelVOResponseData = this.couponQueryServiceFeign.findCouponByCouponCode(couponCode);
        CouponDetailModelVO couponDetailModelVO = (CouponDetailModelVO)CheckResultUtil.checkResponseData((ResponseData)couponDetailModelVOResponseData, (String)"\u4f18\u60e0\u5238\u4fe1\u606f\u9519\u8bef");
        StandardCouponUseRequestVo vo = new StandardCouponUseRequestVo();
        vo.setSysCompanyId(this.sysCompanyId);
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandByID(this.sysBrandId);
        vo.setBrandCode(((SysBrandPo)brandPoResponseData.getData()).getBrandCode());
        vo.setCouponCode(couponCode);
        vo.setStoreCode(storePo.getSysStoreOnlineCode());
        ResponseData responseData = this.cusTeddyCouponServiceFeign.verify(vo);
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            TeddyCouponVerifyResultVo couponVerifyResultVo = TeddyCouponVerifyResultVo.builder().money(couponDetailModelVO.getCouponEntityPO().getMoney()).discount(couponDetailModelVO.getCouponEntityPO().getDiscount()).couponName(couponDetailModelVO.getCouponEntityPO().getCouponName()).build();
            responseData.setData((Object)couponVerifyResultVo);
        }
        return responseData;
    }
}

